# pYSFReflector
Ceci est un réflecteur YSF implémenté en Python 3, principalement compatible avec le réflecteur g4klx.

## Fonctionnalités supplémentaires
### Liste de blocage améliorée
Grâce à la liste de blocage améliorée, vous pouvez désactiver les appels en fonction de :

* l'indicatif de l'expéditeur
* l'indicatif de la passerelle utilisée
* l'adresse IP de la passerelle

Cette règle désactive uniquement le trafic de la passerelle vers le réflecteur. Pour les passerelles et leurs adresses IP, des règles supplémentaires de blocage bidirectionnel sont implémentées. Elles peuvent être utilisées pour bloquer le trafic vers une passerelle spécifique (par exemple, dans les configurations multiréseaux, pour isoler un réseau pendant une durée déterminée en raison de conditions particulières ou pour bloquer le trafic vers des systèmes indésirables, comme des « ponts sauvages »).

### Blocage de la vérification de l'indicatif par expression régulière
Il est également possible d'utiliser (activé par défaut dans le fichier YSFReflector.ini) une vérification de l'indicatif basée sur une expression régulière pour vérifier la plausibilité de son format et de sa longueur.

Le résultat de cette vérification peut être annulé par une entrée de liste blanche dans la liste de blocage (par exemple : N0CALL est bloqué par défaut par cette expression, mais peut être autorisé dans des situations de pontage particulières).

### Matrice de mise en sourdine
Voici une matrice documentant le comportement des listes de blocage et la configuration de la vérification des expressions régulières (ER) :

![Muting-Matrix](img/Muting-Matrix.png "Muting-Matrix")

Dans ce tableau, les descriptions suivantes des valeurs des cellules devraient faciliter la compréhension :
* X : Toute valeur
* OUI : défini et correspond à l'indicatif/passerelle/adresse IP
* NON : non défini
* 1 : vérification via l'ER activée, fonctionnement normal
* 0 : vérification via l'ER désactivée, mais passe tout
* -1 : vérification via l'ER désactivée, mais passe uniquement la liste blanche

### Éviter les transmissions entrantes parallèles
Une fonctionnalité empêche également les transmissions parallèles, qui peuvent se produire si deux émetteurs transmettent simultanément. Le principe du « premier arrivé, premier servi » est appliqué : la station en deuxième position sera simplement mise en sourdine pour ne pas perturber le son.

### Fonctions Timeout et Wild-PTT (comme BM), voir .ini

`[Protections]`
`#timeout Tx [sec]`
`Timeout = 240`
`#Fenêtre de temps Wild PTT [sec]`
`WildPTTTime = 5`
`#Nombre de flux Wild PTT`
`WildPTTCount = 3`
`#Délai de réactivation de l'indicatif après timeout ou WildPTT [sec]`
`Treactivate = 1800`

En pratique : si vous dépassez le délai d'expiration (valeur Timeout)
(par exemple, si vous avez le PTT enfoncé dans votre poche), vous êtes « parqué » ; vous pouvez écouter, mais pas parler pendant la durée de « Treactivate », en secondes.

Même chose si le PTT est appuyé plusieurs fois de manière incontrôlée.

## Installation et mise à niveau faciles
Selon votre système d'exploitation et votre installation de Python 3, assurez-vous que les bibliothèques suivantes sont installées :

* bisect
* configparser
* datetime
* os
* queue
* re
* signal
* socket
* struct
* sys
* threading
* time

Dans la plupart des installations, ces paquets sont déjà installés. Sinon, vous pouvez les installer facilement avec votre gestionnaire de paquets système (par exemple, Debian : apt) ou en utilisant la commande pip3 install <package>.

Le fichier de configuration (YSFReflector.ini) est basé sur le fichier YSFReflector.ini d'origine de YSFReflector de G4KLX, mais avec de nouveaux éléments de configuration. Si vous connaissez l'ancien logiciel de réflecteur, sa configuration est simple.

## Bonnes pratiques d'installation
Pour une expérience utilisateur optimale, il est recommandé de configurer votre pYSFReflector avec le paramètre suivant dans le fichier YSFReflector.ini :

`FileRotate=0`

Cela permet d'avoir un seul fichier journal par programme, et sa rotation est effectuée par votre système Linux avec logrotate si configuré.

Si vous utilisez le tableau de bord basé sur PHP de DG9VH (https://github.com/dg9vh/YSFReflector-Dashboard), veuillez conserver la valeur `FileRotate=1`. Si vous utilisez la version basée sur les websockets (recommandée sur https://github.com/dg9vh/WSYSFDash), vous pouvez utiliser `FileRotate=0`. Veillez à synchroniser le fichier logtailer.ini du tableau de bord avec celui-ci.

Pour configurer la rotation des journaux sous Linux, consultez https://www.tecmint.com/install-logrotate-to-manage-log-rotation-in-linux/.

### Définition du niveau de fichier dans la journalisation
La journalisation au niveau de fichier s'effectue en trois niveaux de journalisation différents : de 0 à 2. Voici une brève description des journaux enregistrés à chaque niveau :

* Niveau 2 : Seuls les messages de démarrage et les messages d'erreur sont enregistrés.
* Niveau 1 : Tous les messages du niveau 2, plus les messages normaux créés lors de l'exécution du réflecteur. Ce niveau est recommandé si vous utilisez un tableau de bord avec le réflecteur.
* Niveau 0 : Tous les messages des niveaux 1 et 2, plus des informations supplémentaires sur les commandes à distance non nécessaires en situation normale. Ce niveau affiche le journal complet.