<?php
// Inclusion conditionnelle du fichier de configuration
if (file_exists("config/Bconfig.php")) {
    include "/var/www/html/config/Bconfig.php"; // ce fichier peut contenir le hachage du mot de passe
}
session_start();
// *** Mot de passe haché à comparer (idéalement stocké dans config) - $hashedSafetyPass = '$2y$10$exempledehashgénéréparpassword_hash'; -
$hashedSafetyPass = '$2y$10$KriJUK3KLRzpnoYMDqTG1eahKUUUw52.eb4kQNXJHdu7KPckHNpPS'; // Bulle1234
// *** Récupération possible d'un mot de passe alternatif haché
// $hashedPassInfoBulle = defined('PASSWORD_INFO_BULLE_HASH') ? PASSWORD_INFO_BULLE_HASH : null;

$PassPass = defined('PASSWORD_INFO_BULLE') ? PASSWORD_INFO_BULLE : null;
// ------------------------------------------------------------------------------------------------
if (isset($_POST['mdp'])) {
    $inputPassword = $_POST['mdp'];
    if (password_verify($inputPassword, $hashedSafetyPass)) {
        $_SESSION['auth'] = true;
     } elseif ($_POST['mdp'] === $PassPass) {
        $_SESSION['auth'] = true;
       } else {
        $erreur = "Mot de passe incorrect.";
      }
}

if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}

if (!isset($_SESSION['auth']) || $_SESSION['auth'] !== true) {
    ?>
    <!DOCTYPE html>
    <html><head><title>Connexion</title></head><body style="font-size: 2em;">
    <h1>Veuillez vous connecter</h1>
    <div style="font-size: 2em;"><?php if (isset($erreur)) echo "<p style='color:red;'>$erreur</p>"; ?></div>
    <form method="post">
        <div style="font-size: 2em;"><input style="font-size: 0.8em;" type="password" name="mdp" placeholder="Mot de passe" required /> <input style="font-size: 0.8em;" type="submit" value=" Se connecter " /></div>
    </form>
    </body></html>
    <?php
    exit;
}

function createConfigLines($data) {
    $lines = "";
    foreach ($data as $key => $value) {
        if ($key === 'cmd') continue;
        $lines .= "define('" . $key . "', " . var_export($value, true) . ");\n";
    }
    return $lines;
}

if (isset($_GET['cmd']) && $_GET['cmd'] == 'writeconfig') {
    $cleanedData = [];
    foreach ($_GET as $key => $value) {
        if ($key === 'cmd') continue;
        if (is_string($value)) {
            // remplacer guillemets doubles par simples pour éviter erreur syntaxe dans PHP
            $cleanedData[$key] = str_replace('"', "'", $value);
        } else {
            $cleanedData[$key] = $value;
        }
    }

    $content = "<?php\n# Auto-generated config\n\n" . createConfigLines($cleanedData) . "\n?>";

    if (!file_exists('./config')) {
        mkdir('./config', 0777, true);
    }
    file_put_contents('./config/Bconfig.php', $content);

    echo '<div class="alert alert-success"> Sauvegardée avec succès.</div>';
}

// Inclusion fichier config selon existance
if (file_exists('config/Bconfig.php')) {
    include 'config/Bconfig.php';
}
?>
<!-- Le reste de ton HTML et formulaire ici -->

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>YSFReflector-DashBoard VA2VDC </title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
</head>
<body style="background-color: #272727; width:100%;">

<?php
if (isset($_GET['cmd']) && $_GET['cmd'] == "writeconfig") {
    if (!file_exists('./config')) {
        if (!mkdir('./config', 0777, true)) {
            echo '<div class="alert alert-danger" role="alert">You forgot to give write permissions to your webserver user!</div>';
        }
    }
    $configfile = fopen("config/Bconfig.php", 'w');
    fwrite($configfile, "<?php\n");
    fwrite($configfile, "# This is an auto-generated Bconfig file!\n");
    fwrite($configfile, "# Be careful, when manually editing this!\n\n");
    fwrite($configfile, "# Bulle Config index.php and /include/BulleInfo1.php when manually editing this!\n\n");
    fwrite($configfile, createConfigLines($cleanedData)); // ($cleanedData)
    fwrite($configfile, "\n\n");
    fwrite($configfile, "# Setup from VA2VDC Daniel  2025-09-09 !\n\n");
    fwrite($configfile, "?>\n");
    fclose($configfile);
    echo '<div class="alert alert-success" role="alert"><h1>Votre Fichier De Configuration sauvegardée avec succès...!</h1></div>';
    echo '<p><a href="index.php"><h1> -- Votre Info Bulle est desormais disponible. </h1></a></p>';
} else {
?>

<div class="container text-center" style="background-color: #272727;">
    <h4 style="color: #22FE33;"> Veuillez remplir les informations necessaires ci-dessous </h4>
</div>

<form id="config" action="InfoBSetup.php" method="get" style="background-color: #272727;">
  <input type="hidden" name="cmd" value="writeconfig">

  <div class="container" style="background-color: #274767; border-radius: 20px; padding: 5px;">
    <div class="card" style="background-color: #6787A7; width:100%; shadow: 10px; border-radius: 15px;">
      <div class="card-header"><h2>Info Bulle 1 <a target="" href="../" style="color: #02FEFE; width:100%;">Configuration</a></h2></div>
      <div class="card-body">

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #FFAAAA;">Titre Info Bulle </span>
          <input type="text" value="<?php echo defined('TITRE_INFO_BULLE') ? constant('TITRE_INFO_BULLE') : 'Info Bulle 1'; ?>" name="TITRE_INFO_BULLE" class="form-control" placeholder="Info Bulle 1" style="width: 200px; background-color: #020202; color: #9FC7FF;">
        </div>

	<br>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #FFEE66;">Colonne A Ligne 1 </span>
          <input type="text" value="<?php echo defined('COL_A_LIGNE_A') ? constant('COL_A_LIGNE_A') : 'Reseau VE2MRC C4FM'; ?>" name="COL_A_LIGNE_A" class="form-control" placeholder="Reseau VE2MRC C4FM" style="width: 200px; background-color: #020202; color: #FCD066;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #FFEE66;">Colonne A Ligne 2 </span>
          <input type="text" value="<?php echo defined('COL_A_LIGNE_B') ? constant('COL_A_LIGNE_B') : 'Dimanche a 20h00'; ?>" name="COL_A_LIGNE_B" class="form-control" placeholder="Dimanche a 20h00" style="width: 200px; background-color: #020202; color: #FFEE66;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #FFEE66;">Colonne A Ligrn 3 </span>
          <input type="text" value="<?php echo defined('COL_A_LIGNE_C') ? constant('COL_A_LIGNE_C') : '147.120 Mhz + T103.5 hz'; ?>" name="COL_A_LIGNE_C" class="form-control" placeholder="147.120 Mhz + T103.5 hz" style="width: 200px; background-color: #020202; color: #66FC66;">
        </div>

	<br><br>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #DDEFF0;">Colonne B Ligne 1 </span>
          <input type="text" value="<?php echo defined('COL_B_LIGNE_A') ? constant('COL_B_LIGNE_A') : 'Reseau VE2MRC FM'; ?>" name="COL_B_LIGNE_A" class="form-control" placeholder="Reseau VE2MRC FM" value="Reseau VE2MRC FM" style="width: 200px; background-color: #020202; color: #FCD066;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #DDEFF0;">Colonne B Ligne 2 </span>
          <input type="text" value="<?php echo defined('COL_B_LIGNE_B') ? constant('COL_B_LIGNE_B') : 'Mercredi a 19h30'; ?>" name="COL_B_LIGNE_B" class="form-control" placeholder="Mercredi a 19h30" value="Merchedi a 19h30" style="width: 200px; background-color: #020202; color: #FFEE66;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #DDEFF0;">Colonne B Ligne 3 </span>
          <input type="text" value="<?php echo defined('COL_B_LIGNE_C') ? constant('COL_B_LIGNE_C') : '147.120 Mhz + T103.5 hz'; ?>" name="COL_B_LIGNE_C" class="form-control" placeholder="147.120 Mhz + T103.5 hz" style="width: 200px; background-color: #020202; color: #66FC66;">
        </div>

	<br><br>
	
        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 330px; background-color: #873737; color: #DDEFF0; font-size: 1.75em;">Changer Mot De Passe </span>
          <input type="text" value="<?php echo defined('PASSWORD_INFO_BULLE') ? constant('PASSWORD_INFO_BULLE') : ''; ?>" name="PASSWORD_INFO_BULLE" class="form-control" placeholder="Pass" style="width: 200px; background-color: #320202; color: #FF8676; font-size: 1.75em;">
        </div>

	<br>


        <div class="input-group">
          <button class="btn btn-primary"  style="width: 300px; background-color: #B0D0FF; color: #070707; padding: 4px; border-radius: 15px;" type="submit" form="config"> Sauvegarde La configuration Info Bulle </button>
        </div>

      </div>
    </div>
  </div>

</form>

<?php
}
?>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark static-top">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Info-Bulle-Config</a>
  </div>
</nav>


<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
</body>
</html>
