<?php
// Inclusion conditionnelle du fichier de configuration
if (file_exists("config/Bconfig.php")) {
    include "/var/www/html/config/Bconfig.php"; // ce fichier peut contenir le hachage du mot de passe
}

session_start();

// Mot de passe haché à comparer (idéalement stocké dans config)
$hashedSafetyPass = '$2y$10$KriJUK3KLRzpnoYMDqTG1eahKUUUw52.eb4kQNXJHdu7KPckHNpPS'; // Bulle1234
$PassPass = defined('PASSWORD_INFO_BULLE') ? PASSWORD_INFO_BULLE : null;

// Authentification
if (isset($_POST['mdp'])) {
    $inputPassword = $_POST['mdp'];
    if (password_verify($inputPassword, $hashedSafetyPass)) {
        $_SESSION['auth'] = true;
    } elseif ($_POST['mdp'] === $PassPass) {
        $_SESSION['auth'] = true;
    } else {
        $erreur = "Mot de passe incorrect.";
    }
}

if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}

if (!isset($_SESSION['auth']) || $_SESSION['auth'] !== true) {
    ?>
    <!DOCTYPE html>
    <html><head><title>Connexion</title></head><body style="font-size: 2em;">
    <h1>Veuillez vous connecter</h1>
    <div style="font-size: 2em;"><?php if (isset($erreur)) echo "<p style='color:red;'>$erreur</p>"; ?></div>
    <form method="post">
        <div style="font-size: 2em;">
            <input style="font-size: 0.8em;" type="password" name="mdp" placeholder="Mot de passe" required />
            <input style="font-size: 0.8em;" type="submit" value=" Se connecter " />
        </div>
    </form>
    </body></html>
    <?php
    exit;
}

// Fonction pour créer le contenu du fichier config PHP à partir des données
function createConfigLines($data) {
    $lines = "";
    foreach ($data as $key => $value) {
        if ($key === 'action' || $key === 'bulles') continue;
        $lines .= "define('" . $key . "', " . var_export($value, true) . ");\n";
    }
    return $lines;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'saveAll') {
    // Validation liste bulles
    $bulles_valides = ['BuleInfo1.php', 'BuleInfo2.php', 'BuleInfo3.php', 'BuleInfo4.php', 'BuleInfo5.php', 'BuleInfo6.php', 'disk.php', 'MyIp.php']; // ***** Valide Choix ** LstBulles.txt ***************
    $ordre_bulles = [];
    foreach ($_POST['bulles'] ?? [] as $bulle) {
        if ($bulle === '' || in_array($bulle, $bulles_valides)) {
            if ($bulle !== '') {
                $ordre_bulles[] = $bulle;
            }
        } else {
            echo '<div class="alert alert-danger">Sélection invalide détectée dans les bulles.</div>';
            exit;
        }
    }

    // Écriture fichier LstBulles.txt ***************************************************************** ecrituuuures  LstBulles.txt  **************************************
    file_put_contents('LstBulles.txt', implode("\n", $ordre_bulles));

    // Nettoyage des données pour config
    $cleanedData = [];
    foreach ($_POST as $key => $value) {
        if ($key === 'action' || $key === 'bulles') continue;
        if (is_string($value)) {
            // Éviter erreur avec guillemets doubles
            $cleanedData[$key] = str_replace('"', "'", $value);
        } else {
            $cleanedData[$key] = $value;
        }
    }

    // Génération contenu Bconfig.php  **************************************************************************** config/Bconfig.php *************************************
    $content = "<?php\n# Auto-générée fichier Bconfig \n\n" . createConfigLines($cleanedData) . "\n# Par Daniel Lafond VA2VDC ( Version du 20-Decembre-2025 ) \n\n?>";

    // Création dossier si besoin
    if (!file_exists('./config')) {
        mkdir('./config', 0777, true);
    }
    file_put_contents('./config/Bconfig.php', $content);

    echo '<div class="alert alert-success">Configuration et ordre des bulles sauvegardés avec succès.</div>';
    echo '<p><a href="./"><h1> -- Votre InfoBulle est desormais disponible. </h1></a></p>';
}

// Inclusion fichier config selon existance
if (file_exists('config/Bconfig.php')) {
    include 'config/Bconfig.php';
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8">

<!--   <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"> 

        <div style="text-align:center; margin: 0px; padding: 0px 15px 15px 15px;">
          <button class="btn btn-primary" style="background-color: #4A4846; color: #F7F0A0; width: 400px; padding: 5px; border-radius: 15px; font-size: 1.55em;" type="submit">
 -->

  <title>YSFReflector-DashBoard VA2VDC </title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
  <style>
    body { background-color: #272727; color: #112; }
    .container { margin-top: 20px; }
    .input-group-text { width: 200px; }

.btn.btn-primary {
    background: #4A4846 !important;
    color: #F7F0A0 !important;
    width: 400px;
    padding: 5px;
    border-color: #000;
    border-radius: 15px;
    font-size: 1.55em !important;
    cursor: pointer;
    transition: background: 0.3s;
}

.btn.btn-primary:hover {
    background: #3A3836 !important;
    cursor: pointer;
    color: #0F0 !important; 
    border-color: #0F5;
}

a:hover {
    background: #6284A6 !important;
    cursor: pointer;
    color: #0F0 !important; 
    border-color: #0C5;
}


  </style>
</head>
<body>

<div class="container text-center" style="background-color: #272727;">
    <h4 style="color: #22FC33;"> Veuillez remplir les informations necessaires ci-dessous </h4>
</div>

<form id="config" action="InfoBSetup.php" method="post" style="background-color: #272727;">
  <input type="hidden" name="action" value="saveAll">

  <div class="container" style="background-color: #274767; border-radius: 20px; padding: 5px;">
    <div class="card" style="background-color: #6787A7; width:100%; shadow: 10px; border-radius: 15px;">
      <div class="card-header"><h2>Info Bulle <a target="" href="../" style="color: #F6B422; width:100%;">Configuration Clic ici pour sortir </a></h2></div>
      <div class="card-body">

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #EFEFEF;">Titre Info Bulle </span>
          <input type="text" value="<?php echo defined('TITRE_INFO_BULLE') ? constant('TITRE_INFO_BULLE') : 'Info Bulle 1'; ?>" name="TITRE_INFO_BULLE" class="form-control" placeholder="Radio Amateur Bienvenue Chez VA2VDC" style="width: 200px; background-color: #020202; color: #9FC7FF;">
        </div>

	<br>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #EEDD66;">Colonne A Ligne 1 </span>
          <input type="text" value="<?php echo defined('COL_A_LIGNE_A') ? constant('COL_A_LIGNE_A') : 'Reseau VE2MRC C4FM'; ?>" name="COL_A_LIGNE_A" class="form-control" placeholder="Reseau VE2MRC C4FM" style="width: 200px; background-color: #020202; color: #FCD066;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #EEDD66;">Colonne A Ligne 2 </span>
          <input type="text" value="<?php echo defined('COL_A_LIGNE_B') ? constant('COL_A_LIGNE_B') : 'Dimanche a 20h00'; ?>" name="COL_A_LIGNE_B" class="form-control" placeholder="Dimanche a 20h00" style="width: 200px; background-color: #020202; color: #FFEE66;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #EEDD66;">Colonne A Ligrn 3 </span>
          <input type="text" value="<?php echo defined('COL_A_LIGNE_C') ? constant('COL_A_LIGNE_C') : '442.450 Mhz + / 448.275 Mhz +'; ?>" name="COL_A_LIGNE_C" class="form-control" placeholder="442.450 Mhz + / 448.275 Mhz +" style="width: 200px; background-color: #020202; color: #66FC66;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #EEDD66;">Colonne A Ligrn 4 </span>
          <input type="text" value="<?php echo defined('COL_A_LIGNE_D') ? constant('COL_A_LIGNE_D') : 'Yeasu C4FM'; ?>" name="COL_A_LIGNE_D" class="form-control" placeholder="Yeasu" style="width: 200px; background-color: #020202; color: #66FC66;">
        </div>

	<br>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #CCEEFF;">Colonne B Ligne 1 </span>
          <input type="text" value="<?php echo defined('COL_B_LIGNE_A') ? constant('COL_B_LIGNE_A') : 'Reseau VE2MRC FM'; ?>" name="COL_B_LIGNE_A" class="form-control" placeholder="Reseau VE2MRC FM" value="Reseau VE2MRC FM" style="width: 200px; background-color: #020202; color: #FCD066;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #CCEEFF;">Colonne B Ligne 2 </span>
          <input type="text" value="<?php echo defined('COL_B_LIGNE_B') ? constant('COL_B_LIGNE_B') : 'Mercredi a 19h30'; ?>" name="COL_B_LIGNE_B" class="form-control" placeholder="Mercredi a 19h30" value="Merchedi a 19h30" style="width: 200px; background-color: #020202; color: #FFEE66;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #CCEEFF;">Colonne B Ligne 3 </span>
          <input type="text" value="<?php echo defined('COL_B_LIGNE_C') ? constant('COL_B_LIGNE_C') : '147.120 Mhz + T103.5 hz'; ?>" name="COL_B_LIGNE_C" class="form-control" placeholder="147.120 Mhz + T103.5 hz" style="width: 200px; background-color: #020202; color: #66FC66;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #CCEEFF;">Colonne B Ligne 4 </span>
          <input type="text" value="<?php echo defined('COL_B_LIGNE_D') ? constant('COL_B_LIGNE_D') : 'Fusion'; ?>" name="COL_B_LIGNE_D" class="form-control" placeholder="System Fusion" style="width: 200px; background-color: #020202; color: #66FC66;">
        </div>

	<br>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #FFCCEE;">Colonne C Ligne 1 </span>
          <input type="text" value="<?php echo defined('COL_C_LIGNE_A') ? constant('COL_C_LIGNE_A') : 'Reseau VE2MRC SSB'; ?>" name="COL_C_LIGNE_A" class="form-control" placeholder="Reseau SSB" value="YSF Reflecteur & Tableau De Bord ( Version VA2VDC )" style="width: 200px; background-color: #020202; color: #FCD066;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #FFCCEE;">Colonne C Ligne 2 </span>
          <input type="text" value="<?php echo defined('COL_C_LIGNE_B') ? constant('COL_C_LIGNE_B') : 'Vendredi a 19h00'; ?>" name="COL_C_LIGNE_B" class="form-control" placeholder="Vendredi a 19h00" value="Clic Sur L'image Antenne Pour Telecharger" style="width: 200px; background-color: #020202; color: #FFEE66;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #FFCCEE;">Colonne C Ligne 3 </span>
          <input type="text" value="<?php echo defined('COL_C_LIGNE_C') ? constant('COL_C_LIGNE_C') : '144.250 Mhz '; ?>" name="COL_C_LIGNE_C" class="form-control" placeholder="Boot Image Pour SDHC & USB" style="width: 200px; background-color: #020202; color: #66FC66;">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 200px; background-color: #274767; color: #FFCCEE;">Colonne C Ligne 4 </span>
          <input type="text" value="<?php echo defined('COL_C_LIGNE_D') ? constant('COL_C_LIGNE_D') : ''; ?>" name="COL_C_LIGNE_D" class="form-control" placeholder="Capacite 16GB Ou Plus" style="width: 200px; background-color: #020202; color: #66FC66;">
        </div>

	<br><br>
	
        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 330px; background-color: #873737; color: #DDEFF0; font-size: 1.75em;">Changer Mot De Passe </span>
          <input type="text" value="<?php echo defined('PASSWORD_INFO_BULLE') ? constant('PASSWORD_INFO_BULLE') : ''; ?>" name="PASSWORD_INFO_BULLE" class="form-control" placeholder="Info1234" style="width: 200px; background-color: #320202; color: #FF8676; font-size: 1.75em;">
        </div>

	<br>

    <!-- Choix Bulles -->
     <div style="background-color: #121212; border-radius: 15px;">


     <div style="background-color: #121212; margin: 0px; padding: 15px 15px 0px 15px;">

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 50%; background-color: #274767; color: #DDEFF0; font-size: 1.55em; border: 0px;">
          <label for="bulles1" class="input-group-text" style="width:auto; background-color: #6737A7; color: #DDEFF0; font-size: 0.8em;">list Position 1 :</label>
           <select name="bulles[]" id="bulles1">
            <option value="">-- Aucun --</option>
            <option value="BuleInfo1.php">Col A Seul</option>
            <option value="BuleInfo2.php">Col A & B</option>
            <option value="BuleInfo3.php">Col A B & C</option>
            <option value="BuleInfo4.php">Col B & C</option>
            <option selected value="BuleInfo5.php">Col C Seul</option>
            <option value="BuleInfo6.php">Col B Seul</option>
            <option value="disk.php">DiskInfo</option>
           </select>
	  </span>
<!--        </div>

        <div class="input-group mb-3"> -->
          <span class="input-group-text" style="width: 50%; background-color: #274767; color: #DDEFF0; font-size: 1.55em; border: 0px;">
          <label for="bulles2" class="input-group-text" style="width:auto; background-color: #6737A7; color: #DDEFF0; font-size: 0.8em;">List Position 2 :</label>
           <select name="bulles[]" id="bulles2">
            <option selected value="">-- Aucun --</option>
            <option value="BuleInfo1.php">Col A Seul</option>
            <option value="BuleInfo2.php">Col A & B</option>
            <option value="BuleInfo3.php">Col A B & C</option>
            <option value="BuleInfo4.php">Col B & C</option>
            <option value="BuleInfo5.php">Col C Seul</option>
            <option value="BuleInfo6.php">Col B Seul</option>
            <option selected value="disk.php">DiskInfo</option>
           </select>
	  </span>
        </div>
    </div>

     <div style="background-color: #121212; margin: 0px; padding: 0px 15px 0px 15px;">
        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 50%; background-color: #274767; color: #DDEFF0; font-size: 1.55em; border: 0px;">
          <label for="bulles3" class="input-group-text" style="width:auto; background-color: #6737A7; color: #DDEFF0; font-size: 0.8em;">List Position 3 :</label>
           <select name="bulles[]" id="bulles3">
            <option selected value="">-- Aucun --</option>
            <option value="BuleInfo1.php">Col A Seul</option>
            <option value="BuleInfo2.php">Col A & B</option>
            <option value="BuleInfo3.php">Col A B & C</option>
            <option value="BuleInfo4.php">Col B & C</option>
            <option value="BuleInfo5.php">Col C Seul</option>
            <option value="BuleInfo6.php">Col B Seul</option>
            <option value="disk.php">DiskInfo</option>
            <option value="MyIp.php">MyIp</option>
           </select>
	  </span>
<!--        </div>

        <div class="input-group mb-3"> -->
          <span class="input-group-text" style="width: 50%; background-color: #274767; color: #DDEFF0; font-size: 1.55em; border: 0px;">
          <label for="bulles4" class="input-group-text" style="width:auto; background-color: #6737A7; color: #DDEFF0; font-size: 0.8em;">List position 4 :</label>
           <select name="bulles[]" id="bulles4">
            <option selected value="">-- Aucun --</option>
            <option value="BuleInfo1.php">Col A Seul</option>
            <option value="BuleInfo2.php">Col A & B</option>
            <option value="BuleInfo3.php">Col A B & C</option>
            <option value="BuleInfo4.php">Col B & C</option>
            <option value="BuleInfo5.php">Col C Seul</option>
            <option value="BuleInfo6.php">Col B Seul</option>
            <option value="disk.php">DiskInfo</option>
            <option value="MyIp.php">MyIp</option>
           </select>
	 </span>
        </div>
    </div>

        <div style="text-align:center; margin: 0px; padding: 0px 15px 15px 15px;">
          <button class="btn btn-primary" type="submit"> Sauvegarder la configuration complète </button>
        </div>
       </div>
      </div>
    </div>
  </div>
</form>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark static-top">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Info-Bulle-Config</a>
  </div>
</nav>

<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
</body>
</html>
