<!DOCTYPE html>
<html lang="fr">
<head>
   <meta charset="UTF-8">
   <title>Fichiers disponibles</title>
    <style>
        body {
         margin: 10px;
         padding: 0px;
	 font-family: Arial, sans-serif;
	 background: #252525;
	 color: white;
	 }

h1 {
    margin: 0px;
    background: #02527F;
    color: #02E2FF;
    font-size: 2em;
    padding: 20px;
    text-shadow: 1px 1px 5px #000;
    border: 3px solid #01708F; /* turquoise plus foncé */
    border-radius: 6px;        /* arrondi optionnel pour adoucir */
}

        table {
	 background: #959595;
	 border-radius: 8px;
	 width: 100%;
	 margin-top: 0px;
	 border-collapse: collapse;
	 font-size: 1.35em;
	 box-shadow: inset 0 0 5px rgba(0,0,0,0.7);
    	 }

        th, td {
	 padding: 10px 15px;
	 text-align: left;
	 border-bottom: 1px solid #002;
	 text-shadow: 0px 0px 1px #000;
	 }

        tr:hover {
	 background: #B5B5B5;
	 }

        a {
	 color: #68176A;
	 text-decoration: none;
	 }

        .icon {
	 margin-right: 8px;
         font-size: 32px; /* ou 2em, 3rem, etc. */
/*         color: #48C0FC; */ /* par exemple */
         }

        .icon-folder {
            font-size: 48px; /* plus gros pour l'emoji dossier */
         }

.upload-form {
    display: flex;              /* Permet l’alignement en colonnes */
    flex-wrap: wrap;            /* Garde la possibilité de passer en ligne multiple si écran étroit */
    justify-content: space-between;
    align-items: flex-start;
    height: auto;               /* Plus besoin de hauteur fixe */
    background: #349;
    font-size: 2em;
    padding: 15px;
    text-shadow: 1px 1px 5px #000;
    border-radius: 8px;
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
    margin: 0;
    gap: 20px;                   /* espace horizontal entre les colonnes */
}
.upload-column {
    flex: 1;                     /* Chaque colonne prend la même largeur */
    min-width: 200px;            /* Largeur minimale par colonne */
}
.upload-column label {
    display: block;
    margin-bottom: 8px;
}

        #identifiant {
            box-sizing: border-box;
            font-size: 0.7em;
            padding: 5px;
            text-shadow: 1px 1px 2px #000;
        }

        label {
            background: #349;
            color: #acf;
            font-size: 0.8em;
            padding: 5px;
            text-shadow: 1px 1px 5px #000;
        }

        input[type="text"] {
            background: #0F203F; color: #AFA; font-size: 0.6em; text-shadow: 1px 1px 5px #000; padding: 5px;
        }

        /* Cacher le input file natif */
        input[type="file"] { 
            display: none;   
        }                    

        input[type="file"] {
            background: #352525; color: #FDD; font-size: 0.6em; text-shadow: 1px 1px 5px #000; padding: 5px;
        }

       /* Style du bouton "Choisir un fichier" */
        input[type="file"]::file-selector-button {
            background-color: #0278c1; color: #224; border: none; padding: 8px 15px; border-radius: 6px; cursor: pointer; font-weight: bold; transition: background-color 0.3s ease;
        }

        input[type="file"]::file-selector-button:hover {
            background-color: #029ca0;
            color: #8f9;
        }

        .custom-file-label {
            background-color: #2298E2;
            color: #224;
            padding: 8px 15px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: arial;
            display: inline-block;
            margin-right: 10px;
            text-shadow: 1px 1px 2px #000;
            transition: background-color 0.3s ease;
        }

        .custom-file-label:hover {
            background-color: #12acb0;
            color: #8f9;
            text-shadow: 1px 1px 5px #000;
        }

        /* Zone affichant le nom du fichier choisi */
        #file-chosen {
            background: #60360;
            margin-left: 15px;
            font-style: italic;
            color: #D33;
            vertical-align: middle;
         }

        input[type="submit"] {
            background: #02DAFA; border: none; font-size: 0.7em; text-shadow: 1px 1px 5px #222; padding: 8px 15px;
            color: #003; border-radius: 5px; cursor: pointer; margin-left: 5px;
        }

        input[type="submit"]:hover { background: #00EEA0; }

   </style>
</head>
<body>

    <h1>Fichiers disponibles / <a href="../" style="background: #02527F; color: #EFE8AA; text-shadow: 1px 1px 6px #000; padding: 3px;">Clic Ici Retour Reflecteur </a></h1>

<div class="upload-form">
  <form action="" method="POST" enctype="multipart/form-data" style="width:100%;">
    
    <!-- Première ligne : identifiant + sélection de fichier -->
    <div style="display:flex; align-items:center; flex-wrap:wrap; gap:15px; margin-bottom:10px;">
        <div style="flex:0 0 220px;">  <!-- Colonne identifiant plus étroite -->
            <label for="identifiant">Identifiant :</label>
            <input type="text" name="identifiant" id="identifiant" required
                   style="width:100%; background:#0F203F; color:#AFA; font-size:0.6em; text-shadow:1px 1px 5px #000; padding:5px; border-radius:4px;">
        </div>

        <div style="flex:1;">  <!-- Colonne fichier -->
            <label for="fichier" style="margin-right:10px;">Ajouter :</label><br>
            <input type="file" name="fichier" id="fichier" style="display:none;">
            <label for="fichier" class="custom-file-label">Sélectionner un fichier</label>
            <span id="file-chosen"> ___________________ </span>
        <input type="submit" name="envoyer" value="Téléverser"
               style="background:#02DAFA; border:none; font-size:0.7em; text-shadow:1px 1px 5px #222; padding:8px 15px;
                      color:#003; border-radius:5px; cursor:pointer;">
        </div>
    </div>

    <!-- Deuxième ligne : bouton centré -->
    <div style="text-align:center;">
    </div>

  </form>
</div>

<script>
const inputFile = document.getElementById('fichier');
const fileChosen = document.getElementById('file-chosen');

inputFile.addEventListener('change', () => {
    if (inputFile.files.length > 0) {
        fileChosen.textContent = inputFile.files[0].name;
        fileChosen.style.color = '#48C0FC';
    } else {
        fileChosen.textContent = 'Aucun fichier choisi';
        fileChosen.style.color = '#a00';
    }
});
</script>

<?php
// * ini_set('display_errors', 1);
// * ini_set('display_startup_errors', 1);
// * error_reporting(E_ALL);


//   **********  Gestion du Téléversement  *************

if (isset($_POST['envoyer']) && isset($_FILES['fichier'])) {
    $identifiant = trim($_POST['identifiant']);
    $cheminUtilisateurs = __DIR__ . '/../config/ExplorerUsers.txt';

if (file_exists($cheminUtilisateurs)) {
    $utilisateurs = file($cheminUtilisateurs, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
} else {
    // Gérer le cas où le fichier n'existe pas, par ex. bloquer l'upload ou charger une liste vide
    $utilisateurs = [];
    echo "<p style='color:#E45;'>Fichier des utilisateurs introuvable, upload désactivé.</p>";
}

    if (in_array($identifiant, $utilisateurs)) {
        $nomFichier = basename($_FILES['fichier']['name']);
        $destination = __DIR__ . '/' . $nomFichier;

        if (move_uploaded_file($_FILES['fichier']['tmp_name'], $destination)) {
            // Récupérer l'adresse IP réelle de l'utilisateur
            function getClientIP() {
                $ipaddress = '';
                if (getenv('HTTP_CLIENT_IP'))
                    $ipaddress = getenv('HTTP_CLIENT_IP');
                else if(getenv('HTTP_X_FORWARDED_FOR'))
                    $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
                else if(getenv('HTTP_X_FORWARDED'))
                    $ipaddress = getenv('HTTP_X_FORWARDED');
                else if(getenv('HTTP_FORWARDED_FOR'))
                    $ipaddress = getenv('HTTP_FORWARDED_FOR');
                else if(getenv('HTTP_FORWARDED'))
                    $ipaddress = getenv('HTTP_FORWARDED');
                else if(getenv('REMOTE_ADDR'))
                    $ipaddress = getenv('REMOTE_ADDR');
                else
                    $ipaddress = 'UNKNOWN';
                return $ipaddress;
            }

            $ip = getClientIP();
            $date = date('Y-m-d H:i:s');
            $logLine = "[$date] Identifiant: $identifiant - IP: $ip - Fichier: $nomFichier" . PHP_EOL;
            $logDir = __DIR__ . '/../log';
            $logFile = $logDir . '/Explorer_Upload.log';

         if (!is_dir($logDir)) {
            mkdir($logDir, 0755, true); // crée le dossier logs (récursivement) avec droits 755
         }
            // Ecrire dans le fichier log (ex: log/upload.log)
            file_put_contents($logFile, $logLine, FILE_APPEND | LOCK_EX);
            echo "<p style='color: #1E1;'>Fichier '$nomFichier' Téléversé avec Succès.</p>";
        } else {
            echo "<p style='color: #E56;'>Erreur Lors du Téléversement.</p>";
        }
    } else {
        echo "<p style='color: #F67;'>Identifiant Non Reconnu, Upload Refusé.</p>";
    }
}
?>

<?php
  function getFileIcon($filename) {
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    if ($ext === '') { // sans extension, c'est un dossier
        return '<span class="icon icon-folder">📁</span>';
    }
    $icons = [
        'Dossier' => '📁',
        'jpg' => '🖼️',
        'png' => '🖼️',
        'gif' => '🖼️',
        'bmp' => '🖼️',
        'pdf' => '📄',
        'txt' => '📄',
        'php' => '🐘',
        'js' => '🐘',
        'html' => '🐘',
        'css' => '🐘',
        'rar' => '📦',
        'zip' => '📦',
        'tar' => '📦',
        'gz' => '📦',
        'img' => '💽',
        'bat' => '💾',
        'bt' => '💾',
        'disk' => '📀',
        'iso' => '📀',
        'doc' => '📄',
        'docx' => '📄',
        'xls' => '📊',
        'xlsx' => '📊',
        'sh' => '🖥️',
        'py' => '💻',
        // ajoute d'autres extensions et icônes ici selon besoin
    ];
    return $icons[$ext] ?? '📄';  // dossier/fichier par défaut
  }

?>
<?php
$folderIcon = '📂';
?>

    </div>


<?php
// --- Vérification d'identifiant pour suppression ---
if (isset($_POST['supprimer']) && !empty($_POST['delete'])) {
    $identifiant_suppression = trim($_POST['identifiant_supprimer']);
    $cheminSuppresseurs = __DIR__ . '/../config/suppresseurs.txt';

    if (file_exists($cheminSuppresseurs)) {
        $suppresseurs = file($cheminSuppresseurs, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    } else {
        $suppresseurs = [];
        echo "<p style='color:orange;'>⚠️ Fichier des autorisations de suppression introuvable.</p>";
    }

    if (in_array($identifiant_suppression, $suppresseurs)) {
        foreach ($_POST['delete'] as $fileToDelete) {
            $path = __DIR__ . '/' . basename($fileToDelete);
            if (is_file($path)) {
                unlink($path);
                echo "<p style='color: red;'>Fichier supprimé : " . htmlspecialchars($fileToDelete) . "</p>";
            }
        }
    } else {
        echo "<p style='color:#F67;'>❌ Identifiant de suppression non reconnu. Aucune suppression effectuée.</p>";
    }
}
?>

<!-- Formulaire de suppression sécurisé -->
<form action="" method="POST" style="margin-top:0; background:#234; padding:15px; border-radius:0 0 8px 8px; color:#ACE;">
    <div style="margin-bottom:10px;">
        <label for="identifiant_supprimer" style="font-size:1.1em;">Identifiant suppression :</label><br>
        <input type="text" name="identifiant_supprimer" id="identifiant_supprimer"
               required
               style="background:#0F203F; color:#AFA; font-size:1em; padding:5px; width:300px; margin-top:5px; border-radius:5px;">
    <input type="submit" name="supprimer" value="Supprimer les fichiers cochés">
    </div><br>

    <!-- Tableau de fichiers -->
    <table style="color: #252595; font-size: 1.35em;">
        <tr style="background-color: #999999; color: #151515; font-size: 1.45em;">
            <th> <span class="icon icon-folder"><?php echo $folderIcon; ?></span> Fichier en Téléchargements   </th>
            <th> Taille Octets </th>
            <th> Taille Bytes </th>
            <th> Dernière Modification </th>
            <th>Supprimer</th>
        </tr>

<?php
        $files = scandir(__DIR__);
        foreach ($files as $file) {
            if ($file == '.' || $file == '..' || $file == basename(__FILE__)) continue;
            if (is_file($file)) {
                $icon = getFileIcon($file);
                echo '<tr>';
                echo '<td><span class="icon">'.$icon.'</span> <a href="'.htmlspecialchars($file).'">'.htmlspecialchars($file).'</a></td>';
		$size = filesize($file);
		if ($size >= 1073741824) {
		    echo '<td>'.round($size / 1073741824, 3).' Go </td>';
		} elseif ($size >= 1024 * 1024) {
		    echo '<td>'.round($size / 1048576, 3).' Mo </td>';
		} elseif ($size >= 1024) {
		    echo '<td>'.round($size / 1024, 3).' Ko </td>'; 
		} else {
		    echo '<td>'.$size.' Octets</td>';
		}

		if ($size >= 1000000000) {
		    echo '<td>'.round($size / 1000000000, 3).' GB </td>';
		} elseif ($size >= 1000000) {
		    echo '<td>'.round($size / 1000000, 3).' MB </td>';
		} elseif ($size >= 1000) {
		    echo '<td>'.round($size / 1000, 3).' KB </td>'; 
		} else {
		    echo '<td>'.$size.' Bytes</td>';
		}
                echo '<td>'.date("d/m/Y H:i", filemtime($file)).'</td>';
                echo '<td><input type="checkbox" name="delete[]" value="'.htmlspecialchars($file).'"></td>';
                echo '</tr>';
            }
        }
        ?>
    </table>
</form>
</body>
</html>
