<?php
header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('America/Toronto');

function formatElapsedTime($seconds) {
    if ($seconds < 60) return $seconds . " s";
    if ($seconds < 3600) return floor($seconds / 60) . " min";
    $h = floor($seconds / 3600);
    $m = floor(($seconds % 3600) / 60);
    return $h . "h " . $m . "min";
}
?>


    <style>
        body { 
            font-family: Arial, sans-serif; 
            font-size: 18px; background-color: #102030; 
        }
        pre { 
            background: #071727; 
            padding: 0em 1em 1em 1em; 
            border-radius: 6px; 
            font-family: Consolas, monospace; 
            overflow-x: auto;
        }

        .fichier1 {
	    color: #A060EA; 
	    background-color: #012;
	} /* couleur spéciale pour fichier1 */

        .fichier2 {
            color: #DF963F; 
            background-color: #012;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
	} /* couleur spéciale pour fichier2 */

       .fichier3 {
	    color: #20CC88; 
	    background-color: #012;
	} /* couleur spéciale pour fichier3 */

       .fichier4 {
	    color: #FF0000; 
	    background-color: #012;
	} /* couleur spéciale pour fichier4 */

        .logglobal {
            color: #20CC88;
            background-color: #012;
            padding: 15px;
            border-radius: 8px;
            margin-top: 30px;
        }

        #toggleGraphBtn {
            margin-left: 20px;
            padding: 8px 16px;
            background-color: #444;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1em;
        }

        body { font-family: Arial, sans-serif; font-size: 18px; background-color: #102030; color: #fff; }
        pre { background: #071727; padding: 1em; border-radius: 6px; font-family: Consolas, monospace; overflow-x: auto; }
        .fichier2 { color: #DF963F; background-color: #012; padding: 15px; border-radius: 8px; margin-bottom: 20px; }
        #toggleGraphBtn { margin-left: 20px; padding: 8px 16px; background-color: #444; color: #fff; border: none; border-radius: 4px; cursor: pointer; font-size: 1em; }
        #graphContainer { margin-top: 10px; display: none; }
    </style>
</head>
<body>
    <h1 style="background-color: #203040; color: #00B0C0; padding: 20px;">
        Visites Logs <a href="./" style="background-color: #203040; color: #A0B0C0; padding: 20px;"> - Clic Ici Retour </a>
    </h1>

<?php
echo '<pre>';
$fichier2 = '/var/www/html/log/VisitesIP.txt';
$maintenant = time();
$t24h = 86400;
$t12h = 43200;
$t6h  = 21600;
$t2h  = 7200;

$couleurA = "#20FF50"; // < 2h
$couleurB = "#D7D720"; // 2h–6h
$couleurC = "#D7A020"; // 6h–12h
$couleurD = "#90550F"; // 12h–24h

$visitesParHeure = array_fill(0, 24, 0);
$NBVisiteurs24Hrs = 0;
$lignesRecentes = [];

if (file_exists($fichier2)) {
    $lignes = file($fichier2, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    echo '<div style="padding:10px; background:#071727; border-radius:8px; margin-bottom:10px;">';
    echo '<span style="color:' . $couleurA . ';">● Moins de 2 h</span> &nbsp;&nbsp;';
    echo '<span style="color:' . $couleurB . ';">● De 2 h a 6 h</span> &nbsp;&nbsp;';
    echo '<span style="color:' . $couleurC . ';">● De 6 h a 12 h</span> &nbsp;&nbsp;';
    echo '<span style="color:' . $couleurD . ';">● De 12 h a 24 h</span>';
    echo '</div>';

    echo '<pre>';
    foreach ($lignes as $ligne) {
        $parties = explode('|', $ligne);
        if (count($parties) >= 2) {
            $ip = trim($parties[0]);
            $timestamp = (int)trim($parties[1]);
            $delta = $maintenant - $timestamp;

            if ($delta <= $t24h) {
                $lignesRecentes[] = $ligne;
                $NBVisiteurs24Hrs++;

                if ($delta <= $t2h) {
                    $couleur = $couleurA;
                } elseif ($delta <= $t6h) {
                    $couleur = $couleurB;
                } elseif ($delta <= $t12h) {
                    $couleur = $couleurC;
                } else {
                    $couleur = $couleurD;
                }

                $tempsEcoule = formatElapsedTime($delta);
                echo '<span style="color:' . $couleur . ';">' . htmlspecialchars($ip) . ' | ' . $tempsEcoule . "</span>\n";

                // Heure locale automatique avec décalage été/hiver géré
                $heure = (int)date('G', $timestamp);
                $visitesParHeure[$heure]++;
            }
        }
    }
    echo '</pre>';

    file_put_contents($fichier2, implode("\n", $lignesRecentes) . "\n");
} else {
    echo "Fichier introuvable.";
}

$labels = [];
for ($i = 0; $i < 24; $i++) {
    $labels[] = sprintf('%02dh', $i);
}

?>
<p style="text-align:center;color:#00B0C0;">Heure locale Québec : <?= date('Y-m-d H:i') ?></p>
<?php
echo '</pre>';
?>




