<?php
// BlackListRecord.php : mise à jour automatique blacklist

$logFile = 'log/Visites.log';
// $blacklistDir = 'log';
$blacklistDir = 'BlackList';

if (!is_dir($blacklistDir)) {
    mkdir($blacklistDir, 0755, true);
}

$blacklistFile = $blacklistDir . '/BlackList.txt';
$ipDenyFile    = $blacklistDir . '/IPDeny.txt'; // fichier additionnel
$whitelistLog  = $blacklistDir . '/Whitelist.log';

// Création automatique des fichiers au besoin
foreach ([$blacklistFile, $ipDenyFile, $whitelistLog] as $file) {
    if (!file_exists($file)) {
        file_put_contents($file, "");
    }
}

// Limite du nombre de lignes dans le Whitelist.log
function limiterWhitelistLog($file, $maxLines = 20) {
    if (!file_exists($file)) return;
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $total = count($lines);
    if ($total > $maxLines) {
        $lines = array_slice($lines, -$maxLines);
        file_put_contents($file, implode(PHP_EOL, $lines) . PHP_EOL);
    }
}

// --------------------------------------------------------
// Liste blanche (adresses IP sûres à ne jamais bloquer)
$whitelist = [
    "127.0.0.1",         // localhost
    "192.168.0.1",       // exemple réseau local
    "10.0.0.5",          // exemple IP perso
    // ajoute ici d'autres IP sûres...
];


$motifsRouges = [
    "bang2012@tutanota.de", "() { :; };", "/bin/bash -c", "curl/7.64.1", "Unknown agent",
 "python-requests/", "Go-http-client/", "zgrab/0.x", "l9tcpid/v1", 
   "curl/7.64.1", "masscan/1.0", "45.135.194.", "zgrab/0.x", "curl/7.29.0", 
    // autres motifs rouges...
];

$ipsRouges = [];
$whitelistDetected = [];

// Lecture du log pour détecter des IP suspectes
if (file_exists($logFile)) {
    $lines = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        foreach ($motifsRouges as $motif) {
            if (stripos($line, $motif) !== false) {
                if (preg_match('/\|\s*(\d+\.\d+\.\d+\.\d+)\s*\|/', $line, $matches)) {
                    $ip = $matches[1];
                    if (!in_array($ip, $whitelist)) {
                        $ipsRouges[$ip] = true;
                    } else {
                        $whitelistDetected[$ip] = true;
                    }
                }
                break;
            }
        }
    }

     // Mémorise les IP ignorées dans Whitelist.log
    if (!empty($whitelistDetected)) {
        $timestamp = date('Y-m-d H:i:s');
        $logEntries = [];
        foreach (array_keys($whitelistDetected) as $ip) {
            $logEntries[] = "[$timestamp] Ignorée (whitelist): $ip";
        }
        file_put_contents($whitelistLog, implode(PHP_EOL, $logEntries) . PHP_EOL, FILE_APPEND);
        limiterWhitelistLog($whitelistLog, 20); // Limite à 20 lignes
    }
 
 // Ajout des IP au fichier blacklist existant
    $existingIPs = [];
    if (file_exists($blacklistFile)) {
        $existingIPs = file($blacklistFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    }

    // Fusion, suppression des doublons et écriture propre
    $merged = array_unique(array_merge($existingIPs, array_keys($ipsRouges)));
    // Suppression des IP de la whitelist
    $merged = array_diff($merged, $whitelist);
    sort($merged);
    file_put_contents($blacklistFile, implode("\n", $merged));
}

// --------------------------------------------------------


// Lecture de la BlackList et IPDeny.txt
$blacklist = file($blacklistFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$extraIPs = file($ipDenyFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

// Fusion, nettoyage et exclusion de la whitelist
$blacklist = array_unique(array_merge($blacklist, $extraIPs)); // ****** Error 106  ***
$blacklist = array_diff($blacklist, $whitelist);
sort($blacklist);
// Mise à jour finale du fichier blacklist
file_put_contents($blacklistFile, implode("\n", $blacklist));

// --------------------------------------------------------


// Génération du .htaccess
$htaccessFile = '.htaccess';
$htaccessContent = "# .htaccess généré automatiquement\n<Limit GET POST>\norder allow,deny\n";
foreach ($blacklist as $ip) {

    if (filter_var($ip, FILTER_VALIDATE_IP)) {
        $htaccessContent .= "deny from $ip\n";
    }
}
$htaccessContent .= "allow from all\n</Limit>\n";
file_put_contents($htaccessFile, $htaccessContent);

// Pas d'affichage (script silencieux)
// Pas d'echo pour traitement en sourdine
// ***  include __DIR__ . '/BlackListRecord.php';  // ***
// ### env x='() { :;}; echo vulnerable' bash -c "echo this is a test" ###
// *** /log/BlackList.txt
// *** /.htaccess