<?php
// BlackListRecord.php : mise à jour automatique blacklist

$logFile = 'log/Visites.log';
// $blacklistDir = 'log';
$blacklistDir = __DIR__ . '/../BlackList';

if (!is_dir($blacklistDir)) {
    mkdir($blacklistDir, 0755, true);
}

$blacklistFile = $blacklistDir . '/BlackList.txt';
$ipDenyFile    = $blacklistDir . '/IPDeny.txt'; // fichier additionnel
$whitelistLog  = $blacklistDir . '/Whitelist.log';

// Création automatique des fichiers au besoin
foreach ([$blacklistFile, $ipDenyFile, $whitelistLog] as $file) {
    if (!file_exists($file)) {
        file_put_contents($file, "");
    }
}

// Limite du nombre de lignes dans le Whitelist.log
function limiterWhitelistLog($file, $maxLines = 20) {
    if (!file_exists($file)) return;
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $total = count($lines);
    if ($total > $maxLines) {
        $lines = array_slice($lines, -$maxLines);
        file_put_contents($file, implode(PHP_EOL, $lines) . PHP_EOL);
    }
}

// --------------------------------------------------------
// Liste blanche (adresses IP sûres à ne jamais bloquer)
$whitelist = [
    "127.0.0.1",         // localhost
    "192.168.0.1",       // exemple réseau local
    "10.0.0.5",          // exemple IP perso
    // ajoute ici d'autres IP sûres...
];


$motifsRouges = [
    "bang2012@", "() { :; };", "/bin/bash -c", "curl/7.64.1", "Unknown agent",
 "python-requests/", "Go-http-client/", "zgrab/0.x", "l9tcpid/v1", 
   "curl/7.", "masscan/1.0", "45.135.194.", "zgrab/0.x", "{jndi:ldap", 
    // autres motifs rouges...
];

$ipsRouges = [];
$whitelistDetected = [];

// Lecture du log pour détecter des IP suspectes
if (file_exists($logFile)) {
    $lines = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        foreach ($motifsRouges as $motif) {
            if (stripos($line, $motif) !== false) {
                if (preg_match('/\|\s*(\d+\.\d+\.\d+\.\d+)\s*\|/', $line, $matches)) {
                    $ip = $matches[1];
                    if (!in_array($ip, $whitelist)) {
                        $ipsRouges[$ip] = true;
                    } else {
                        $whitelistDetected[$ip] = true;
                    }
                }
                break;
            }
        }
    }

     // Mémorise les IP ignorées dans Whitelist.log
    if (!empty($whitelistDetected)) {
        $timestamp = date('Y-m-d H:i:s');
        $logEntries = [];
        foreach (array_keys($whitelistDetected) as $ip) {
            $logEntries[] = "[$timestamp] Ignorée (whitelist): $ip";
        }
        file_put_contents($whitelistLog, implode(PHP_EOL, $logEntries) . PHP_EOL, FILE_APPEND);
        limiterWhitelistLog($whitelistLog, 20); // Limite à 20 lignes
    }
 
 // Ajout des IP au fichier blacklist existant
    $existingIPs = [];
    if (file_exists($blacklistFile)) {
        $existingIPs = file($blacklistFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    }

    // Fusion, suppression des doublons et écriture propre
    $merged = array_unique(array_merge($existingIPs, array_keys($ipsRouges)));
    // Suppression des IP de la whitelist
    $merged = array_diff($merged, $whitelist);
    sort($merged);
    file_put_contents($blacklistFile, implode("\n", $merged));
}

// --------------------------------------------------------


// Lecture de la BlackList et IPDeny.txt
$blacklist = file($blacklistFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$extraIPs = file($ipDenyFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

// Fusion, nettoyage et exclusion de la whitelist
$blacklist = array_unique(array_merge($blacklist, $extraIPs)); // ****** Error 106  ***
$blacklist = array_diff($blacklist, $whitelist);
sort($blacklist);
// Mise à jour finale du fichier blacklist
file_put_contents($blacklistFile, implode("\n", $blacklist));

// --------------------------------------------------------

// ****************************** FUSION BANY IP  IPDeny.php *****************************

$sourceFile = $blacklistFile;
$destinationFile = $ipDenyFile;

// Lire le contenu des deux fichiers dans des tableaux  **  BlackList.txt  ** et ** IPDeny.txt  **
$sourceLines = file($sourceFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$destLines = file($destinationFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

// Fusionner les deux tableaux
$mergedLines = array_merge($destLines, $sourceLines);

// Supprimer les doublons
$uniqueLines = array_unique($mergedLines);

// Optionnel : trier les adresses IP (facultatif)
sort($uniqueLines);

// Écrire le résultat dans le fichier destination *** IPDeny.txt ***
file_put_contents($destinationFile, implode(PHP_EOL, $uniqueLines) . PHP_EOL);

// ****************************** FUSION BANY IP  IPDeny.php *****************************





// **************** .htaccess Pour Apache2  ***************************

// Génération du .htaccess
$ipDenyPath = __DIR__ . '/../BlackList/IPDeny.txt';
$htaccessFile = __DIR__ . '/../.htaccess';
$htaccessFileSafety = __DIR__ . '/htaccessDenyIP';

$htaccessContent = "# .htaccess généré automatiquement\n<Limit GET POST>\norder allow,deny\n";
// Lire les IP depuis IPDeny.txt
if (file_exists($ipDenyPath)) {
    $denyIPs = file($ipDenyPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($denyIPs as $ip) {
        if (filter_var($ip, FILTER_VALIDATE_IP)) {
            $htaccessContent .= "deny from $ip\n";
        }
    }
}

$htaccessContent .= "allow from all\n</Limit>\n";

// Écriture du fichier final à la racine
    $LastWriteFile = __DIR__ . '/../BlackList/last_write_time.NB';
    $now = time();
if (file_exists($LastWriteFile)) {
    $LastWrite = (int)file_get_contents($LastWriteFile);
} else {
    $LastWrite = 0;
}
if (($now - $LastWrite) >= 900) { // 900 Secondes = 15 Minutes
    file_put_contents($htaccessFile, $htaccessContent);
    file_put_contents($htaccessFileSafety, $htaccessContent);
    file_put_contents($LastWriteFile, $now);
}
// **************** .htaccess Pour Apache2  ***************************
// Pas d'echo pour traitement en sourdine
// ***  include __DIR__ . '/BlackListRecord.php';  // ***
// ### env x='() { :;}; echo vulnerable' bash -c "echo this is a test" ###
// *** /log/BlackList.txt
// *** /.htaccess