<?php
session_start();
// Chronométrage du début
$St2Time  = microtime(true);

// ************ IP LOG ************
function getClientIP(): string {
    $ipKeys = [
        'HTTP_X_FORWARDED_FOR',
        'HTTP_CLIENT_IP', 
        'HTTP_X_CLUSTER_CLIENT_IP',
        'REMOTE_ADDR'
    ];
    foreach ($ipKeys as $key) {
        if (!empty($_SERVER[$key])) {
            foreach (explode(',', $_SERVER[$key]) as $ip) {
                $ip = trim($ip);
                if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {
                    return $ip;
                }
            }
        }
    }
    return $_SERVER['REMOTE_ADDR'] ?? 'IP non trouvée';
}

$ip = getClientIP();
$logDir = __DIR__ . '/log/';
$fileCount = $logDir . 'Compteur.NB';
$fileVisits = $logDir . 'VisitesIP.txt';
$fileLog = $logDir . 'Visites.log';

// Création du dossier log si absent
if (!is_dir($logDir)) {
    mkdir($logDir, 0775, true);
}

// Initialisation des fichiers si absents
if (!file_exists($fileCount)) {
    file_put_contents($fileCount, "0");
}
if (!file_exists($fileVisits))
 {
    file_put_contents($fileVisits, "");
}

$count = (int)file_get_contents($fileCount);
$timeNow = time();
$delay = 86400; // 24 heures en secondes

// Lecture et nettoyage des visites existantes
$lines = file_exists($fileVisits) 
    ? file($fileVisits, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) 
    : [];

$newLines = [];
$found = false;

foreach ($lines as $line) {
    [$ipLogged, $timestamp] = explode('|', $line) + [null, 0];
    $timestamp = (int)$timestamp;

    // Garder uniquement les visites valides (< 24h)
    if ($timeNow - $timestamp <= $delay) {
        if ($ip === $ipLogged) {
            $found = true;
        }
        $newLines[] = $ipLogged . '|' . $timestamp;
    }
}

// Nouvelle visite : ajout + incrémentation
if (!$found) {
    $count++;
    file_put_contents($fileCount, $count);
    $newLines[] = $ip . '|' . $timeNow;

    // Log de la visite
    $date = date('Y-m-d H:i:s');
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown agent';
    $logLine = "$date | $ip | $userAgent" . PHP_EOL;
    file_put_contents($fileLog, $logLine, FILE_APPEND);
}

// Réécriture du fichier nettoyé
file_put_contents($fileVisits, implode("\n", $newLines) . "\n");

// echo "Nombre de visites : " . $count;
// ************ IP LOG & Compteurs ************

include __DIR__ . "/include/BlackListRecord.php"; // *** BlacklistIP ***
 
//  -*-*--*-*-*-*-*-*-*-*-  Démarrage de session  -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

// Liste des couleurs valides (optionnel, à garder pour validation)
$bgColor0Options = ['#030304', '#838484', '#074C88', '#DEDFDF'];
$bgColor2Options = ['#333434', '#043464', '#532363', '#838393', '#430303', '#E7E7E7', '#274D8F', '#EFA74F'];

// Chemin relatif vers colors.json
$jsonFile = __DIR__ . '/css/colors.json';

// Lecture du fichier colors.json (si présent)
//  *** if(file_exists($jsonFile)) {
//  ***     $savedColors = json_decode(file_get_contents($jsonFile), true); //  ***** $bgColor0  & $bgColor2  *******
//  *** } else {
//  ***      $savedColors = [];
//  ***  }

// Lecture du JSON
$jsonColors = [];
if(file_exists($jsonFile)) {
    $jsonColors = json_decode(file_get_contents($jsonFile), true); //  ***** $bgColor0  & $bgColor2  *******
}

// Récupérer couleur de la session, sinon du JSON, sinon valeur hardcodée
$bgColor0 = $_SESSION['bgColor0'] ?? ($jsonColors['bgColor0'] ?? $bgColor0Options[0]); // *** $bgColor0Options[0] *** $saveColors[$bgColor0] ***
$bgColor2 = $_SESSION['bgColor2'] ?? ($jsonColors['bgColor2'] ?? $bgColor2Options[0]); // *** $bgColor2Options[0] *** $saveColors[$bgColor2] ***

// Sécuriser la valeur avec validation
if (!in_array($bgColor0, $bgColor0Options)) $bgColor0 = $bgColor0Options[0]; // *****  $bgColor0Options[0]
if (!in_array($bgColor2, $bgColor2Options)) $bgColor2 = $bgColor2Options[0]; // *****  $bgColor2Options[0]

// Lecture et validation des couleurs depuis session ou valeurs par défaut
$selectedBgColor0 = $_SESSION['bgColor0'] ?? $bgColor0Options[2];
if (!in_array($selectedBgColor0, $bgColor0Options)) {
    $selectedBgColor0 = $bgColor0Options[2];
}

$selectedBgColor2 = $_SESSION['bgColor2'] ?? $bgColor2Options[0];
if (!in_array($selectedBgColor2, $bgColor2Options)) {
    $selectedBgColor2 = $bgColor2Options[0];
}

// Inclusions indispensables, ne pas toucher
if (file_exists("config/config.php")) include "config/config.php";
if (file_exists("config/Bconfig.php")) include "config/Bconfig.php";
include "include/tools.php";
include "include/functions.php";
include "include/init.php";
include "version.php";

// Début du HTML --**--**--**--**--**--**--**--**--**--
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
      <title><?php echo getConfigItem("Info", "Name", $configs); ?> - Reflecteur-YSF Tableau-De-Bord VA2VDC</title>

      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <meta name="description" content="YSF-Reflecteur Tableau de Bord Fr Par VA2VDC">
      <meta name="author" content="DG9VH, KC1AWV, VA2VDC">
      <meta http-equiv="refresh" content="<?php echo REFRESHAFTER; ?>">
  <!-- So refresh works every time -->
      <meta http-equiv="expires" content="0">

<style>
  :root {
    --BGround-color2: <?= $bgColor2 ?>;
    --BGround-color0: <?= $bgColor0 ?>;
  }
</style>

  <script>
    // Passe la variable PHP REFRESHAFTER en JS
    var countdown = <?php echo REFRESHAFTER; ?>;
    function updateCountdown() {
      var countdownElement = document.getElementById('countdown-seconds');
      if (countdown > 0) {
        countdownElement.textContent = countdown;
        countdown--;
      } else {
        countdownElement.textContent = 0;
      }
    }
    // Met à jour toutes les secondes **********    -------------------    1000 a 1080  ----  ADJ Trim *-*************
    setInterval(updateCountdown, 1080);
    // Initialisation affichage
    window.onload = updateCountdown;
  </script>


  <!-- Bootstrap core CSS -->
      <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
      <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">

  <!-- Bootstrap core JavaScript -->
  <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>

  <!-- Datatables -->
      <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">

  <!-- Inclure le script de la librairie emoji-picker-element -->
      <!-- script type="module" src="https://cdn.jsdelivr.net/npm/emoji-picker-element@^1/index.js"></script --> 
  <script type="module" src="/js/index.js"></script>

  <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>

    <!-- Le reste de ta partie head -->
    <link rel="stylesheet" href="/css/custom.css.php?v=<?=filemtime(__DIR__.'/css/custom.css.php')?>">
    <link rel="stylesheet" href="/css/custom.css">
</head>

<body class="navbar" style="background-color: #131414; color: #FF2222;2">

<!-- Ton contenu HTML -->
<?php
if ($bgColor0 == "#030304") {
    $ColorA = "#F0804F";
    $ColorB = "#E8301F";
    $ColorC = "#50505F";
} elseif ($bgColor0 == "#074C88") {
    $ColorA = "#F0F0FF";
    $ColorB = "#30A0FF";
    $ColorC = "#A0A0AF";
} else {
    $ColorA = "#001048";
    $ColorB = "#481000";
    $ColorC = "#50505F";
}
?>

 <!-- Navigation ------------------------------------------------------   -->
<?php checkSetup(); ?>
 <!-- Page Content  ------------------- Haut de Page -------------------------------------------------  -->
<div class="boz">
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor0 ?>; color: #9090DC"> <!-- fixed-top  or static-top   -->
    <div class="container-fluid" style=" color: #9090DF";>
      <span class="float:left">
        <a class="navbar-brand" href="#" style=" color: <?= $ColorA ?>";>-Reflecteur-YSF- <?php echo getConfigItem("Info", "Name", $configs); ?> / <?php echo getConfigItem("Info", "Description", $configs); ?> (#<?php echo getConfigItem("Info", "Id", $configs); ?>)</a>
      </span>
      <span class="navbar-brand float:center" style=" color: <?= $ColorC ?>";>
        <a id="chatLink" target="_new" href="/SChatSetup.php" style=" color: <?= $ColorC ?>";>Version: </a><a id="chatLink" target="_new" href="/InfoBSetup.php" style=" color: <?= $ColorC ?>";><?php  echo getYSFReflectorVersion(); ?></a>
      </span>
      <span class="navbar-brand float:right" style=" color: <?= $ColorB ?>";>
     <a id="chatLink" target="_new" href="/couleurs.php" style=" color: <?= $ColorB ?>";>  System Fusion IP </a>
     </span>
    </div>
  </nav>

 <!-- Page Content  ------------------- Tx Info / logo  -----------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
    <div class="container-fluid">
     <div class="col-12">

       <div class="ROW couleur1-forcee">
        <div class="flex-container1">

          <div class="boxy">
               <!--   <span class="navbar-brand float:center"> -->
          <?php
             include "include/txinfo.php";
          ?>
              <!--   </span> -->
          </div>

            <!-- Page Content  -- Col ------ Logo ----------  -->
          <div class="col-2.4">
           <div class="boxy">
       <!--   <span class="navbar-brand float:right">  title="T l charger le PNG OU PDF OU Ect..."   -->
           <?php if (LOGO !== "") { ?>
           <a id="chatLink" target="_new" href="/DlFiles/">
           <img src="<?php echo LOGO ?>" width="220px" height="250" style="width:220px; border-radius:15px; box-shadow: 0px 0px 10px 3px #000; padding:2px; background:#404040;" border="3" hspace="5" vspace="5" align="justify-content-left">
           </a>
           <?php } else { ?>
                 <h3 class="text-center">YSF-Reflecteur<br />Tableau-De-Bord</h3>
           <?php } ?>
       <!--   </span> -->
           </div>
         </div>
       </div>
       </div>
    </div>
  </div>
 </nav>

 <!-- Page Content  ------------------- Info / System / Chat --------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
   <div class="container-fluid">
    <div class="col-12">
     <div class="ROW couleur2-forcee">

      <div class="flex-container">
       <div class="box"><?php include "include/sysinfo.php"; ?></div>

      <!-- Page Content  -- Col ------ Chat ---------  -->
       <div class="col">
	 <?php
	     $unread = file_exists(__DIR__ . "/SMessages_Readed.txt") ? file_get_contents(__DIR__ . "/SMessages_Readed.txt") : "0";
	 if ($unread == "1") {
	     $css_class = "clignote1";
	 } else if ($unread == "2") {
	     $css_class = "clignote2";
	 } else if ($unread == "3") {
	     $css_class = "clignote3";
	 } else if ($unread == "4") {
	     $css_class = "clignote4";
	 } else if ($unread >= "5") {
	     $css_class = "clignote5";
	 } else {
	     $css_class = "";
	 }
 	 ?>
<div class="box" nowrap>
  <button id="btChanger1" class="col-7" style="box-shadow: 0px 0px 10px 3px #000; text-shadow: 1px 1px 2px #000;">
    Info / Systeme / 
    <a id="chatLink" target="_new" href="/chatme.php" class="<?php echo $css_class; ?>">
      Chat <?php if ($unread != "0") {echo $unread;} ?>
    </a>
  </button>

  <a id="logsLink" target="_new" href="/Visites.php"
    style="display: inline-block; background-color: #223252; border-radius: 20px; box-shadow: 0px 0px 10px 3px #000; color: #EFA74F; font-size: 1.3em; padding: 5px 15px 10px 15px; text-decoration: none;">
    Logs
  </a>

  <a id="logsLink" target="_new" href="/DenyIP.php"
    style="display: inline-block; background-color: #223252; border-radius: 20px; box-shadow: 0px 0px 10px 3px #000; color: #4FB7FF; font-size: 1.3em; padding: 5px 15px 10px 15px; text-decoration: none;">
    ADM
  </a>

  <div id="LstBulle" class="col8" style="box-shadow: 0px 0px 10px 3px #000; border-radius: 15px;"></div>
</div>

       <script>
          let fichiers1 = [];
          let index1 = 0;
         function chargerLstBulle() {
          if (fichiers1.length === 0) return; // S curit  si fichiers pas charges
             fetch('loaderBulle.php?fichier1=' + fichiers1[index1])
             .then(response1 => response1.text())
             .then(html => {
             document.getElementById('LstBulle').innerHTML = html;
           });
         }
          fetch('LstBulles.php')
          .then(response1 => response1.json())
          .then(data => {
             fichiers1 = data;       // On remplace la liste statique par la liste du serveur
             chargerLstBulle();      // On charge la premi re infobulle
          });
        document.getElementById('btChanger1').addEventListener('click', function() {
          index1 = (index1 + 1) % fichiers1.length;
          chargerLstBulle();
        });
      </script>

    </div>
   </div>
  </div>
 </nav>

 <!-- Page Content  ------------------- Passerelle GW ---------------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" id="blocE" style="display:block; width:100%; margin-bottom:0px; background-color: <?= $bgColor2 ?>;">
     <div class="container-fluid">
      <div class="col-12"><div class="row" style="size:210;"><div class="col"><?php include "include/gateways.php"; ?></div></div></div>
     </div>
  </nav>

 <!-- Page Content  ------------------- LH ---------------------------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" id="blocD" style="display:block; width:100%; margin-bottom:0px; background-color: <?= $bgColor2 ?>;">
     <div class="container-fluid">
      <div class="col-12"><div class="row" style="size:210;"><div class="col"><?php include "include/lh.php"; ?></div></div></div>

  </nav>

 <!-- Page Content  ------------------- AllHeard  &  OldHeard  -------------------------------------------- --> 
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">

 <div style="text-align:center; margin:20px 20px 20px 30px; background-color: <?= $bgColor2 ?>;">
  <button class="btn btn-success" onclick="afficher('A')"style="background-color: #EB5837; color: #F9FCFF; margin:5px 3px 5px 3px; font-size: 1.6em; text-shadow: 0px 0px 3px #011; padding: 3px 10px 3px 10px; box-shadow: 0px 0px 5px 2px #000; border-radius:10px;">Off </button>
  <button class="btn btn-primary" onclick="afficher('B')" style="background-color: #838393; color: #DFEFFF; margin:5px 3px 5px 3px; font-size: 1.6em; text-shadow: 0px 0px 3px #011; padding: 3px 20px 3px 20px; box-shadow: 0px 0px 5px 2px #000; border-radius:10px;">Garphique Aujourd’hui </button>
  <button class="btn btn-primary" onclick="afficher('C')"style="background-color: #237AFA; color: #F8F8FF; margin:5px 3px 5px 3px; font-size: 1.6em; text-shadow: 0px 0px 3px #011; padding: 3px 20px 3px 20px; box-shadow: 0px 0px 5px 2px #000; border-radius:10px;">Graphique Historique </button>
  <button class="btn btn-warning" onclick="afficher('AB')"style="background-color: #EBC877; color: #292C2F; margin:5px 3px 5px 3px; font-size: 1.6em; text-shadow: 0px 0px 3px #011; padding: 3px 25px 3px 25px; box-shadow: 0px 0px 5px 2px #000; border-radius:10px;">Les Deux Graphiques </button>
  <button class="btn btn-secondary" onclick="afficher('E')"style="background-color: #353535; color: #585858; margin:5px 3px 5px 3px; font-size: 1.6em; text-shadow: 0px 0px 3px #011; padding: 3px 10px 3px 10px; box-shadow: 0px 0px 5px 2px #000; border-radius:10px;"><span id="countdown-seconds" style="color: #DFAF55;" ></span></button>
 </div>

<div id="blocA" style="display:none; width:100%; margin-bottom:30px; background-color: <?= $bgColor2 ?>;">
  <iframe src="" width="100%" height="10" frameborder="0"
          style="border-radius:10px; box-shadow:0 0 10px #000;"></iframe>
</div>











<script>
function afficher(mode) {
  const blocA = document.getElementById('blocA');
  const blocB = document.getElementById('blocB');
  const blocC = document.getElementById('blocC');
  const blocD = document.getElementById('blocD');
  const blocE = document.getElementById('blocE');

  if (mode === 'A') {        // Fermee Tout ------------------------
    blocA.style.display = 'none';
    blocB.style.display = 'none';
    blocC.style.display = 'none';
    blocD.style.display = 'block';
    blocE.style.display = 'block';
 } else if (mode === 'B') { // mode 'B' pour afficher Aujourd Hui ---
    blocA.style.display = 'none';
    blocB.style.display = 'block';
    blocC.style.display = 'none';
    blocD.style.display = 'none';
    blocE.style.display = 'block';
 } else if (mode === 'C') { // mode 'C' pour afficher Historique  ---
    blocA.style.display = 'none';
    blocB.style.display = 'none';
    blocC.style.display = 'block';
    blocD.style.display = 'block';
    blocE.style.display = 'block';
  } else  if (mode === 'E') { // mode 'E' Off GW et Liste Entendu 
    blocA.style.display = 'none';
    blocB.style.display = 'block';
    blocC.style.display = 'none';
    blocD.style.display = 'none';
    blocE.style.display = 'none';
  } else {                  // mode 'AB' pour afficher les deux
    blocA.style.display = 'none';
    blocB.style.display = 'block';
    blocC.style.display = 'block';
    blocD.style.display = 'block';
    blocE.style.display = 'block';
  }
}
</script>


  </nav> 



 <!-- Page Content  ------------------- AllHeard ------------------------------ Display none ou block  -------------------------------- --> 
  <nav class="navbar navbar-expand-lg navbar-dark static-top" id="blocB" style="display:none; width:100%; margin-bottom:0px; background-color: <?= $bgColor2 ?>;">
     <!-- div class="container-fluid" -->
      <div class="col-12"><div class="row" style="size:210;"><!-- div class="col" --><iframe src="idxSW1.php" width="100%" height="675" frameborder="0"
          style="border-radius:10px; box-shadow:0 0 10px #000;"></iframe><!-- /div --><!-- /div --></div>

  </nav> 

 <!-- Page Content  ------------------- oldAllHeard --------------------------- Display none ou block  -------------------------------- -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" id="blocC" style="display:none; width:100%; margin-bottom:0px; background-color: <?= $bgColor2 ?>;">
     <div class="container-fluid">
      <div class="col-12"><div class="row" style="size:210;"><div class="col"><?php include "include/oldheard2.php"; ?></div></div></div>


  </nav>





 <!-- Page Content  --------------LH & OLD HEARD --- Lst2 -------------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
    <div class="container-fluid">

     <div class="col-12"><div class="row" style="size:210;"><div class="col">
      <!-- button id="changer2" style="background-color: #237AFA; color: #89CFFF; font-size: 1.8em; text-shadow: 1px 1px 4px #011; padding: 3px 35px 3px 35px; box-shadow: 0px 0px 10px 3px #000; border-radius:10px;">Historiques Lists / Tous Les Temps</button -->
      <!-- button id="changer4" style="background-color: #454545; color: #858585; font-size: 1.8em; text-shadow: 1px 1px 4px #011; padding: 3px 35px 3px 35px; box-shadow: 0px 0px 10px 3px #000; border-radius:10px;"><a id="ADM" target="_new" href="/include/EditFilePlus.php" class="ADM"> ADM</a></button -->
       <!-- div id="Lst2"></div><div id="Lst4"></div -->

        <script>
           let fichiers2 = [];
           let index2 = 0;
         function chargerLst2() {
          if (fichiers2.length === 0) return; // S curit  si fichiers pas charg s
            fetch('loader2.php?fichier2=' + fichiers2[index2])
            .then(response2 => response2.text())
            .then(html => {document.getElementById('Lst2').innerHTML = html;});
          }
           fetch('Lst2.php')
           .then(response2 => response2.json())
           .then(data => {fichiers2 = data; chargerLst2();});
           document.getElementById('changer2').addEventListener('click', function() {index2 = (index2 + 1) % fichiers2.length; chargerLst2();});
        </script>

        <script>
           let fichiers4 = [];
           let index4 = 0;
         function chargerLst4() {
          if (fichiers4.length === 0) return; // S curit  si fichiers pas charg s
            fetch('loader4.php?fichier4=' + fichiers4[index4])
            .then(response4 => response4.text())
            .then(html => {document.getElementById('Lst4').innerHTML = html;});
          }
           fetch('Lst4.php')
           .then(response4 => response4.json())
           .then(data => {fichiers4 = data; chargerLst4();});
           document.getElementById('changer4').addEventListener('click', function() {index4 = (index4 + 1) % fichiers4.length; chargerLst4();});
        </script>

     </div></div></div>

  </nav>


<script>
window.addEventListener('message', function(event) {
  const data = event.data;
  if (typeof data === 'string' && data.startsWith('resize::')) {
    const height = data.replace('resize::', '');
    // Par exemple, ici pour iframe avec id blocA
    const iframeA = document.getElementById('blocB').querySelector('iframe');
    if (iframeA) iframeA.style.height = height + 'px';

    const iframeB = document.getElementById('blocC').querySelector('iframe');
    if (iframeB) iframeB.style.height = height + 'px';
  }
});
</script>


 <!-- Page Content  -------------------- Bas De Page -----------------------------------------------------  -->
     <nav class="flex-container" style="background-color: #484A4A; color: #9090DC">
      <div class="flex-container" style="background-color: #484A4A; color: #FFF8EF;">
       <?php
        $lastReload = new DateTime();
        $lastReload->setTimezone(new DateTimeZone(TIMEZONE));
        echo "YSF-Dashboard Ver.: ".VERSION." | M.a.J. le : ".$lastReload->format('d-m-Y,  H:i:s')." (".TIMEZONE.")";
       ?> | <a href="<?php if (!file_exists('YSF_D_Board-FR.tar.gz')) {echo"http://amiatous.ddns.net:8081/indexC.php";} else {echo "YSF_D_Board-FR.tar.gz";}
       ?>">Votre Copie Ici:</a> <-Fr-  -En-> <a href="https://github.com/dg9vh/YSFReflector-Dashboard"> DG9VH YSFReflector-Dashboard </a><a id="chatLink" target="_new" href="/couleurs.php"> . </a>
     </div>
    </nav>

   <p><?php
	// Chronométrage du début
	$finish = microtime(true);
	$total_time = round(($finish - $St2Time), 4);
	echo "<br><p style='text-align: center; font-size: 1.5em; color: #15FDE0;'>Page produite en -> " . $total_time . " <- Secondes.</p>";
	echo "<p style='text-align: center; font-size: 1.2em;'>Nombre de visites : " . $count . "</p>";
    ?></p><br>
  </div><!--  Container last div  -->
 </body>
</html>
