<!DOCTYPE html>
<html lang="fr">
<head>
   <meta charset="UTF-8">
   <title>Fichiers disponibles</title>
   <style>
        body {
            margin: 10px;
            padding: 0px;
            font-family: Arial, sans-serif;
            background: #252525;
            color: white;
        }
        h1 {
            margin: 0px;
            background: #02527F;
            color: #02E2FF;
            font-size: 2em;
            padding: 20px;
            text-shadow: 1px 1px 5px #000;
            border: 3px solid #01708F;   /* turquoise plus foncé */
            border-radius: 6px;          /* arrondi optionnel pour adoucir */
        }
        table {
            background: #959595;
            border-radius: 8px;
            width: 100%;
            margin-top: 0px;
            border-collapse: collapse;
            font-size: 1.35em;
            box-shadow: inset 0 0 5px rgba(0,0,0,0.7);
        }
        td {
            padding: 10px 15px;
            text-align: left;
            border-bottom: 1px solid #002;
            text-shadow: 0px 0px 1px #000;
            color: #226;
        }
        th {
            padding: 10px 15px;
            text-align: left;
            border-bottom: 1px solid #002;
            text-shadow: 0px 0px 1px #000;
            color: #133;
        }
        tr:hover {
            background: #505264;
        }
        a {
            color: #68176A;
            text-decoration: none;
        }
        .icon {
            margin-right: 8px;
            font-size: 32px;	/* ou 2em, 3rem, etc. */
/* 	    color: #48C0FC; */  /* par exemple */
        }
        .icon-folder {
            font-size: 48px; 	/* plus gros pour l'emoji dossier */
        }
        .upload-form {
            display: flex;		/* Permet l’alignement en colonnes */
            flex-wrap: wrap;		/* Garde la possibilité de passer en ligne multiple si écran étroit */
            justify-content: space-between;
            align-items: flex-start;
            height: auto;		/* Plus besoin de hauteur fixe */
            background: #349;
            font-size: 2em;
            padding: 5px;
            text-shadow: 1px 1px 5px #000;
            border-radius: 8px;
            border-bottom-left-radius: 0;
            border-bottom-right-radius: 0;
            margin: 0 0 15px 0;
            gap: 20px;			/* espace horizontal entre les colonnes */
        }
	.upload-column {
	    flex: 1;                     /* Chaque colonne prend la même largeur */
	    min-width: 200px;            /* Largeur minimale par colonne */
	}
	.upload-column label {
	    display: block;
	    margin-bottom: 8px;
	}
        #identifiant {
            box-sizing: border-box;
            font-size: 0.7em;
            padding: 5px;
            text-shadow: 1px 1px 2px #000;
            background: #0F203F;
            color: #AFA;
            border-radius: 4px;
        }
        label {
            background: #349;
            color: #acf;
            font-size: 0.8em;
            padding: 5px;
            text-shadow: 1px 1px 5px #000;
            display: block;
            margin-bottom: 8px;
        }
        input[type="text"] {
            background: #0F203F; 
            color: #AFA; 
            font-size: 0.6em; 
            text-shadow: 1px 1px 5px #000; 
            padding: 5px;
            border-radius: 4px;
            width: 100%;
            box-sizing: border-box;
        }
        input[type="file"] { 
            display: none;	/* Cacher le input file natif */
        }
        input[type="file"] {
            background: #352525; color: #FDD; font-size: 0.6em; text-shadow: 1px 1px 5px #000; padding: 5px;
        }
        input[type="file"]::file-selector-button {
            background-color: #0278c1;	/* Style du bouton "Choisir un fichier" */
            color: #224; 
            border: none; 
            padding: 8px 15px; 
            border-radius: 6px; 
            cursor: pointer; 
            font-weight: bold; 
            transition: background-color 0.3s ease;
        }
        input[type="file"]::file-selector-button:hover {
            background-color: #029ca0;
            color: #8f9;
        }
        .custom-file-label {
            background-color: #2060B0;	/* #2298E2 */
            color: #003;		/* #224	   */
            padding: 8px 5px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: arial;
            display: inline-block;
            margin-right: 10px;
            text-shadow: 1px 1px 2px #000;
            transition: background-color 0.3s ease;
        }
        .custom-file-label:hover {
            box-border: 2px #2af;
            background-color: #114499;
            color: #2af;
        }
        #file-chosen {
            background: #354595;	/* Zone affichant le nom du fichier choisi */
            margin-left: 15px;
            font-style: italic;
            color: #37E;
            vertical-align: middle;
        }
        input[type="submit"] {
            background: #02DAFA;
            border: none;
            font-size: 0.7em;
            text-shadow: 1px 1px 5px #222;
            padding: 8px 15px;
            color: #003;
            border-radius: 5px;
            cursor: pointer;
            margin-left: 5px;
        }
        input[type="submit"]:hover {
            background: #00EEA0;
        }
    </style>
</head>
<body>

<div style="overflow-x: auto; -webkit-overflow-scrolling: touch;">
  <table>

<h1>Fichiers disponibles / <a href="../" style="background: #02527F; color: #EFE8AA; text-shadow: 1px 1px 6px #000; padding: 3px;">Clic Ici Retour Reflecteur </a></h1>

<?php
// * 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$message = 'Aucun Message Pour Le Moment ';

//   **********  Gestion du Téléversement  ************************************************************************
if (isset($_POST['envoyer']) && isset($_FILES['fichier'])) {
    $identifiant = trim($_POST['identifiant']);
    $cheminUtilisateurs = __DIR__ . '/../config/ExplorerUsers.txt';

    if (file_exists($cheminUtilisateurs)) {
        $utilisateurs = file($cheminUtilisateurs, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    } else {
    // Gérer le cas où le fichier n'existe pas, par ex. bloquer l'upload ou charger une liste vide
    $utilisateurs = [];
        $message = "<p style='color:#E45;'>Fichier des utilisateurs introuvable, upload désactivé.</p>";
    }

    if (in_array($identifiant, $utilisateurs)) {
        $nomFichier = basename($_FILES['fichier']['name']);
        $destination = __DIR__ . '/' . $nomFichier;

        if (move_uploaded_file($_FILES['fichier']['tmp_name'], $destination)) {
            // Récupérer l'adresse IP réelle de l'utilisateur
            function getClientIP() {
                $ipaddress = '';
                if (getenv('HTTP_CLIENT_IP'))
                    $ipaddress = getenv('HTTP_CLIENT_IP');
                else if(getenv('HTTP_X_FORWARDED_FOR'))
                    $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
                else if(getenv('HTTP_X_FORWARDED'))
                    $ipaddress = getenv('HTTP_X_FORWARDED');
                else if(getenv('HTTP_FORWARDED_FOR'))
                    $ipaddress = getenv('HTTP_FORWARDED_FOR');
                else if(getenv('HTTP_FORWARDED'))
                    $ipaddress = getenv('HTTP_FORWARDED');
                else if(getenv('REMOTE_ADDR'))
                    $ipaddress = getenv('REMOTE_ADDR');
                else
                    $ipaddress = 'UNKNOWN';
                return $ipaddress;
            }

            $ip = getClientIP();
            $date = date('Y-m-d H:i:s');
            $logLine = "[$date] Identifiant: $identifiant - IP: $ip - Fichier: $nomFichier" . PHP_EOL;
            $logDir = __DIR__ . '/../log';
            $logFile = $logDir . '/Explorer_Upload.log';

         if (!is_dir($logDir)) {
            mkdir($logDir, 0755, true); // crée le dossier logs (récursivement) avec droits 755
         }
            // Ecrire dans le fichier log (ex: log/Explorer_Upload.log)
            file_put_contents($logFile, $logLine, FILE_APPEND | LOCK_EX);
            // Log upload
            $message = "<p style='color: #1E1;'>Fichier '$nomFichier' Téléversé avec Succès.</p>";
        } else {
            $message = "<p style='color: #E56;'>Erreur Lors du Téléversement.</p>";
        }
    } else {
        $message = "<p style='color: #F67;'>Identifiant Non Reconnu, Upload Refusé.</p>";
    }
}

// Gestion Suppression  ***********************************************************************************************
if (isset($_POST['supprimer']) && !empty($_POST['delete'])) {
    $identifiant_suppression = trim($_POST['identifiant_supprimer']);
    $cheminSuppresseurs = __DIR__ . '/../config/suppresseurs.txt';

    if (file_exists($cheminSuppresseurs)) {
        $suppresseurs = file($cheminSuppresseurs, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    } else {
        $suppresseurs = [];
        $message = "<p style='color:orange;'>?? Fichier des autorisations de suppression introuvable.</p>";
    }

    if (in_array($identifiant_suppression, $suppresseurs)) {
        foreach ($_POST['delete'] as $fileToDelete) {
            $path = __DIR__ . '/' . basename($fileToDelete);
            if (is_file($path)) {
                unlink($path);
                $message = "<p style='color: red;'>Fichier supprimé : " . htmlspecialchars($fileToDelete) . "</p>";
            }
        }
    } else {
        $message = "<p style='color:#F67;'>? Identifiant de suppression non reconnu. Aucune suppression effectuée.</p>";
    }
}


  function getFileIcon($filename) {
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    if ($ext === '') { 
        return '<span class="icon icon-folder">📁</span>'; //Sans Eextension,C'est un Ddossier
    }
    $icons = [
        'Dossier' => '📁',
        'jpg' => '🖼️',
        'png' => '🖼️',
        'gif' => '🖼️',
        'bmp' => '🖼️',
        'pdf' => '📄',
        'txt' => '📄',
        'php' => '🐘',
        'js' => '🐘',
        'html' => '🐘',
        'css' => '🐘',
        'rar' => '📦',
        'zip' => '📦',
        'tar' => '📦',
        'gz' => '📦',
        'img' => '💽',
        'bat' => '💾',
        'bt' => '💾',
        'disk' => '📀',
        'iso' => '📀',
        'doc' => '📄',
        'docx' => '📄',
        'xls' => '📊',
        'xlsx' => '📊',
        'sh' => '🖥️',
        'py' => '💻',
        // ajoute d'autres extensions et icônes ici selon besoin
    ];
    return $icons[$ext] ?? '📄';  // dossier/fichier par défaut
  }
$folderIcon = '📁';

?>

<div style="background:#349; padding:15px; border-radius:8px; color:#ACE; margin-bottom:20px;">
<div></div>

<!--  Ajouté   ********  Form   **************************************************************************************** -->
  <div class="upload-form">
    <form action="" method="POST" enctype="multipart/form-data" style="width:100%;">

    <!-- Première ligne : identifiant + sélection de fichier -->
      <div style="display:flex; align-items:center; flex-wrap:wrap; gap:15px;">
        <div style="flex:0 0 140px;">  <!-- Colonne identifiant plus étroite -->
           <label for="identifiant" style="font-size:0.85em; padding:5px; width:205px; margin-top:0px;">Identifiant :</label>
           <input type="text" name="identifiant" id="identifiant" required style="background:#0F203F; color:#AFA; font-size:0.75em; padding:5px; width:220px; margin-top:0px; border-radius:5px;">
        </div>
        <div style="flex:1;">  <!-- Colonne fichier -->
           <label for="fichier">Ajouter :</label>
           <label for="fichier" class="custom-file-label">Sélection Fichier</label>
           <span id="file-chosen"> ___________________ </span>
           <input type="file" name="fichier" id="fichier" style="display:none;">
           <input type="submit" name="envoyer" value="Téléverser 140Mo Max." style="margin-left: 15px;">
        </div>
      </div>

    <!-- Deuxième ligne : bouton centré -->
    <div style="text-align:center;">
    </div>

    </form>
  </div>


<!--  Supperssion  ********  Form   ************************************************************************************ -->
    <form action="" method="POST" style="margin:0; padding:0;">
      <div style="margin-bottom:10px; margin-top:0px; display:flex; align-items:center; gap:10px;">
        <div style="flex-shrink:0;">
           <label for="identifiant_supprimer." style="font-size:1.65em; padding:5px; width:230px; margin-top:0px;">Identifiant supp. :</label>
           <input type="text" name="identifiant_supprimer" id="identifiant_supprimer" required style="background:#0F203F; color:#AFA; font-size:1.3em; padding:5px; width:225px; margin-top:0px; border-radius:5px;">
        </div>
        <input type="submit" name="supprimer" value="Supp. Cochés" style="margin-left:10px; flex-shrink:0; font-size:1.3em; padding:5px; width:180px; margin-top:0px; border-radius:5px;">
        <label for="messages" style="font-size:1.25em; margin-left:10px; color:#FFA;"> <?php echo $message; ?></label>
      </div>

    <!-- Tableau de fichiers -->
     <table style="background-color: #303030; color: #CCCCCC;">
      <tr style="background-color: #454555; color: #FED5A5; font-size: 1.45em;">
        <th style="color: #FEDEBE;"><span class="icon icon-folder"><?php echo $folderIcon; ?></span>Fichier en Téléchargements</th>
        <th style="color: #FECD99;">Taille Octets</th>
        <th style="color: #FECD99;">Taille Bytes</th>
        <th style="color: #FECD99;">Dernière M. a J.</th>
        <th style="color: #FF5D56;">Supp.</th>
      </tr>

<?php
    // Récupération des fichiers et dates de modification

    $files = scandir(__DIR__);
    $file_dates = [];

    foreach ($files as $file) {
        if ($file == '.' || $file == '..' || $file == '.htaccess' || $file == 'index.php' || $file == 'Explorer.php' || $file == 'Explorer0.php' || $file == basename(__FILE__)) continue;
            if (is_file($file)) {
	        $file_dates[$file] = filemtime($file);
	    }
	}

	// Tri du tableau du plus récent au plus ancien
	arsort($file_dates);

    // Affichage
    foreach ($file_dates as $file => $mtime) {
	$icon = getFileIcon($file);

	      echo '<tr>';
              echo '<td><span class="icon">'.$icon.'</span> <a href="'.htmlspecialchars($file).'" style="color: #EEEEEE;">'.htmlspecialchars($file).'</a></td>';
              $size = filesize($file);

              if ($size >= 1073741824) {
                  echo '<td style="color: #96FE96;">'.round($size / 1073741824, 3).' Go</td>';
              } elseif ($size >= 1048576) {
                  echo '<td style="color: #FE96FE;">'.round($size / 1048576, 3).' Mo</td>';
              } elseif ($size >= 1024) {
                  echo '<td style="color: #FE9696;">'.round($size / 1024, 3).' Ko</td>';
              } else {
                  echo '<td style="color: #97EFFE;">'.$size.' Octets</td>';
              }

              if ($size >= 1000000000) {
                  echo '<td style="color: #96FF96;">'.round($size / 1000000000, 3).' GB</td>';
              } elseif ($size >= 1000000) {
                  echo '<td style="color: #FE96FE;">'.round($size / 1000000, 3).' MB</td>';
              } elseif ($size >= 1000) {
                  echo '<td style="color: #EE9696;">'.round($size / 1000, 3).' KB</td>';
              } else {
                  echo '<td style="color: #96DFEE;">'.$size.' Bytes</td>';
              }

              echo '<td style="color: #EEEEEE;">'.date("d/m/Y H:i", filemtime($file)).'</td>';
              echo '<td style="text-align:center; background-color: #353535; color: #FF0000;"><input type="checkbox" name="delete[]" value="'.htmlspecialchars($file).'"></td>';
              echo '</tr>';
          }
     ?>
     </table>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const inputFile = document.getElementById('fichier');
    const fileChosen = document.getElementById('file-chosen');

    inputFile.addEventListener('change', () => {
        if (inputFile.files.length > 0) {
            fileChosen.textContent = inputFile.files[0].name;
            fileChosen.style.color = '#48C0FC';
        } else {
            fileChosen.textContent = 'Aucun fichier choisi';
            fileChosen.style.color = '#a00';
        }
    });
});
</script>

  </table>
</div>

</body>
</html>

