// Effet de neige moderne et corrigé 
document.addEventListener("DOMContentLoaded", () => {

  // nombre de flocons De 15 a 100 ****************************************
    const snowCount = 27; 

  // chemin de l'image du flocon.png ** heart.png ou snow.gif *************
    const snowImg = "/js/flocon1C.png"; 
    const snowDistance = "pageheight"; // ou "windowheight"

  let snowflakes = [];
  let snowTimer;
  const snowContainer = document.createElement("div");
  snowContainer.style.position = "fixed";
  snowContainer.style.top = "0";
  snowContainer.style.left = "0";
  snowContainer.style.width = "100%";
  snowContainer.style.height = "100%";
  snowContainer.style.pointerEvents = "none";
  snowContainer.style.zIndex = "999";
  document.body.appendChild(snowContainer);

  // Création des flocons
  for (let i = 0; i < snowCount; i++) {
    const flake = document.createElement("img");
    flake.src = snowImg;
    flake.style.position = "absolute";

  // de 5 a 45px *****  ${size}px  *****************************************
    const size = 3 + Math.random() * 6; 
    flake.style.width = '${size}px';  // = "10px"; a 50px ******************
    flake.style.height = '${size}px'; // = "10px"; a 50px ******************
    flake.style.top = `${Math.random() * window.innerHeight}px`;
    flake.style.left = `${Math.random() * window.innerWidth}px`;
    flake.style.userSelect = "none";

  // Couleur et opacité aléatoire  ou flake.style.filter = "hue-rotate(200deg)";
    const colors = ["#ffffff", "#b6d6f7", "#90bfef", "#2196f3"];
    flake.style.filter = `drop-shadow(0 0 5px ${colors[Math.floor(Math.random() * colors.length)]})`;
    flake.style.opacity = 0.5 + Math.random() * 0.9; // ********** 0.7 et 0.3 *************************

    snowContainer.appendChild(flake);

    snowflakes.push({
      element: flake,
      x: Math.random() * window.innerWidth,
      y: Math.random() * window.innerHeight,
      amplitude: 5 + Math.random() * 20, //  20 et 20 ******************************************
      dx: 0,
      stx: 0.000000000000003 + Math.random() / 250, //  *** 0.003 et 30  **** Vague Horisontal **************
      sty: 0.345 + Math.random() * 0.6, // *** Vitesse Vertical ******* 0.05 ***** + Math.random() * 1.9   ********************
      wind: 0.000004 + Math.random() * 0.00000512, // vitesse vent horizontal 0.04 a 0.5 ***************
    }); // stx *** default 0.02 & / 10 ***  ou  *** 0.005 & / 30 ***********
  }

  function animateSnow() {
    const width = snowDistance === "windowheight" ? window.innerWidth : document.documentElement.scrollWidth;
    const height = snowDistance === "windowheight" ? window.innerHeight : Math.max(document.body.scrollHeight, window.innerHeight);

    snowflakes.forEach((flake) => {
      flake.y += flake.sty;
      flake.x += flake.wind; // vent poussé vers la droite

      if (flake.y > height - 50) {
        flake.x = Math.random() * width;
        flake.y = 0;
      }
    if (flake.x > width) flake.x = 0;

      flake.dx += flake.stx;
      flake.element.style.top = `${flake.y}px`;
      flake.element.style.left = `${flake.x + flake.amplitude * Math.sin(flake.dx)}px`;
  });

    snowTimer = requestAnimationFrame(animateSnow);
  }

  animateSnow();

  // Optionnel : fonction pour masquer les flocons au bout d’un délai
  function hideSnow(delaySeconds = 0) {
    if (delaySeconds <= 0) return;
    setTimeout(() => {
      cancelAnimationFrame(snowTimer);
      snowContainer.style.display = "none";
    }, delaySeconds * 1000);
  }

  // Exemple : cacher la neige après 30 secondes
  // hideSnow(30);
});
