<?php
session_start();
ob_start();
include_once __DIR__ ."/include/CouleurMatch.php";

// On lit les couleurs actuelles dans colors.json si possible, sinon défauts
if(file_exists($jsonFile)) {
    $savedColors = json_decode(file_get_contents($jsonFile), true);

// Prendre la couleur en session si définie, sinon dans colors.json, sinon valeur par défaut
    $selectedBgColor0 = $_SESSION['bgColor0'] ?? ($savedColors['bgColor0'] ?? '#030304');
    $selectedBgColor2 = $_SESSION['bgColor2'] ?? ($savedColors['bgColor2'] ?? '#333434');

    $selectedBgColor0 = $savedColors['bgColor0'] ?? '#030304';
    $selectedBgColor2 = $savedColors['bgColor2'] ?? '#333434';
} else {
    $selectedBgColor0 = '#030304';
    $selectedBgColor2 = '#333434';
}

// Traitement du formulaire POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bg0 = $_POST['bg0'] ?? '#030304';
    $bg2 = $_POST['bg2'] ?? '#333434';

    // Validation des valeurs choisies
    if (array_key_exists($bg0, $bgColor0Options) && array_key_exists($bg2, $bgColor2Options)) {
        // Enregistrement dans colors.json
        $toSave = ['bgColor0' => $bg0, 'bgColor2' => $bg2];
// ---------------------------------------------------------------------------------------------------- Cote Serveur Couleur Pour tous *************************
 file_put_contents($jsonFile, json_encode($toSave, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

        // Stockage en session des choix utilisateurs
        $_SESSION['bgColor0'] = $bg0;
        $_SESSION['bgColor2'] = $bg2;

        // Mise à jour des valeurs sélectionnées pour affichage après soumission
        $selectedBgColor0 = $bg0;
        $selectedBgColor2 = $bg2;

        // Redirection pour éviter resoumission
        header("Location: index.php");
        exit();
    } else {
        echo "<p style='color:red;'>Valeurs invalides sélectionnées.</p>";
    }
}

ob_end_flush();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />

    <title>Configuration des couleurs</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" crossorigin="anonymous">
</head>
<body class="p-3" style="background-color: #A5A5A5; font-size: 1.6em;">

    <h1>Personnalisation des couleurs Json ADM</h1>
    <form method="post" action="" class="w-50">
        <div class="form-group">
            <label for="bg0">Choisissez couleur BG0 :</label>
            <select name="bg0" id="bg0" class="form-control">
                <?php foreach ($bgColor0Options as $color => $label): ?>
                    <option value="<?= htmlspecialchars($color) ?>" <?= ($selectedBgColor0 === $color) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($label) ?> (<?= htmlspecialchars($color) ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <label for="bg2">Choisissez couleur BG2 :</label>
            <select name="bg2" id="bg2" class="form-control">
                <?php foreach ($bgColor2Options as $color => $label): ?>
                    <option value="<?= htmlspecialchars($color) ?>" <?= ($selectedBgColor2 === $color) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($label) ?> (<?= htmlspecialchars($color) ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <button type="submit" class="btn btn-primary">Appliquer</button>
    </form>
</body>
</html>
