<?php
header('Content-Type: text/html; charset=utf-8');
date_default_timezone_set('America/Toronto');

function formatElapsedTime($seconds) {
    if ($seconds < 60) return $seconds . " s";
    if ($seconds < 3600) return floor($seconds / 60) . " min";
    $h = floor($seconds / 3600);
    $m = floor(($seconds % 3600) / 60);
    return $h . "h " . $m . "min";
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Affichage du log des visites</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            font-size: 18px; background-color: #102030; 
        }
        pre { 
            background: #071727; 
            padding: 0em 1em 1em 1em; 
            border-radius: 6px; 
            font-family: Consolas, monospace; 
            overflow-x: auto;
        }

        .fichier1 {
	    color: #A060EA; 
	    background-color: #012;
	} /* couleur spéciale pour fichier1 */

        .fichier2 {
            color: #DF963F; 
            background-color: #012;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
	} /* couleur spéciale pour fichier2 */

       .fichier3 {
	    color: #20CC88; 
	    background-color: #012;
	} /* couleur spéciale pour fichier3 */

       .fichier4 {
	    color: #FF0000; 
	    background-color: #012;
	} /* couleur spéciale pour fichier4 */

        .logglobal {
            color: #20CC88;
            background-color: #012;
            padding: 15px;
            border-radius: 8px;
            margin-top: 30px;
        }

        #toggleGraphBtn {
            margin-left: 20px;
            padding: 8px 16px;
            background-color: #444;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1em;
        }

        body { font-family: Arial, sans-serif; font-size: 18px; background-color: #102030; color: #fff; }
        pre { background: #071727; padding: 1em; border-radius: 6px; font-family: Consolas, monospace; overflow-x: auto; }
        .fichier2 { color: #DF963F; background-color: #012; padding: 15px; border-radius: 8px; margin-bottom: 20px; }
        #toggleGraphBtn { margin-left: 20px; padding: 8px 16px; background-color: #444; color: #fff; border: none; border-radius: 4px; cursor: pointer; font-size: 1em; }
        #graphContainer { margin-top: 10px; display: none; }
    </style>
</head>
<body>
    <h1 style="background-color: #203040; color: #00B0C0; padding: 20px;">
        Visites Logs <a href="./" style="background-color: #203040; color: #A0B0C0; padding: 20px;"> - Clic Ici Retour </a>
    </h1>

<?php
echo '<pre>';
$fichier2 = 'log/VisitesIP.txt';
$maintenant = time();
$t24h = 86400;
$t12h = 43200;
$t6h  = 21600;
$t2h  = 7200;

$couleurA = "#20FF50"; // < 2h
$couleurB = "#D7D720"; // 2h–6h
$couleurC = "#D7A020"; // 6h–12h
$couleurD = "#90550F"; // 12h–24h

$visitesParHeure = array_fill(0, 24, 0);
$NBVisiteurs24Hrs = 0;
$lignesRecentes = [];

if (file_exists($fichier2)) {
    $lignes = file($fichier2, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    echo '<div style="padding:10px; background:#071727; border-radius:8px; margin-bottom:10px;">';
    echo '<span style="color:' . $couleurA . ';">? Moins de 2 h</span> &nbsp;&nbsp;';
    echo '<span style="color:' . $couleurB . ';">? De 2 h a 6 h</span> &nbsp;&nbsp;';
    echo '<span style="color:' . $couleurC . ';">? De 6 h a 12 h</span> &nbsp;&nbsp;';
    echo '<span style="color:' . $couleurD . ';">? De 12 h a 24 h</span>';
    echo '</div>';

    echo '<pre>';
    foreach ($lignes as $ligne) {
        $parties = explode('|', $ligne);
        if (count($parties) >= 2) {
            $ip = trim($parties[0]);
            $timestamp = (int)trim($parties[1]);
            $delta = $maintenant - $timestamp;

            if ($delta <= $t24h) {
                $lignesRecentes[] = $ligne;
                $NBVisiteurs24Hrs++;

                if ($delta <= $t2h) {
                    $couleur = $couleurA;
                } elseif ($delta <= $t6h) {
                    $couleur = $couleurB;
                } elseif ($delta <= $t12h) {
                    $couleur = $couleurC;
                } else {
                    $couleur = $couleurD;
                }

                $tempsEcoule = formatElapsedTime($delta);
                echo '<span style="color:' . $couleur . ';">' . htmlspecialchars($ip) . ' | ' . $tempsEcoule . "</span>\n";

                // Heure locale automatique avec décalage été/hiver géré
                $heure = (int)date('G', $timestamp);
                $visitesParHeure[$heure]++;
            }
        }
    }
    echo '</pre>';

    file_put_contents($fichier2, implode("\n", $lignesRecentes) . "\n");
} else {
    echo "Fichier introuvable.";
}

$labels = [];
for ($i = 0; $i < 24; $i++) {
    $labels[] = sprintf('%02dh', $i);
}
echo '</pre>';

?>

    <div class="fichier2">
        <h3>___ Visiteurs Sur 24 Hrs _________  <button id="toggleGraphBtn">Afficher Le Graphique</button></h3>

    <!-- Le tableau des visiteurs est affiché via PHP ci-dessus -->

        <p style="font-size: 1.4em;">Total de Visiteurs sur 24Hrs : <?= $NBVisiteurs24Hrs ?></p>
    </div>

    <div id="graphContainer">
        <p>
          Ce graphique te permet de visualiser pendant quelles heures ta plateforme a reçu le plus de visiteurs sur les dernières 24 heures.<br>
          L’heure affichée est locale Québec, automatiquement ajustée selon l’heure d’été ou d’hiver.
        </p>
        <canvas id="visitesGraph" width="800" height="350"></canvas>
        <p style="text-align:center;color:#00B0C0;">Heure locale Québec : <?= date('Y-m-d H:i') ?></p>
       </div>
       <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


   <script>
    document.getElementById('toggleGraphBtn').addEventListener('click', function() {
        const container = document.getElementById('graphContainer');
        container.style.display = container.style.display === 'none' ? 'block' : 'none';
    });

    const labels = <?= json_encode($labels) ?>;
    const dataVisites = <?= json_encode(array_values($visitesParHeure)) ?>;
 
    // Exemple : définir des couleurs spécifiques pour certaines heures
    const couleursBarres = labels.map((heure, index) => {
        if (index >= 0 && index < 6) return '#401050';   // Jaune clair pour 00h–05h
        if (index >= 6 && index < 7) return '#AF3C00';  // Orange vif pour 06h–11h
        if (index >= 7 && index < 10) return '#B85820';  // Orange vif pour 06h–11h
        if (index >= 10 && index < 12) return '#CF6F3A';  // Orange vif pour 06h–11h
        if (index >= 12 && index < 13) return '#DFAC44';  // Orange vif pour 06h–11h
        if (index >= 13 && index < 15) return '#AFBC77';  // Orange vif pour 06h–11h
        if (index >= 15 && index < 17) return '#7F9FF6'; // Bleu ciel pour 12h–17h
        if (index >= 17 && index < 18) return '#5F6FBF'; // Bleu ciel pour 12h–17h
        if (index >= 18 && index < 20) return '#4F3F8F'; // Bleu ciel pour 12h–17h
        return '#350555';                               // Vert pour 18h–23h
    });

// Fonction pour éclaircir légèrement la couleur au survol
    function lightenColor(hex, percent) {
        const num = parseInt(hex.replace('#',''), 16);
        const r = Math.min(255, (num >> 16) + 255 * percent);
        const g = Math.min(255, ((num >> 8) & 0x00FF) + 255 * percent);
        const b = Math.min(255, (num & 0x0000FF) + 255 * percent);
        return `rgb(${Math.round(r)}, ${Math.round(g)}, ${Math.round(b)})`;
    }


   const hoverCouleurs = couleursBarres.map(c => lightenColor(c, 0.2));





    const ctx = document.getElementById('visitesGraph').getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Nombre de visiteurs',
                data: dataVisites,
                backgroundColor: couleursBarres, // <= tableau de couleurs ici
                hoverBackgroundColor: hoverCouleurs,  // couleur éclaircie au survol
                borderColor: '#010101',
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: { beginAtZero: true, ticks: { stepSize: 1 } }
            },
            responsive: true,
            plugins: { legend: { display: false } }
        }
    });
   </script>

</body>
</html>
