﻿<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Web based File Manager in PHP, Manage your files efficiently and easily with Tiny File Manager">
    <meta name="author" content="CCP Programmers">
    <meta name="robots" content="noindex, nofollow">
    <meta name="googlebot" content="noindex">
    <link rel="icon" href="/images/favicon.ico" type="image/png">    <title>WPSD File CSS Couleurs  HotSpot  VA2VDC </title>
    <link rel="preconnect" href="https://cdn.jsdelivr.net" crossorigin/><link rel="dns-prefetch" href="https://cdn.jsdelivr.net"/>    <link rel="preconnect" href="https://cdnjs.cloudflare.com" crossorigin/><link rel="dns-prefetch" href="https://cdnjs.cloudflare.com"/>    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-Zenh87qX5JnK2Jl0vWa8Ck2rdkQ2Bzep5IDxbcnCeuOxjzrPF/et3URy9Bv1WTRi" crossorigin="anonymous">    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" crossorigin="anonymous">        <script type="text/javascript">window.csrf = 'ae663efa8e54936feac58bd3e07d972d5e5c6e15fec74ac0e42008d4c2864196';</script>
    <style>
        html { -moz-osx-font-smoothing: grayscale; -webkit-font-smoothing: antialiased; text-rendering: optimizeLegibility; height: 100%; scroll-behavior: smooth;}
        *,*::before,*::after { box-sizing: border-box;}
        body { font-size:15px; color:#222;background:#F7F7F7; }
        body.navbar-fixed { margin-top:55px; }
        a, a:hover, a:visited, a:focus { text-decoration:none !important; }
        .filename, td, th { white-space:nowrap  }
        .navbar-brand { font-weight:bold; }
        .nav-item.avatar a { cursor:pointer;text-transform:capitalize; }
        .nav-item.avatar a > i { font-size:15px; }
        .nav-item.avatar .dropdown-menu a { font-size:13px; }
        #search-addon { font-size:12px;border-right-width:0; }
        .brl-0 { background:transparent;border-left:0; border-top-left-radius: 0; border-bottom-left-radius: 0; }
        .brr-0 { border-top-right-radius: 0; border-bottom-right-radius: 0; }
        .bread-crumb { color:#cccccc;font-style:normal; }
        #main-table { transition: transform .25s cubic-bezier(0.4, 0.5, 0, 1),width 0s .25s;}
        #main-table .filename a { color:#222222; }
        .table td, .table th { vertical-align:middle !important; }
        .table .custom-checkbox-td .custom-control.custom-checkbox, .table .custom-checkbox-header .custom-control.custom-checkbox { min-width:18px; display: flex;align-items: center; justify-content: center; }
        .table-sm td, .table-sm th { padding:.4rem; }
        .table-bordered td, .table-bordered th { border:1px solid #f1f1f1; }
        .hidden { display:none  }
        pre.with-hljs { padding:0; overflow: hidden;  }
        pre.with-hljs code { margin:0;border:0;overflow:scroll;  }
        code.maxheight, pre.maxheight { max-height:512px  }
        .fa.fa-caret-right { font-size:1.2em;margin:0 4px;vertical-align:middle;color:#ececec  }
        .fa.fa-home { font-size:1.3em;vertical-align:bottom  }
        .fa.fa-tachometer { font-size:1.3em;vertical-align:bottom; margin-left: 0.7em;  }
        .path { margin-bottom:10px  }
        form.dropzone { min-height:200px;border:2px dashed #007bff;line-height:6rem; }
        .right { text-align:right  }
        .center, .close, .login-form, .preview-img-container { text-align:center  }
        .message { padding:4px 7px;border:1px solid #ddd;background-color:#fff  }
        .message.ok { border-color:green;color:green  }
        .message.error { border-color:red;color:red  }
        .message.alert { border-color:orange;color:orange  }
        .preview-img { max-width:100%;max-height:80vh;background:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAACQkWg2AAAAKklEQVR42mL5//8/Azbw+PFjrOJMDCSCUQ3EABZc4S0rKzsaSvTTABBgAMyfCMsY4B9iAAAAAElFTkSuQmCC);cursor:zoom-in }
        input#preview-img-zoomCheck[type=checkbox] { display:none }
        input#preview-img-zoomCheck[type=checkbox]:checked ~ label > img { max-width:none;max-height:none;cursor:zoom-out }
        .inline-actions > a > i { font-size:1em;margin-left:5px;background:#3785c1;color:#fff;padding:3px 4px;border-radius:3px; }
        .preview-video { position:relative;max-width:100%;height:0;padding-bottom:62.5%;margin-bottom:10px  }
        .preview-video video { position:absolute;width:100%;height:100%;left:0;top:0;background:#000  }
        .compact-table { border:0;width:auto  }
        .compact-table td, .compact-table th { width:100px;border:0;text-align:center  }
        .compact-table tr:hover td { background-color:#fff  }
        .filename { max-width:420px;overflow:hidden;text-overflow:ellipsis  }
        .break-word { word-wrap:break-word;margin-left:30px  }
        .break-word.float-left a { color:#7d7d7d  }
        .break-word + .float-right { padding-right:30px;position:relative  }
        .break-word + .float-right > a { color:#7d7d7d;font-size:1.2em;margin-right:4px  }
        #editor { position:absolute;right:15px;top:100px;bottom:15px;left:15px  }
        @media (max-width:481px) {
            #editor { top:150px; }
        }
        #normal-editor { border-radius:3px;border-width:2px;padding:10px;outline:none; }
        .btn-2 { padding:4px 10px;font-size:small; }
        li.file:before,li.folder:before { font:normal normal normal 14px/1 FontAwesome;content:"\f016";margin-right:5px }
        li.folder:before { content:"\f114" }
        i.fa.fa-folder-o { color:#0157b3 }
        i.fa.fa-picture-o { color:#26b99a }
        i.fa.fa-file-archive-o { color:#da7d7d }
        .btn-2 i.fa.fa-file-archive-o { color:inherit }
        i.fa.fa-css3 { color:#f36fa0 }
        i.fa.fa-file-code-o { color:#007bff }
        i.fa.fa-code { color:#cc4b4c }
        i.fa.fa-file-text-o { color:#0096e6 }
        i.fa.fa-html5 { color:#d75e72 }
        i.fa.fa-file-excel-o { color:#09c55d }
        i.fa.fa-file-powerpoint-o { color:#f6712e }
        i.go-back { font-size:1.2em;color:#007bff; }
        .main-nav { padding:0.2rem 1rem;box-shadow:0 4px 5px 0 rgba(0, 0, 0, .14), 0 1px 10px 0 rgba(0, 0, 0, .12), 0 2px 4px -1px rgba(0, 0, 0, .2)  }
        .dataTables_filter { display:none; }
        table.dataTable thead .sorting { cursor:pointer;background-repeat:no-repeat;background-position:center right;background-image:url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAQAAADYWf5HAAAAkElEQVQoz7XQMQ5AQBCF4dWQSJxC5wwax1Cq1e7BAdxD5SL+Tq/QCM1oNiJidwox0355mXnG/DrEtIQ6azioNZQxI0ykPhTQIwhCR+BmBYtlK7kLJYwWCcJA9M4qdrZrd8pPjZWPtOqdRQy320YSV17OatFC4euts6z39GYMKRPCTKY9UnPQ6P+GtMRfGtPnBCiqhAeJPmkqAAAAAElFTkSuQmCC'); }
        table.dataTable thead .sorting_asc { cursor:pointer;background-repeat:no-repeat;background-position:center right;background-image:url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAYAAAByUDbMAAAAZ0lEQVQ4y2NgGLKgquEuFxBPAGI2ahhWCsS/gDibUoO0gPgxEP8H4ttArEyuQYxAPBdqEAxPBImTY5gjEL9DM+wTENuQahAvEO9DMwiGdwAxOymGJQLxTyD+jgWDxCMZRsEoGAVoAADeemwtPcZI2wAAAABJRU5ErkJggg=='); }
        table.dataTable thead .sorting_desc { cursor:pointer;background-repeat:no-repeat;background-position:center right;background-image:url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAYAAAByUDbMAAAAZUlEQVQ4y2NgGAWjYBSggaqGu5FA/BOIv2PBIPFEUgxjB+IdQPwfC94HxLykus4GiD+hGfQOiB3J8SojEE9EM2wuSJzcsFMG4ttQgx4DsRalkZENxL+AuJQaMcsGxBOAmGvopk8AVz1sLZgg0bsAAAAASUVORK5CYII='); }
        table.dataTable thead tr:first-child th.custom-checkbox-header:first-child { background-image:none; }
        .footer-action li { margin-bottom:10px; }
        .app-v-title { font-size:24px;font-weight:300;letter-spacing:-.5px;text-transform:uppercase; }
        hr.custom-hr { border-top:1px dashed #8c8b8b;border-bottom:1px dashed #fff; }
        #snackbar { visibility:hidden;min-width:250px;margin-left:-125px;background-color:#333;color:#fff;text-align:center;border-radius:2px;padding:16px;position:fixed;z-index:1;left:50%;bottom:30px;font-size:17px; }
        #snackbar.show { visibility:visible;-webkit-animation:fadein 0.5s, fadeout 0.5s 2.5s;animation:fadein 0.5s, fadeout 0.5s 2.5s; }
        @-webkit-keyframes fadein { from { bottom:0;opacity:0; }
        to { bottom:30px;opacity:1; }
        }
        @keyframes fadein { from { bottom:0;opacity:0; }
        to { bottom:30px;opacity:1; }
        }
        @-webkit-keyframes fadeout { from { bottom:30px;opacity:1; }
        to { bottom:0;opacity:0; }
        }
        @keyframes fadeout { from { bottom:30px;opacity:1; }
        to { bottom:0;opacity:0; }
        }
        #main-table span.badge { border-bottom:2px solid #f8f9fa }
        #main-table span.badge:nth-child(1) { border-color:#df4227 }
        #main-table span.badge:nth-child(2) { border-color:#f8b600 }
        #main-table span.badge:nth-child(3) { border-color:#00bd60 }
        #main-table span.badge:nth-child(4) { border-color:#4581ff }
        #main-table span.badge:nth-child(5) { border-color:#ac68fc }
        #main-table span.badge:nth-child(6) { border-color:#45c3d2 }
        @media only screen and (min-device-width:768px) and (max-device-width:1024px) and (orientation:landscape) and (-webkit-min-device-pixel-ratio:2) { .navbar-collapse .col-xs-6 { padding:0; }
        }
        .btn.active.focus,.btn.active:focus,.btn.focus,.btn.focus:active,.btn:active:focus,.btn:focus { outline:0!important;outline-offset:0!important;background-image:none!important;-webkit-box-shadow:none!important;box-shadow:none!important }
        .lds-facebook { display:none;position:relative;width:64px;height:64px }
        .lds-facebook div,.lds-facebook.show-me { display:inline-block }
        .lds-facebook div { position:absolute;left:6px;width:13px;background:#007bff;animation:lds-facebook 1.2s cubic-bezier(0,.5,.5,1) infinite }
        .lds-facebook div:nth-child(1) { left:6px;animation-delay:-.24s }
        .lds-facebook div:nth-child(2) { left:26px;animation-delay:-.12s }
        .lds-facebook div:nth-child(3) { left:45px;animation-delay:0s }
        @keyframes lds-facebook { 0% { top:6px;height:51px }
        100%,50% { top:19px;height:26px }
        }
        ul#search-wrapper { padding-left: 0;border: 1px solid #ecececcc; } ul#search-wrapper li { list-style: none; padding: 5px;border-bottom: 1px solid #ecececcc; }
        ul#search-wrapper li:nth-child(odd){ background: #f9f9f9cc;}
        .c-preview-img { max-width: 300px; }
        .border-radius-0 { border-radius: 0; }
        .float-right { float: right; }
        .table-hover>tbody>tr:hover>td:first-child { border-left: 1px solid #1b77fd; }
        #main-table tr.even { background-color: #F8F9Fa; }
        .filename>a>i {margin-right: 3px;}
    </style>
            <style>
            :root {
                --bs-bg-opacity: 1;
                --bg-color: #f3daa6;
                --bs-dark-rgb: 28, 36, 41 !important;
                --bs-bg-opacity: 1;
            }
            .table-dark { --bs-table-bg: 28, 36, 41 !important; }
            .btn-primary { --bs-btn-bg: #26566c; --bs-btn-border-color: #26566c; }
            body.theme-dark { background-image: linear-gradient(90deg, #1c2429, #263238); color: #CFD8DC; }
            .list-group .list-group-item { background: #343a40; }
            .theme-dark .navbar-nav i, .navbar-nav .dropdown-toggle, .break-word { color: #CFD8DC; }
            a, a:hover, a:visited, a:active, #main-table .filename a, i.fa.fa-folder-o, i.go-back { color: var(--bg-color); }
            ul#search-wrapper li:nth-child(odd) { background: #212a2f; }
            .theme-dark .btn-outline-primary { color: #b8e59c; border-color: #b8e59c; }
            .theme-dark .btn-outline-primary:hover, .theme-dark .btn-outline-primary:active { background-color: #2d4121;}
            .theme-dark input.form-control { background-color: #101518; color: #CFD8DC; }
            .theme-dark .dropzone { background: transparent; }
            .theme-dark .inline-actions > a > i { background: #79755e; }
            .theme-dark .text-white { color: #CFD8DC !important; }
            .theme-dark .table-bordered td, .table-bordered th { border-color: #343434; }
            .theme-dark .table-bordered td .custom-control-input, .theme-dark .table-bordered th .custom-control-input { opacity: 0.678; }
            .message { background-color: #212529; }
            .compact-table tr:hover td { background-color: #3d3d3d; }
            #main-table tr.even { background-color: #21292f; }
            form.dropzone { border-color: #79755e; }
        </style>
    </head>
<body class="theme-dark navbar-fixed">
<div id="wrapper" class="container-fluid">
    <!-- New Item creation -->
    <div class="modal fade" id="createNewItem" tabindex="-1" role="dialog" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="newItemModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form class="modal-content text-white bg-dark" method="post">
                <div class="modal-header">
                    <h5 class="modal-title" id="newItemModalLabel"><i class="fa fa-plus-square fa-fw"></i>Create New Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><label for="newfile">Item Type </label></p>
                    <div class="form-check form-check-inline">
                      <input class="form-check-input" type="radio" name="newfile" id="customRadioInline1" name="newfile" value="file">
                      <label class="form-check-label" for="customRadioInline1">File</label>
                    </div>
                    <div class="form-check form-check-inline">
                      <input class="form-check-input" type="radio" name="newfile" id="customRadioInline2" value="folder" checked>
                      <label class="form-check-label" for="customRadioInline2">Folder</label>
                    </div>

                    <p class="mt-3"><label for="newfilename">Item Name </label></p>
                    <input type="text" name="newfilename" id="newfilename" value="" class="form-control" placeholder="Enter here..." required>
                </div>
                <div class="modal-footer">
                    <input type="hidden" name="token" value="ae663efa8e54936feac58bd3e07d972d5e5c6e15fec74ac0e42008d4c2864196">
                    <button type="button" class="btn btn-outline-primary" data-bs-dismiss="modal"><i class="fa fa-times-circle"></i> Cancel</button>
                    <button type="submit" class="btn btn-success"><i class="fa fa-check-circle"></i> Create Now</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Advance Search Modal -->
    <div class="modal fade" id="searchModal" tabindex="-1" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content text-white bg-dark">
          <div class="modal-header">
            <h5 class="modal-title col-10" id="searchModalLabel">
                <div class="input-group mb-3">
                  <input type="text" class="form-control" placeholder="Search a files" aria-label="Search" aria-describedby="search-addon3" id="advanced-search" autofocus required>
                  <span class="input-group-text" id="search-addon3"><i class="fa fa-search"></i></span>
                </div>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form action="" method="post">
                <div class="lds-facebook"><div></div><div></div><div></div></div>
                <ul id="search-wrapper">
                    <p class="m-2">Search file in folder and subfolders...</p>
                </ul>
            </form>
          </div>
        </div>
      </div>
    </div>

    <!--Rename Modal -->
    <div class="modal modal-alert" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" role="dialog" id="renameDailog">
      <div class="modal-dialog" role="document">
        <form class="modal-content rounded-3 shadow text-white bg-dark" method="post" autocomplete="off">
          <div class="modal-body p-4 text-center">
            <h5 class="mb-3">Are you sure want to rename?</h5>
            <p class="mb-1">
                <input type="text" name="rename_to" id="js-rename-to" class="form-control" placeholder="Enter new file name" required>
                <input type="hidden" name="token" value="ae663efa8e54936feac58bd3e07d972d5e5c6e15fec74ac0e42008d4c2864196">
                <input type="hidden" name="rename_from" id="js-rename-from">
            </p>
          </div>
          <div class="modal-footer flex-nowrap p-0">
            <button type="button" class="btn btn-lg btn-link fs-6 text-decoration-none col-6 m-0 rounded-0 border-end" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-lg btn-link fs-6 text-decoration-none col-6 m-0 rounded-0"><strong>Okay</strong></button>
          </div>
        </form>
      </div>
    </div>

    <!-- Confirm Modal -->
    <script type="text/html" id="js-tpl-confirm">
        <div class="modal modal-alert confirmDailog" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" role="dialog" id="confirmDailog-<%this.id%>">
          <div class="modal-dialog" role="document">
            <form class="modal-content rounded-3 shadow text-white bg-dark" method="post" autocomplete="off" action="<%this.action%>">
              <div class="modal-body p-4 text-center">
                <h5 class="mb-2">Are you sure want to <%this.title%> ?</h5>
                <p class="mb-1"><%this.content%></p>
              </div>
              <div class="modal-footer flex-nowrap p-0">
                <button type="button" class="btn btn-lg btn-link fs-6 text-decoration-none col-6 m-0 rounded-0 border-end" data-bs-dismiss="modal">Cancel</button>
                <input type="hidden" name="token" value="ae663efa8e54936feac58bd3e07d972d5e5c6e15fec74ac0e42008d4c2864196">
                <button type="submit" class="btn btn-lg btn-link fs-6 text-decoration-none col-6 m-0 rounded-0" data-bs-dismiss="modal"><strong>Okay</strong></button>
              </div>
            </form>
          </div>
        </div>
    </script>

        <nav class="navbar navbar-expand-lg text-white bg-dark navbar-light navbar-dark mb-4 main-nav fixed-top">
        <a class="navbar-brand"> File Manager </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <div class="col-xs-6 col-sm-5"><a href="/"><i class="fa fa-tachometer" title="Main Dashboard"></a></i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='?p='><i class='fa fa-home' aria-hidden='true' title='/'></i></a><i class="bread-crumb"> / </i><a href='?p=var'>var</a><i class="bread-crumb"> / </i><a href='?p=var%2Fwww'>www</a><i class="bread-crumb"> / </i><a href='?p=var%2Fwww%2Fhttp'>http</a><i class="bread-crumb"> / </i><a href='?p=var%2Fwww%2Fhttp%2Fcouleurs'>couleurs</a></div>
            <div class="col-xs-6 col-sm-7">
                <ul class="navbar-nav justify-content-end text-white bg-dark">
                    <li class="nav-item mr-2">
                        <div class="input-group input-group-sm mr-1" style="margin-top:4px;">
                            <input type="text" class="form-control" placeholder="Filter" aria-label="Search" aria-describedby="search-addon2" id="search-addon">
                            <div class="input-group-append">
                                <span class="input-group-text brl-0 brr-0" id="search-addon2"><i class="fa fa-search"></i></span>
                            </div>
                            <div class="input-group-append btn-group">
                                <span class="input-group-text dropdown-toggle brl-0" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></span>
                                  <div class="dropdown-menu dropdown-menu-right">
                                    <a class="dropdown-item" href="var/www/http/couleurs" id="js-search-modal" data-bs-toggle="modal" data-bs-target="#searchModal">Advanced Search</a>
                                  </div>
                            </div>
                        </div>
                    </li>
                                        <li class="nav-item">
		      	<a title="Back to Advanced Config. Area" class="nav-link" href="/admin/advanced/"><i class="fa fa-arrow-circle-left" aria-hidden="true"></i> Back to Advanced Area</a>
                    </li>
                    <li class="nav-item">
                        <a title="Upload" class="nav-link" href="?p=var%2Fwww%2Fhttp%2Fcouleurs&amp;upload"><i class="fa fa-cloud-upload" aria-hidden="true"></i> Upload</a>
                    </li>
                    <li class="nav-item">
                        <a title="New Item" class="nav-link" href="#createNewItem" data-bs-toggle="modal" data-bs-target="#createNewItem"><i class="fa fa-plus-square"></i> New Item</a>
                    </li>
                                                                                            <li class="nav-item">
                                <a title="Settings" class="dropdown-item nav-link" href="?p=var%2Fwww%2Fhttp%2Fcouleurs&amp;settings=1"><i class="fa fa-cog" aria-hidden="true"></i> Settings</a>
                            </li>
                                                            </ul>
            </div>
        </div>
    </nav>
    <form action="" method="post" class="pt-3">
    <input type="hidden" name="p" value="var/www/http/couleurs">
    <input type="hidden" name="group" value="1">
    <input type="hidden" name="token" value="ae663efa8e54936feac58bd3e07d972d5e5c6e15fec74ac0e42008d4c2864196">
    <div class="table-responsive">
        <table class="table table-bordered table-hover table-sm text-white bg-dark table-dark" id="main-table">
            <thead class="thead-white">
            <tr>
                                    <th style="width:3%" class="custom-checkbox-header">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="js-select-all-items" onclick="checkbox_toggle()">
                            <label class="custom-control-label" for="js-select-all-items"></label>
                        </div>
                    </th>                <th>Name</th>
                <th>Size</th>
                <th>Modified</th>
                                    <th>Perms</th>
                    <th>Owner</th>                <th>Actions</th>
            </tr>
            </thead>
                  <tr>
                    <td class="nosort"></td>
                    <td class="border-0" data-sort><a href="http://amiatous.ddns.net"><i class="fa fa-chevron-circle-left go-back"></i> ..</a></td>
                    <td class="border-0" data-order></td>
                    <td class="border-0" data-order></td>
                    <td class="border-0"></td>
                    <td class="border-0"></td>
                    <td class="border-0"></td>
                 </tr>

                 <tr>
                                            <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6070" name="file[]" value="3Etapes.png">
                            <label class="custom-control-label" for="6070"></label>
                        </div>
                        </td>                    <td data-sort=3Etapes.png>
                        <div class="filename">
                                                                                        <a href="3Etapes.png" data-preview-image="3Etapes.png" title="3Etapes.png">
                                                               <i class="fa fa-picture-o"></i> 3Etapes.png                                </a>
                                                        </div>
                    </td>
                    <td data-order="b-000000000000488395"><span title="488395 bytes">
                        476.95 KB                        </span></td>
                    <td data-order="b-1733072642">12/01/2024 5:04 PM</td>
                       <td><a title="Change Permissions" href="3Etapes.png">0644</a>                        </td>
                        <td>www-data:www-data</td>
                          <td class="inline-actions">
                            <a title="Download" href="3Etapes.png" target="_blank"><i class="fa fa-download"></i></a>
                          </td>
                </tr>

                <tr>
                                            <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6071" name="file[]" value="rpt1vdc_Bleu-Jeans-Yello-164.png">
                            <label class="custom-control-label" for="6071"></label>
                        </div>
                        </td>                    <td data-sort=rpt1vdc_Bleu-Jeans-Yello-164.png>
                        <div class="filename">
                                                                                        <a href="rpt1vdc_Bleu-Jeans-Yello-164.png" data-preview-image="rpt1vdc_Bleu-Jeans-Yello-164.png" title="rpt1vdc_Bleu-Jeans-Yello-164.png">
                                                               <i class="fa fa-picture-o"></i> rpt1vdc_Bleu-Jeans-Yello-164.png                                </a>
                                                        </div>
                    </td>
                    <td data-order="b-000000000000000549"><span title="549 bytes">
                        549 B                        </span></td>
                    <td data-order="b-1748021193">05/23/2025 5:26 PM</td>
                       <td><a title="Change Permissions" href="WPSD_CSS_rpt1vdc_Bleu-Jeans-Yello-164.zip">0644</a>                        </td>
                        <td>www-data:www-data</td>
                          <td class="inline-actions">
                            <a title="Download" href="WPSD_CSS_rpt1vdc_Bleu-Jeans-Yello-164.zip" target="_blank"><i class="fa fa-download"></i></a>
                          </td>
                </tr>

                <tr>
                                            <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6072" name="file[]" value="rpt2vdc_Dark-Yello-174.png">
                            <label class="custom-control-label" for="6072"></label>
                        </div>
                        </td>                    <td data-sort=rpt2vdc_Dark-Yello-174.png>
                        <div class="filename">
                                                                                        <a href="rpt2vdc_Dark-Yello-174.png" data-preview-image="rpt2vdc_Dark-Yello-174.png" title="rpt2vdc_Dark-Yello-174.png">
                                                               <i class="fa fa-picture-o"></i> rpt2vdc_Dark-Yello-174.png                                </a>
                                                        </div>
                    </td>
                    <td data-order="b-000000000000000550"><span title="550 bytes">
                        550 B                        </span></td>
                    <td data-order="b-1748021193">05/23/2025 5:26 PM</td>
                       <td><a title="Change Permissions" href="WPSD_CSS_rpt2vdc_Dark-Yello-174.zip">0644</a>                        </td>
                        <td>www-data:www-data</td>
                          <td class="inline-actions">
                            <a title="Download" href="WPSD_CSS_rpt2vdc_Dark-Yello-174.zip" target="_blank"><i class="fa fa-download"></i></a>
                          </td>
                </tr>

                <tr>
                                            <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6073" name="file[]" value="rpt3vdc_Bleu-Or-184.png">
                            <label class="custom-control-label" for="6073"></label>
                        </div>
                        </td>                    <td data-sort=rpt3vdc_Bleu-Or-184.png>
                        <div class="filename">
                                                                                        <a href="rpt3vdc_Bleu-Or-184.png" data-preview-image="rpt3vdc_Bleu-Or-184.png" title="rpt3vdc_Bleu-Or-184.png">
                                                               <i class="fa fa-picture-o"></i> rpt3vdc_Bleu-Or-184.png                                </a>
                                                        </div>
                    </td>
                    <td data-order="b-000000000000000554"><span title="554 bytes">
                        554 B                        </span></td>
                    <td data-order="b-1748021193">05/23/2025 5:26 PM</td>
                       <td><a title="Change Permissions" href="WPSD_CSS_rpt3vdc_Bleu-Or-184.zip">0644</a>                        </td>
                        <td>www-data:www-data</td>
                          <td class="inline-actions">
                            <a title="Download" href="WPSD_CSS_rpt3vdc_Bleu-Or-184.zip" target="_blank"><i class="fa fa-download"></i></a>
                          </td>
                </tr>

                <tr>
                                            <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6074" name="file[]" value="rptz-vdc_Bleu-Light-Orange-194.png">
                            <label class="custom-control-label" for="6074"></label>
                        </div>
                        </td>                    <td data-sort=rptz-vdc_Bleu-Light-Orange-194.png>
                        <div class="filename">
                                                                                        <a href="rptz-vdc_Bleu-Light-Orange-194.png" data-preview-image="rptz-vdc_Bleu-Light-Orange-194.png" title="rptz-vdc_Bleu-Light-Orange-194.png">
                                                               <i class="fa fa-picture-o"></i> rptz-vdc_Bleu-Light-Orange-194.png                                </a>
                                                        </div>
                    </td>
                    <td data-order="b-000000000000000552"><span title="552 bytes">
                        552 B                        </span></td>
                    <td data-order="b-1748021193">05/23/2025 5:26 PM</td>
                       <td><a title="Change Permissions" href="WPSD_CSS_rptz-vdc_Bleu-Light-Orange-194.zip">0644</a>                        </td>
                        <td>www-data:www-data</td>
                          <td class="inline-actions">
                            <a title="Download" href="WPSD_CSS_rptz-vdc_Bleu-Light-Orange-194.zip" target="_blank"><i class="fa fa-download"></i></a>
                          </td>
                </tr>

                <tr>
                                            <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6075" name="file[]" value="zhs1vdc_Blue_Dark-Orange-144.png">
                            <label class="custom-control-label" for="6075"></label>
                        </div>
                        </td>                    <td data-sort=zhs1vdc_Blue_Dark-Orange-144.png>
                        <div class="filename">
                                                                                        <a href="zhs1vdc_Blue_Dark-Orange-144.png" data-preview-image="zhs1vdc_Blue_Dark-Orange-144.png" title="zhs1vdc_Blue_Dark-Orange-144.png">
                                                               <i class="fa fa-picture-o"></i> zhs1vdc_Blue_Dark-Orange-144.png                                </a>
                                                        </div>
                    </td>
                    <td data-order="b-000000000000000553"><span title="553 bytes">
                        553 B                        </span></td>
                    <td data-order="b-1748021193">05/23/2025 5:26 PM</td>
                       <td><a title="Change Permissions" href="WPSD_CSS_zhs1vdc_Blue_Dark-Orange-144.zip">0644</a>                        </td>
                        <td>www-data:www-data</td>
                          <td class="inline-actions">
                            <a title="Download" href="WPSD_CSS_zhs1vdc_Blue_Dark-Orange-144.zip" target="_blank"><i class="fa fa-download"></i></a>
                          </td>
                </tr>




                <tr>
                                            <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6076" name="file[]" value="zhs0-vdc_Bleu_Bleu-Yello154.png">
                            <label class="custom-control-label" for="6076"></label>
                        </div>
                        </td>                    <td data-sort=zhs0-vdc_Bleu_Bleu-Yello154.png>
                        <div class="filename">
                                                                                        <a href="zhs0-vdc_Bleu_Bleu-Yello154.png" data-preview-image="zhs0-vdc_Bleu_Bleu-Yello154.png" title="zhs0-vdc_Bleu_Bleu-Yello154.png">
                                                               <i class="fa fa-picture-o"></i> zhs0-vdc_Bleu_Bleu-Yello154.png                                </a>
                                                        </div>
                    </td>
                    <td data-order="b-000000000000000550"><span title="550 bytes">
                        550 B                        </span></td>
                    <td data-order="b-1748021193">05/23/2025 5:26 PM</td>
                       <td><a title="Change Permissions" href="WPSD_CSS_zhs0-vdc_Bleu_Bleu-Yello-154.zip">0644</a>                        </td>
                        <td>www-data:www-data</td>
                          <td class="inline-actions">
                            <a title="Download" href="WPSD_CSS_zhs0-vdc_Bleu_Bleu-Yello-154.zip" target="_blank"><i class="fa fa-download"></i></a>
                          </td>
                </tr>




                <tr>
                                            <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6077" name="file[]" value="Blanc-Blanc-gris.png">
                            <label class="custom-control-label" for="6077"></label>
                        </div>
                        </td>                    <td data-sort=Blanc-Blanc-gris.png>
                        <div class="filename">
                                                                                        <a href="Blanc-Blanc-gris.png" data-preview-image="Blanc-Blanc-gris.png" title="Blanc-Blanc-gris.png">
                                                               <i class="fa fa-picture-o"></i> Blanc-Blanc-gris.png </a>
                                                        </div>
                    </td>
                    <td data-order="b-000000000000000550"><span title="550 bytes">
                        550 B                        </span></td>
                    <td data-order="b-1748021193">05/23/2025 5:26 PM</td>
                       <td><a title="Change Permissions" href="WPSD_CSS_zhs2-Blanc-Blanc-Gris.zip">0644</a>                        </td>
                        <td>www-data:www-data</td>
                          <td class="inline-actions">
                            <a title="Download" href="WPSD_CSS_zhs2-Blanc-Blanc-Gris.zip" target="_blank"><i class="fa fa-download"></i></a>
                          </td>
                </tr>




                <tr>
                                            <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6078" name="file[]" value="Gris-Blanc-Couleur.png">
                            <label class="custom-control-label" for="6078"></label>
                        </div>
                        </td>                    <td data-sort=Gris-Blanc-Couleur.png>
                        <div class="filename">
                                                                                        <a href="Gris-Blanc-Couleur.png" data-preview-image="Gris-Blanc-Couleur.png" title="Gris-Blanc-Couleur.png">
                                                               <i class="fa fa-picture-o"></i> Gris-Blanc-Couleur.png  </a>
                                                        </div>
                    </td>
                    <td data-order="b-000000000000000550"><span title="550 bytes">
                        550 B                        </span></td>
                    <td data-order="b-1748021193">05/23/2025 5:26 PM</td>
                       <td><a title="Change Permissions" href="WPSD_CSS_zhs2-Gris-Blanc-Couleur.zip">0644</a>                        </td>
                        <td>www-data:www-data</td>
                          <td class="inline-actions">
                            <a title="Download" href="WPSD_CSS_zhs2-Gris-Blanc-Couleur.zip" target="_blank"><i class="fa fa-download"></i></a>
                          </td>
                </tr>





                <tr>
                                            <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6079" name="file[]" value="Gris-Blanc-Couleur2.png">
                            <label class="custom-control-label" for="6079"></label>
                        </div>
                        </td>                    <td data-sort=Gris-Blanc-Couleur2.png>
                        <div class="filename">
                                                                                        <a href="Gris-Blanc-Couleur2.png" data-preview-image="Gris-Blanc-Couleur2.png" title="Gris-Blanc-Couleur2.png">
                                                               <i class="fa fa-picture-o"></i> Gris-Blanc-Couleur2.png  </a>
                                                        </div>
                    </td>
                    <td data-order="b-000000000000000550"><span title="550 bytes">
                        550 B                        </span></td>
                    <td data-order="b-1748021193">05/23/2025 5:26 PM</td>
                       <td><a title="Change Permissions" href="WPSD_CSS_zhs2-Gris-Blanc-Couleur2.zip">0644</a>                        </td>
                        <td>www-data:www-data</td>
                          <td class="inline-actions">
                            <a title="Download" href="WPSD_CSS_zhs2-Gris-Blanc-Couleur2.zip" target="_blank"><i class="fa fa-download"></i></a>
                          </td>
                </tr>
















                <tr>
                 <td class="custom-checkbox-td">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="6080" name="file[]" value="appearance2">
                            <label class="custom-control-label" for="6080"></label>
                        </div>
                  </td>
                   <td data-sort=appearance2> <div class="filename"> <a href="/admin/appearance2.php" title="appearance2"> </a> </div> </td>
                     <td data-order="b-000000000000000550"><span title="550 bytes"> </span></td>
                      <td data-order="b-1748021193"> </td>
                       <td> </td>
                        <td> </td>
                         <td class="inline-actions"><a title="Download" href="/admin/appearance2.php" target="_blank"><i class="fa fa-download"></i></a> </td>
                </tr>






                                <tfoot>
                    <tr>
                        <td class="gray" colspan="7">
                            Full Size: <span class="badge text-bg-light border-radius-0">480.26 KB</span>                            File: <span class="badge text-bg-light border-radius-0">7</span>                            Folder: <span class="badge text-bg-light border-radius-0">0</span>                        </td>
                    </tr>
                </tfoot>
                        </table>
    </div>

    <        <div class="col-3 d-none d-sm-block float-right text-muted">Tiny File Manager <span title='VDC Version # b8e6356c05'>VDC Ver.# b8e6356c05</span></a></div>
            </div>
</form>

</div>
<script src="https://code.jquery.com/jquery-3.6.1.min.js" integrity="sha256-o88AwQnZB+VDvE9tvIXrMQaPlFFSUTR+nldQm1LuPXQ=" crossorigin="anonymous"></script><script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-OERcA2EqjJCMA+/3y+gxIOqMEjwtxJY7qPCqsdltbNJuaOe923+mo//f6V8Qbsw3" crossorigin="anonymous"></script><script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js" crossorigin="anonymous" defer></script><script>
    function template(html,options){
        var re=/<\%([^\%>]+)?\%>/g,reExp=/(^( )?(if|for|else|switch|case|break|{|}))(.*)?/g,code='var r=[];\n',cursor=0,match;var add=function(line,js){js?(code+=line.match(reExp)?line+'\n':'r.push('+line+');\n'):(code+=line!=''?'r.push("'+line.replace(/"/g,'\\"')+'");\n':'');return add}
        while(match=re.exec(html)){add(html.slice(cursor,match.index))(match[1],!0);cursor=match.index+match[0].length}
        add(html.substr(cursor,html.length-cursor));code+='return r.join("");';return new Function(code.replace(/[\r\t\n]/g,'')).apply(options)
    }
    function rename(e, t) { if(t) { $("#js-rename-from").val(t);$("#js-rename-to").val(t); $("#renameDailog").modal('show'); } }
    function change_checkboxes(e, t) { for (var n = e.length - 1; n >= 0; n--) e[n].checked = "boolean" == typeof t ? t : !e[n].checked }
    function get_checkboxes() { for (var e = document.getElementsByName("file[]"), t = [], n = e.length - 1; n >= 0; n--) (e[n].type = "checkbox") && t.push(e[n]); return t }
    function select_all() { change_checkboxes(get_checkboxes(), !0) }
    function unselect_all() { change_checkboxes(get_checkboxes(), !1) }
    function invert_all() { change_checkboxes(get_checkboxes()) }
    function checkbox_toggle() { var e = get_checkboxes(); e.push(this), change_checkboxes(e) }
    function backup(e, t) { // Create file backup with .bck
        var n = new XMLHttpRequest,
            a = "path=" + e + "&file=" + t + "&token="+ window.csrf +"&type=backup&ajax=true";
        return n.open("POST", "", !0), n.setRequestHeader("Content-type", "application/x-www-form-urlencoded"), n.onreadystatechange = function () {
            4 == n.readyState && 200 == n.status && toast(n.responseText)
        }, n.send(a), !1
    }
    // Toast message
    function toast(txt) { var x = document.getElementById("snackbar");x.innerHTML=txt;x.className = "show";setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000); }
    // Save file
    function edit_save(e, t) {
        var n = "ace" == t ? editor.getSession().getValue() : document.getElementById("normal-editor").value;
        if (typeof n !== 'undefined' && n !== null) {
            if (true) {
                var data = {ajax: true, content: n, type: 'save', token: window.csrf};

                $.ajax({
                    type: "POST",
                    url: window.location,
                    data: JSON.stringify(data),
                    contentType: "application/json; charset=utf-8",
                    success: function(mes){toast("Saved Successfully"); window.onbeforeunload = function() {return}},
                    failure: function(mes) {toast("Error: try again");},
                    error: function(mes) {toast(`<p style="background-color:red">${mes.responseText}</p>`);}
                });
            } else {
                var a = document.createElement("form");
                a.setAttribute("method", "POST"), a.setAttribute("action", "");
                var o = document.createElement("textarea");
                o.setAttribute("type", "textarea"), o.setAttribute("name", "savedata");
                let cx = document.createElement("input"); cx.setAttribute("type", "hidden");cx.setAttribute("name", "token");cx.setAttribute("value", window.csrf);
                var c = document.createTextNode(n);
                o.appendChild(c), a.appendChild(o), a.appendChild(cx), document.body.appendChild(a), a.submit()
            }
        }
    }
    function show_new_pwd() { $(".js-new-pwd").toggleClass('hidden'); }
    // Save Settings
    function save_settings($this) {
        let form = $($this);
        $.ajax({
            type: form.attr('method'), url: form.attr('action'), data: form.serialize()+"&token="+ window.csrf +"&ajax="+true,
            success: function (data) {if(data) { window.location.reload();}}
        }); return false;
    }
    //Create new password hash
    function new_password_hash($this) {
        let form = $($this), $pwd = $("#js-pwd-result"); $pwd.val('');
        $.ajax({
            type: form.attr('method'), url: form.attr('action'), data: form.serialize()+"&token="+ window.csrf +"&ajax="+true,
            success: function (data) { if(data) { $pwd.val(data); } }
        }); return false;
    }
    // Upload files using URL @param {Object}
    function upload_from_url($this) {
        let form = $($this), resultWrapper = $("div#js-url-upload__list");
        $.ajax({
            type: form.attr('method'), url: form.attr('action'), data: form.serialize()+"&token="+ window.csrf +"&ajax="+true,
            beforeSend: function() { form.find("input[name=uploadurl]").attr("disabled","disabled"); form.find("button").hide(); form.find(".lds-facebook").addClass('show-me'); },
            success: function (data) {
                if(data) {
                    data = JSON.parse(data);
                    if(data.done) {
                        resultWrapper.append('<div class="alert alert-success row">Uploaded Successful: '+data.done.name+'</div>'); form.find("input[name=uploadurl]").val('');
                    } else if(data['fail']) { resultWrapper.append('<div class="alert alert-danger row">Error: '+data.fail.message+'</div>'); }
                    form.find("input[name=uploadurl]").removeAttr("disabled");form.find("button").show();form.find(".lds-facebook").removeClass('show-me');
                }
            },
            error: function(xhr) {
                form.find("input[name=uploadurl]").removeAttr("disabled");form.find("button").show();form.find(".lds-facebook").removeClass('show-me');console.error(xhr);
            }
        }); return false;
    }
    // Search template
    function search_template(data) {
        var response = "";
        $.each(data, function (key, val) {
            response += `<li><a href="?p=${val.path}&view=${val.name}">${val.path}/${val.name}</a></li>`;
        });
        return response;
    }
    // Advance search
    function fm_search() {
        var searchTxt = $("input#advanced-search").val(), searchWrapper = $("ul#search-wrapper"), path = $("#js-search-modal").attr("href"), _html = "", $loader = $("div.lds-facebook");
        if(!!searchTxt && searchTxt.length > 2 && path) {
            var data = {ajax: true, content: searchTxt, path:path, type: 'search', token: window.csrf };
            $.ajax({
                type: "POST",
                url: window.location,
                data: data,
                beforeSend: function() {
                    searchWrapper.html('');
                    $loader.addClass('show-me');
                },
                success: function(data){
                    $loader.removeClass('show-me');
                    data = JSON.parse(data);
                    if(data && data.length) {
                        _html = search_template(data);
                        searchWrapper.html(_html);
                    } else { searchWrapper.html('<p class="m-2">No result found!<p>'); }
                },
                error: function(xhr) { $loader.removeClass('show-me'); searchWrapper.html('<p class="m-2">ERROR: Try again later!</p>'); },
                failure: function(mes) { $loader.removeClass('show-me'); searchWrapper.html('<p class="m-2">ERROR: Try again later!</p>');}
            });
        } else { searchWrapper.html("OOPS: minimum 3 characters required!"); }
    }

    // action confirm dailog modal
    function confirmDailog(e, id = 0, title = "Action", content = "", action = null) {
        e.preventDefault();
        const tplObj = {id, title, content: decodeURIComponent(content.replace(/\+/g, ' ')), action};
        let tpl = $("#js-tpl-confirm").html();
        $(".modal.confirmDailog").remove();
        $('#wrapper').append(template(tpl,tplObj));
        const $confirmDailog = $("#confirmDailog-"+tplObj.id);
        $confirmDailog.modal('show');
        return false;
    }
    

    // on mouse hover image preview
    !function(s){s.previewImage=function(e){var o=s(document),t=".previewImage",a=s.extend({xOffset:20,yOffset:-20,fadeIn:"fast",css:{padding:"5px",border:"1px solid #cccccc","background-color":"#fff"},eventSelector:"[data-preview-image]",dataKey:"previewImage",overlayId:"preview-image-plugin-overlay"},e);return o.off(t),o.on("mouseover"+t,a.eventSelector,function(e){s("p#"+a.overlayId).remove();var o=s("<p>").attr("id",a.overlayId).css("position","absolute").css("display","none").append(s('<img class="c-preview-img">').attr("src",s(this).data(a.dataKey)));a.css&&o.css(a.css),s("body").append(o),o.css("top",e.pageY+a.yOffset+"px").css("left",e.pageX+a.xOffset+"px").fadeIn(a.fadeIn)}),o.on("mouseout"+t,a.eventSelector,function(){s("#"+a.overlayId).remove()}),o.on("mousemove"+t,a.eventSelector,function(e){s("#"+a.overlayId).css("top",e.pageY+a.yOffset+"px").css("left",e.pageX+a.xOffset+"px")}),this},s.previewImage()}(jQuery);

    // Dom Ready Events
    $(document).ready( function () {
        // dataTable init
        var $table = $('#main-table'),
            tableLng = $table.find('th').length,
            _targets = (tableLng && tableLng == 7 ) ? [0, 4,5,6] : tableLng == 5 ? [0,4] : [3];
            mainTable = $('#main-table').DataTable({paging: false, info: false, order: [], columnDefs: [{targets: _targets, orderable: false}]
        });
        // filter table
        $('#search-addon').on( 'keyup', function () {
            mainTable.search( this.value ).draw();
        });
        $("input#advanced-search").on('keyup', function (e) {
            if (e.keyCode === 13) { fm_search(); }
        });
        $('#search-addon3').on( 'click', function () { fm_search(); });
        //upload nav tabs
        $(".fm-upload-wrapper .card-header-tabs").on("click", 'a', function(e){
            e.preventDefault();let target=$(this).data('target');
            $(".fm-upload-wrapper .card-header-tabs a").removeClass('active');$(this).addClass('active');
            $(".fm-upload-wrapper .card-tabs-container").addClass('hidden');$(target).removeClass('hidden');
        });
    });
</script>
<div id="snackbar"></div>
</body>
</html>
