<?php
session_start();
// Chronométrage du début
$start = microtime(true);

//  -*-*--*-*-*-*-*-*-*-*-  Démarrage de session  -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

// Liste des couleurs valides (optionnel, à garder pour validation)
$bgColor0Options = ['#030304', '#838384', '#074C88'];
$bgColor2Options = ['#333434', '#043464', '#532363', '#838393', '#430303', '#E7E7E7', '#274D8F', '#EFA74F'];

// Chemin relatif vers colors.json
$jsonFile = __DIR__ . '/css/colors.json';

// Lecture du fichier colors.json (si présent)
//  *** if(file_exists($jsonFile)) {
//  ***     $savedColors = json_decode(file_get_contents($jsonFile), true); //  ***** $bgColor0  & $bgColor2  *******
//  *** } else {
//  ***      $savedColors = [];
//  ***  }

// Lecture du JSON
$jsonColors = [];
if(file_exists($jsonFile)) {
    $jsonColors = json_decode(file_get_contents($jsonFile), true); //  ***** $bgColor0  & $bgColor2  *******
}

// Récupérer couleur de la session, sinon du JSON, sinon valeur hardcodée
$bgColor0 = $_SESSION['bgColor0'] ?? ($jsonColors['bgColor0'] ?? $bgColor0Options[0]); // *** $bgColor0Options[0] *** $saveColors[$bgColor0] ***
$bgColor2 = $_SESSION['bgColor2'] ?? ($jsonColors['bgColor2'] ?? $bgColor2Options[0]); // *** $bgColor2Options[0] *** $saveColors[$bgColor2] ***

// Sécuriser la valeur avec validation
if (!in_array($bgColor0, $bgColor0Options)) $bgColor0 = $bgColor0Options[0]; // *****  $bgColor0Options[0]
if (!in_array($bgColor2, $bgColor2Options)) $bgColor2 = $bgColor2Options[0]; // *****  $bgColor2Options[0]

// Lecture et validation des couleurs depuis session ou valeurs par défaut
$selectedBgColor0 = $_SESSION['bgColor0'] ?? $bgColor0Options[2];
if (!in_array($selectedBgColor0, $bgColor0Options)) {
    $selectedBgColor0 = $bgColor0Options[2];
}

$selectedBgColor2 = $_SESSION['bgColor2'] ?? $bgColor2Options[0];
if (!in_array($selectedBgColor2, $bgColor2Options)) {
    $selectedBgColor2 = $bgColor2Options[0];
}

// Inclusions indispensables, ne pas toucher
     if (file_exists("config/config.php")) include "config/config.php";
     if (file_exists("config/Bconfig.php")) include "config/Bconfig.php";
     include "include/tools.php";
     include "include/functions.php";
     include "include/init.php";
     include "version.php";

// Début du HTML --**--**--**--**--**--**--**--**--**--
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
      <title><?php echo getConfigItem("Info", "Name", $configs); ?> - Reflecteur-YSF Tableau-De-Bord VA2VDC</title>

      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <meta name="description" content="YSF-Reflecteur Tableau de Bord Fr Par VA2VDC">
      <meta name="author" content="DG9VH, KC1AWV, VA2VDC">
      <!-- meta http-equiv="refresh" content="<?php echo REFRESHAFTER; ?>" -->
  <!-- So refresh works every time -->
      <meta http-equiv="expires" content="0">

<style>
  :root {
    --BGround-color2: <?= $bgColor2 ?>;
    --BGround-color0: <?= $bgColor0 ?>;
  }
</style>

  <!-- Bootstrap core CSS -->
      <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
      <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">

  <!-- Bootstrap core JavaScript -->
  <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>

  <!-- Datatables -->
      <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">

  <!-- Inclure le script de la librairie emoji-picker-element -->
      <!-- script type="module" src="https://cdn.jsdelivr.net/npm/emoji-picker-element@^1/index.js"></script --> 
  <script type="module" src="/js/index.js"></script>

  <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>

    <!-- Le reste de ta partie head -->
    <link rel="stylesheet" href="/css/custom.css.php?v=<?=filemtime(__DIR__.'/css/custom.css.php')?>">
    <link rel="stylesheet" href="/css/custom.css">
</head>

<body class="navbar" style="background-color: #131414; color: #FF2222;2">

<!-- Ton contenu HTML -->
<?php
if ($bgColor0 == "#030304") {
    $ColorA = "#F0804F";
    $ColorB = "#E8301F";
    $ColorC = "#50505F";
} elseif ($bgColor0 == "#074C88") {
    $ColorA = "#F0F0FF";
    $ColorB = "#30A0FF";
    $ColorC = "#A0A0AF";
} else {
    $ColorA = "#001048";
    $ColorB = "#481000";
    $ColorC = "#50505F";
}
?>

 <!-- Navigation ------------------------------------------------------   -->
<?php checkSetup(); ?>
 <!-- Page Content  ------------------- Haut de Page -------------------------------------------------  -->
<div class="boz">
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor0 ?>; color: #9090DC"> <!-- fixed-top  or static-top   -->
    <div class="container-fluid" style=" color: #9090DF";>
      <span class="float:left">
        <a class="navbar-brand" href="#" style=" color: <?= $ColorA ?>";>-Reflecteur-YSF- <?php echo getConfigItem("Info", "Name", $configs); ?> / <?php echo getConfigItem("Info", "Description", $configs); ?> (#<?php echo getConfigItem("Info", "Id", $configs); ?>)</a>
      </span>
      <span class="navbar-brand float:center" style=" color: <?= $ColorC ?>";>
        <a id="chatLink" target="_new" href="/SChatSetup.php" style=" color: <?= $ColorC ?>";>Version: </a><a id="chatLink" target="_new" href="/InfoBSetup.php" style=" color: <?= $ColorC ?>";><?php  echo getYSFReflectorVersion(); ?></a>
      </span>
      <span class="navbar-brand float:right" style=" color: <?= $ColorB ?>";>
     <a id="chatLink" target="_new" href="/couleurs.php" style=" color: <?= $ColorB ?>";>  System Fusion IP </a>
     </span>
    </div>
  </nav>


 <!-- Page Content  ------------------- InfoBSetup --------------------------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
     <div class="container-fluid">
      <div class="col-12"><div class="row" style="size:210;"><div class="col"><?php include "/InfoBSetup.php"; ?></div></div></div>

  </nav>

 <!-- Page Content  ------------------- SCahSetup ---------------------------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
     <div class="container-fluid">
      <div class="col-12"><div class="row" style="size:210;"><div class="col"><?php include "/SChatSetup.php"; ?></div></div></div>

  </nav>

 <!-- Page Content  ------------------- DenyIP ------------------------------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
    <div class="container-fluid">
     <div class="col-12"><div class="row" style="size:210;"><div class="col"><?php include "/DenyIP.php"; ?></div></div></div>

  </nav>






 <!-- Page Content  -------------------- Bas De Page -----------------------------------------------------  -->
     <nav class="flex-container" style="background-color: #484A4A; color: #9090DC">
      <div class="flex-container" style="background-color: #484A4A; color: #FFF8EF;">
       <?php
        $lastReload = new DateTime();
        $lastReload->setTimezone(new DateTimeZone(TIMEZONE));
        echo "YSF-Dashboard Ver.: ".VERSION." | M.a.J. le : ".$lastReload->format('d-m-Y,  H:i:s')." (".TIMEZONE.")";
       ?> | <a href="<?php 
       if (!file_exists('YSF_D_Board-FR.tar.gz')) { 
           echo"http://amiatous.ddns.net:8081/indexC.php";
       } else { 
           echo "YSF_D_Board-FR.tar.gz";
              }
       ?>">Votre Copie Ici:</a> <-Fr-  -En-> <a href="https://github.com/dg9vh/YSFReflector-Dashboard"> DG9VH YSFReflector-Dashboard </a><a id="chatLink" target="_new" href="/couleurs.php"> . </a>
     </div>
    </nav>

   <p><?php

// Chronométrage du début
$finish = microtime(true);
$total_time = round(($finish - $start), 4);

echo "<br><p style='text-align: center; font-size: 1.5em; color: #15FDE0;'>Page produite en -> " . $total_time . " <- Secondes.</p>";
echo "<p style='text-align: center; font-size: 1.2em;'>Nombre de visites : " . $count . "</p>";
?></p><br>

  </div><!--  Container last div  -->
 </body>
</html>
