<?php
session_start(); // OBLIGATOIRE avant tout output
header("Content-type: text/css; charset=UTF-8");

// Chemin vers le fichier de configuration JSON
$configFile = __DIR__ . '/colors.json';

// Couleurs par défaut
$bgColor0 = '#030304';
$bgColor2 = '#532363';

// Si le fichier existe, lire les couleurs
if (file_exists($configFile)) {
    $config = json_decode(file_get_contents($configFile), true);
    if (is_array($config)) {
        $bgColor0 = $config['bgColor0'] ?? $bgColor0;
        $bgColor2 = $config['bgColor2'] ?? $bgColor2;
    }
}

echo <<<CSS
/* custom.css */
  :root {
    --BGround-color0: <?= $bgColor0 ?>;
    --BGround-color2: <?= $bgColor2 ?>;
  }
</style>

body {
  font-family: Arial, sans-serif;
  margin: 0 auto;
  max-width: 100%;
  background-color: #131414;
  color: #f1f1f1;
  padding: 0;
/*  box-shadow: inset 0 0 5px rgba(F, F, F, 0.7); */
}

.box {
  flex: 1 1 35%;
  background-color: var(--BGround-color2); 
  margin: 1px auto;
  padding: 3px;
  box-sizing: border-box;
  border-radius: 15px;
  color: #F1E12F;
  max-height: 750px;
  overflow-y: auto;
/*  box-shadow: inset 0 0 5px rgba(F, F, F, 0.7); */
}

.flex-container {
  display: flex;
  background-color: var(--BGround-color2); 
  gap: 5px;
  margin: 1px auto;
  flex-wrap: wrap;
}

.boxy {
  flex: 1 1 60%;
  color: #F00;
  background-color: var(--BGround-color2); 
  margin: 0 auto;
  padding: 4px 0px 0px 0px;
  box-sizing: border-box;
  border-radius: 15px;
/*  box-shadow: inset 0 0 5px rgba(F, F, F, 0.7); */
}

.flex-container1 {
  display: flex;
  background-color: var(--BGround-color2); 
  gap: 5px;
  padding: 0;
  flex-wrap: wrap;
}

/* Tu peux ajouter ici d'autres variables dynamiques */
CSS;