window.addEventListener('DOMContentLoaded', function () {
  // Le canvas image 2 Clic  *********************************
  const canvas = document.getElementById('canvas');
  const ctx = canvas.getContext('2d');
  const image = document.getElementById('image');
  let timer = null;
  // Fonction pour ajuster la taille du canvas
  function resizeCanvas() {
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
    if (image.complete && !timer) drawImage();
  }
  // Fonction pour dessiner l'image
  function drawImage() {
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    ctx.drawImage(image, 0, 0, canvas.width, canvas.height);
  }
  // Fonction pour faire disparaître l'image
  function hideImage() {
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    timer = setTimeout(() => {
      drawImage();
      timer = null;
    }, 2000);
  }
  image.onload = drawImage;
  canvas.addEventListener('touchstart', hideImage, false);
  canvas.addEventListener('mousedown', hideImage, false);
  window.addEventListener('resize', resizeCanvas);
  resizeCanvas();
  if (image.complete) drawImage();
});