// Effet de neige moderne et corrigé
document.addEventListener("DOMContentLoaded", () => {
  const snowCount = 51; // nombre de flocons De 15 a 100 *********************************
  const snowImg = "/js/img/snow.gif"; // chemin de l'image du flocon ** heart.png ou snow.gif ***
  const snowDistance = "pageheight"; // ou "windowheight"

  let snowflakes = [];
  let snowTimer;
  const snowContainer = document.createElement("div");
  snowContainer.style.position = "fixed";
  snowContainer.style.top = "0";
  snowContainer.style.left = "0";
  snowContainer.style.width = "100%";
  snowContainer.style.height = "100%";
  snowContainer.style.pointerEvents = "none";
  snowContainer.style.zIndex = "999";
  document.body.appendChild(snowContainer);

  // Création des flocons
  for (let i = 0; i < snowCount; i++) {
    const flake = document.createElement("img");
    flake.src = snowImg;
    flake.style.position = "absolute";
    const size = 5 + Math.random() * 33; // de 5 a 45px *****  ${size}px  ************
    flake.style.width = `${size}px`;  // = "10px"; a 50px ****************************
    flake.style.height = `${size}px`; // = "10px"; a 50px ****************************
    flake.style.top = `${Math.random() * window.innerHeight}px`;
    flake.style.left = `${Math.random() * window.innerWidth}px`;
    flake.style.userSelect = "none";

  // Couleur et opacité aléatoire  ou flake.style.filter = "hue-rotate(200deg)";
    const colors = ["#ffffff", "#b6d6f7", "#90bfef", "#2196f3"];
    flake.style.filter = `drop-shadow(0 0 5px ${colors[Math.floor(Math.random() * colors.length)]})`;
    flake.style.opacity = 0.5 + Math.random() * 0.5;

    snowContainer.appendChild(flake);

    snowflakes.push({
      element: flake,
      x: Math.random() * window.innerWidth,
      y: Math.random() * window.innerHeight,
      amplitude: 20 + Math.random() * 20,
      dx: 0,
      stx: 0.003 + Math.random() / 30,
      sty: 0.5 + Math.random(),
      wind: 0.1 + Math.random() * 0.4, // vitesse vent horizontal
    }); // stx *** default 0.02 & / 10 ***  ou  *** 0.005 & / 30 ************
  }

let lastTime = performance.now();
function animateSnow() {
  let now = performance.now();
  let deltaTime = (now - lastTime) / 16.67; // Normalise à 60fps
  lastTime = now;
    const width = snowDistance === "windowheight" ? window.innerWidth : document.documentElement.scrollWidth;
    const height = snowDistance === "windowheight" ? window.innerHeight : Math.max(document.body.scrollHeight, window.innerHeight);

    snowflakes.forEach((flake) => {
    flake.y += flake.sty * deltaTime;
    flake.x += flake.wind * deltaTime; // vent poussé vers la droite

      if (flake.y > height - 10) { // ************ Default - 50  **************
        flake.x = Math.random() * width;
        flake.y = 0;
      }
    if (flake.x > width) flake.x = 0;

      flake.dx += flake.stx;
      flake.element.style.top = `${flake.y}px`;
      flake.element.style.left = `${flake.x + flake.amplitude * Math.sin(flake.dx)}px`;
//    flake.element.style.transform = `scale(${0.5 + 0.5 * Math.sin(flake.dx)})`;

  });

    snowTimer = requestAnimationFrame(animateSnow);
  }

lastTime = performance.now();
animateSnow();


  // Optionnel : fonction pour masquer les flocons au bout d’un délai
  function hideSnow(delaySeconds = 0) {
    if (delaySeconds <= 0) return;
    setTimeout(() => {
      cancelAnimationFrame(snowTimer);
      snowContainer.style.display = "none";
    }, delaySeconds * 1000);
  }

  // Exemple : cacher la neige après 30 secondes
  // hideSnow(30);
});
