<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Fichiers disponibles</title>
    <style>
        body { font-family: Arial, sans-serif; background: #031333; }
        h1 { background: #07557F; color: #00E8F8; padding: 10px; text-shadow: 0px 0px 5px #000; }
        table { background: #8088AF; border-radius: 8px; width: 100%; margin-top: 20px; border-collapse: collapse; font-size: 1.35em; box-shadow: inset 0 0 5px rgba(0,0,0,0.7); }
        th, td { padding: 10px 15px; text-align: left; border-bottom: 1px solid #eee; text-shadow: 0px 0px 2px #000; }
        tr:hover { background: #AFBFDF; }
        a { color: #A01020; text-decoration: none; }
        .icon { margin-right: 8px; }
    </style>
</head>
<body>
    <h1>Fichiers disponibles / <a target="" href="../" style="background: #07557F; color: #EFE8AA; padding: 10px;"> Clic Ici Pour YSF Reflecteur </a></h1>
    <table>
        <tr>
            <th>Nom du fichier</th>
            <th>Taille</th>
            <th>Dernière modification</th>
        </tr>
        <?php
        $files = scandir(__DIR__);


// trier par date de modification décroissante
usort($files, function($a, $b) {
    // ignorer les entrées spéciales si besoin
    if ($a == '.' || $a == '..') return 1;
    if ($b == '.' || $b == '..') return -1;

    return filemtime($b) <=> filemtime($a); // plus récent d'abord
});

        foreach ($files as $file) {
            if ($file == '.' || $file == '..' || $file == 'index.php' || $file == 'Explorer.php' || $file == 'Explorer1.php' || $file == '.htaccess' || $file == basename(__FILE__)) continue;
            if (is_file($file)) {
                echo '<tr>';
                echo '<td><span class="icon">📄</span> <a href="'.htmlspecialchars($file).'">'.htmlspecialchars($file).'</a></td>';
		$size = filesize($file);
		if ($size >= 1024 * 1024 * 1024) {
		    echo '<td>'.round($size / (1024 * 1024 * 1024), 2).' Go</td>';
		} elseif ($size >= 1024 * 1024) {
		    echo '<td>'.round($size / (1024 * 1024), 2).' Mo</td>';
		} elseif ($size >= 1024) {
		    echo '<td>'.round($size / 1024, 2).' Ko</td>';
		} else {
		    echo '<td>'.$size.' Octets</td>';
		}
                echo '<td>'.date("d/m/Y H:i", filemtime($file)).'</td>';
                echo '</tr>';
            }
        }
        ?>
    </table>
</body>
</html>
