<!DOCTYPE html>
<html lang="fr">
<head>
   <meta charset="UTF-8">
   <title>Fichiers disponibles</title>
   <style>
        body {
            margin: 10px;
            padding: 0px;
            font-family: Arial, sans-serif;
            background: #252525;
            color: white;
        }
        h1 {
            margin: 0px;
            background: #02527F;
            color: #02E2FF;
            font-size: 2em;
            padding: 20px;
            text-shadow: 1px 1px 5px #000;
            border: 3px solid #01708F;   /* turquoise plus foncé */
            border-radius: 6px;          /* arrondi optionnel pour adoucir */
        }
        table {
            background: #959595;
            border-radius: 8px;
            width: 100%;
            margin-top: 0px;
            border-collapse: collapse;
            font-size: 1.35em;
            box-shadow: inset 0 0 5px rgba(0,0,0,0.7);
        }
        td {
            padding: 10px 15px;
            text-align: left;
            border-bottom: 1px solid #002;
            text-shadow: 0px 0px 1px #000;
            color: #226;
        }
        th {
            padding: 10px 15px;
            text-align: left;
            border-bottom: 1px solid #002;
            text-shadow: 0px 0px 1px #000;
            color: #133;
        }
        tr:hover {
            background: #B5B5B5;
        }
        a {
            color: #68176A;
            text-decoration: none;
        }
        .icon {
            margin-right: 8px;
            font-size: 32px;	/* ou 2em, 3rem, etc. */
/* 	    color: #48C0FC; */  /* par exemple */
        }
        .icon-folder {
            font-size: 48px; 	/* plus gros pour l'emoji dossier */
        }
        .upload-form {
            display: flex;		/* Permet l’alignement en colonnes */
            flex-wrap: wrap;		/* Garde la possibilité de passer en ligne multiple si écran étroit */
            justify-content: space-between;
            align-items: flex-start;
            height: auto;		/* Plus besoin de hauteur fixe */
            background: #349;
            font-size: 2em;
            padding: 5px;
            text-shadow: 1px 1px 5px #000;
            border-radius: 8px;
            border-bottom-left-radius: 0;
            border-bottom-right-radius: 0;
            margin: 0 0 15px 0;
            gap: 20px;			/* espace horizontal entre les colonnes */
        }
	.upload-column {
	    flex: 1;                     /* Chaque colonne prend la même largeur */
	    min-width: 200px;            /* Largeur minimale par colonne */
	}
	.upload-column label {
	    display: block;
	    margin-bottom: 8px;
	}
        #identifiant {
            box-sizing: border-box;
            font-size: 0.7em;
            padding: 5px;
            text-shadow: 1px 1px 2px #000;
            background: #0F203F;
            color: #AFA;
            border-radius: 4px;
        }
        label {
            background: #349;
            color: #acf;
            font-size: 0.8em;
            padding: 5px;
            text-shadow: 1px 1px 5px #000;
            display: block;
            margin-bottom: 8px;
        }
        input[type="text"] {
            background: #0F203F; 
            color: #AFA; 
            font-size: 0.6em; 
            text-shadow: 1px 1px 5px #000; 
            padding: 5px;
            border-radius: 4px;
            width: 100%;
            box-sizing: border-box;
        }
        input[type="file"] { 
            display: none;	/* Cacher le input file natif */
        }
        input[type="file"] {
            background: #352525; color: #FDD; font-size: 0.6em; text-shadow: 1px 1px 5px #000; padding: 5px;
        }
        input[type="file"]::file-selector-button {
            background-color: #0278c1;	/* Style du bouton "Choisir un fichier" */
            color: #224; 
            border: none; 
            padding: 8px 15px; 
            border-radius: 6px; 
            cursor: pointer; 
            font-weight: bold; 
            transition: background-color 0.3s ease;
        }
        input[type="file"]::file-selector-button:hover {
            background-color: #029ca0;
            color: #8f9;
        }
        .custom-file-label {
            background-color: #2060B0;	/* #2298E2 */
            color: #003;		/* #224	   */
            padding: 8px 5px;
            border-radius: 6px;
            cursor: pointer;
            font-weight: arial;
            display: inline-block;
            margin-right: 10px;
            text-shadow: 1px 1px 2px #000;
            transition: background-color 0.3s ease;
        }
        .custom-file-label:hover {
            box-border: 2px #2af;
            background-color: #114499;
            color: #2af;
        }
        #file-chosen {
            background: #354595;	/* Zone affichant le nom du fichier choisi */
            margin-left: 15px;
            font-style: italic;
            color: #37E;
            vertical-align: middle;
        }
        input[type="submit"] {
            background: #02DAFA;
            border: none;
            font-size: 0.7em;
            text-shadow: 1px 1px 5px #222;
            padding: 8px 15px;
            color: #003;
            border-radius: 5px;
            cursor: pointer;
            margin-left: 5px;
        }
        input[type="submit"]:hover {
            background: #00EEA0;
        }
    </style>
</head>
<body>



</body>
</html>

