<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Fichiers disponibles</title>
    <style>
        body {
	 font-family: Arial, sans-serif;
	 background: #252525;
	 color: white;
	 }

        h1 {
	 background: #02527F;
	 color: #02E2FF;
	 font-size: 2em;
	 padding: 20px;
	 text-shadow: 1px 1px 5px #000;
	 }

        table {
	 background: #959595;
	 border-radius: 8px;
	 width: 100%;
	 margin-top: 0px;
	 border-collapse: collapse;
	 font-size: 1.35em;
	 box-shadow: inset 0 0 5px rgba(0,0,0,0.7);
    	 }

        th, td {
	 padding: 10px 15px;
	 text-align: left;
	 border-bottom: 1px solid #002;
	 text-shadow: 0px 0px 2px #000;
	 }

        tr:hover {
	 background: #B5B5B5;
	 }

        a {
	 color: #972727;
	 text-decoration: none;
	 }

        .icon {
	 margin-right: 8px;
	 }

        .upload-form {
            background: #833;
            font-size: 2em;
            padding: 20px;
            text-shadow: 1px 1px 5px #000;
            border-radius: 8px;
            margin: 15px 0;
        }

        input[type="text"] {
            background: #352525; color: #AFA; font-size: 0.8em; text-shadow: 1px 1px 5px #000; padding: 5px;
        }

        input[type="file"] {
            background: #352525; color: #fDD; font-size: 0.8em; text-shadow: 1px 1px 5px #000; padding: 5px;
        }

        input[type="submit"] {
            background: #02E2FF; border: none; font-size: 0.8em; text-shadow: 1px 1px 5px #222; padding: 8px 15px;
            color: #003; border-radius: 5px; cursor: pointer; margin-left: 5px;
        }

        input[type="submit"]:hover { background: #00EEA0; }

    </style>

</head>
<body>
    <h1>Fichiers disponibles / 
        <a href="../" style="background: #02527F; color: #EFE8AA; text-shadow: 1px 1px 6px #000; padding: 10px;">
            Clic Ici Retour Reflecteur
        </a>
    </h1>

    <!-- Formulaire d'upload -->
    <div class="upload-form">
        <form action="" method="POST" enctype="multipart/form-data">
            <label for="identifiant">Identifiant :</label>
            <input type="text" name="identifiant" id="identifiant" required>

            <label for="fichier">Ajouter un fichier :</label>
            <input type="file" name="fichier" id="fichier" required>
            <input type="submit" name="envoyer" value="Téléverser">
        </form>

<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


//   **********  Gestion du Téléversement  *************

if (isset($_POST['envoyer']) && isset($_FILES['fichier'])) {
    $identifiant = trim($_POST['identifiant']);

    $utilisateurs = file(__DIR__ . '/../config/utilisateurs.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

/*    $utilisateurs = file('utilisateurs.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES); */

    if (in_array($identifiant, $utilisateurs)) {
        $nomFichier = basename($_FILES['fichier']['name']);
        $destination = __DIR__ . '/' . $nomFichier;

        if (move_uploaded_file($_FILES['fichier']['tmp_name'], $destination)) {
            echo "<p style='color: #1E1;'>Fichier '$nomFichier' Téléversé avec Succès.</p>";
        } else {
            echo "<p style='color: #E67;'>Erreur Lors du Téléversement.</p>";
        }
    } else {
        echo "<p style='color: #E67;'>Identifiant Non Reconnu, Upload Refusé.</p>";
    }
}
?>

    </div>

    <table>
        <tr style="background: #525252; color: #FFB878; font-size: 1.1em; text-shadow: 1px 1px 6px #000; padding: 10px;">
            <th>Nom du Fichier </th>
            <th>Taille </th>
            <th>Dernière Modification (UTC) </th>
        </tr>
        <?php
        $files = scandir(__DIR__);
        foreach ($files as $file) {
            if ($file == '.' || $file == '..' || $file == 'Explorer.php' || $file == basename(__FILE__)) continue;
            if (is_file($file)) {
                echo '<tr>';
                echo '<td><span class="icon">📄</span> <a href="'.htmlspecialchars($file).'">'.htmlspecialchars($file).'</a></td>';
                
                $size = filesize($file);
                if ($size >= 1024 * 1024 * 1024) {
                    echo '<td>'.round($size / (1024 * 1024 * 1024), 2).' Go</td>';
                } elseif ($size >= 1024 * 1024) {
                    echo '<td>'.round($size / (1024 * 1024), 2).' Mo</td>';
                } elseif ($size >= 1024) {
                    echo '<td>'.round($size / 1024, 2).' Ko</td>';
                } else {
                    echo '<td>'.$size.' o</td>';
                }

                echo '<td>'.date("d/m/Y H:i", filemtime($file)).'</td>';
                echo '</tr>';
            }
        }
        ?>
    </table>
</body>
</html>
