﻿<?php
/**
* Simple Chat v2.0.2 par Stephan Soller (corrigé)
* Source originale : [http://arkanis.de/projects/simple-chat/](http://arkanis.de/projects/simple-chat/)
*/

// Nom du fichier tampon de messages 
$messages_buffer_file = "messages.json";

// Nombre maximum de messages conservés
$messages_buffer_size = 1000;

// Activer ou non le fichier journal
$enable_chatlog = true;

/**
 * Envoi d’un nouveau message
 */

// Code Special pour la remise a zero   * * * * * * 
if (isset($_POST["content"]) && $_POST["content"] === "VA2VDCraz1964") {
   $buffer = fopen($messages_buffer_file, "w");
   flock($buffer, LOCK_EX);
   fwrite($buffer, "[]");  // vide le chat
   flock($buffer, LOCK_UN);
   fclose($buffer);
   exit();
}

// Code Special pour la remise a zero  Avec Log  * * * * * * 
if (isset($_POST["content"]) && $_POST["content"] === "VA2VDCraz1964log") {
   $buffer = fopen($messages_buffer_file, "w");
   flock($buffer, LOCK_EX);
   fwrite($buffer, "[]");  // vide le chat
   flock($buffer, LOCK_UN);
   fclose($buffer);

// * * * * *    Optionnel : Vide Aussi le Log   * * * * * * 
 if ($enable_chatlog && file_exists("chatlog.txt")) {
    file_put_contents("chatlog.txt", "");
   }
   exit();
}

// Code spécial pour effacer uniquement la dernière entrée du chat
if (isset($_POST["content"]) && $_POST["content"] === "LastEff") {
    if (file_exists($messages_buffer_file)) {
        // Lecture et décodage json
        $messages = json_decode(file_get_contents($messages_buffer_file), true);
        // Suppression du dernier message s'il existe
        if (!empty($messages)) {
            array_pop($messages);
            file_put_contents($messages_buffer_file, json_encode($messages, JSON_PRETTY_PRINT));
        }
    }
    exit();
}

if (isset($_POST["content"]) && isset($_POST["name"])) {
    // Crée le fichier tampon si inexistant
    if (!file_exists($messages_buffer_file)) {
        touch($messages_buffer_file);
    }

    // Ouvrir et verrouiller le fichier JSON en lecture/écriture
    $buffer = fopen($messages_buffer_file, "c+b");
    flock($buffer, LOCK_EX);
    $buffer_data = stream_get_contents($buffer);

    // Charger la mémoire tampon (ou tableau vide si fichier vide)
    $messages = $buffer_data ? json_decode($buffer_data, true) : [];

    // Calculer l’ID du prochain message
    $next_id = (count($messages) > 0) 
        ? $messages[count($messages) - 1]["id"] + 1 
        : 0;

    // Nettoyer et limiter les entrées utilisateur
    $name = trim($_POST["name"]);
    if ($name === "") {
        $name = "Anonymous";
    }
    $name = substr($name, 0, 32);

    $content = $_POST["content"];
    $content = wordwrap($content, 80, "\n", true);
    $content = substr($content, 0, 500);

    // Ajouter le message dans la mémoire tampon
    $messages[] = [
        "id"      => $next_id,
        "time"    => time(),
        "name"    => $name,
        "content" => $content
    ];

    // Supprimer les messages trop anciens
    if (count($messages) > $messages_buffer_size) {
        $messages = array_slice(
            $messages,
            count($messages) - $messages_buffer_size
        );
    }

    // Réécrire le fichier JSON
    ftruncate($buffer, 0);
    rewind($buffer);
    fwrite($buffer, json_encode($messages));
    flock($buffer, LOCK_UN);
    fclose($buffer);

    // Sauvegarde optionnelle dans le fichier log
    if ($enable_chatlog) {
        $log_entry = date("Y-m-d H:i:s") . "\t"
            . $next_id . "\t"
            . strtr($name, "\t", " ") . "\t"
            . strtr($content, "\t", " ") . "\n";
        file_put_contents("chatlog.txt", $log_entry, FILE_APPEND);
    }

    // Fin après enregistrement
    exit();
}

/**
 * Récupération des messages (AJAX polling côté client)
 */
if (isset($_GET["fetch"])) {
    if (file_exists($messages_buffer_file)) {
        echo file_get_contents($messages_buffer_file);
    } else {
        echo "[]"; // renvoyer un tableau JSON vide si pas de fichier
    }
    exit();
}
?>
