<?php
// Inclure config seulement si le fichier existe
if (file_exists("config/config.php")) {
    include "config/config.php";
}
include "include/tools.php";

// Fonction à définir si elle n’existe pas déjà
if (!function_exists('createConfigLines')) {
    // Exemple basique, adapter selon besoins
    function createConfigLines() {
        $lines = "";
        foreach ($_GET as $key => $value) {
            // Exclure cmd et valeurs non constantes
            if (in_array($key, ['cmd'])) continue;
            if (is_string($value)) {
                $escapedValue = addslashes($value);
                $lines .= "define('$key', '$escapedValue');\n";
            } elseif (is_numeric($value)) {
                $lines .= "define('$key', $value);\n";
            } elseif (is_bool($value)) {
                $lines .= "define('$key', ".($value ? 'true' : 'false').");\n";
            }
        }
        return $lines;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>YSFReflector-Tableau De Bord De DG9VH - Setup VA2VDC </title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
</head>
<body STYLE="BACKGROUND-COLOR: #272727;">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark static-top">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">YSF-Dashboard by DG9VH Setup Process</a>
  </div>
</nav>

<?php
if (isset($_GET['cmd']) && $_GET['cmd'] == "writeconfig") {
    if (!file_exists('./config')) {
        if (!mkdir('./config', 0777, true)) {
            echo '<div class="alert alert-danger" role="alert">You forgot to give write permissions to your webserver user!</div>';
        }
    }
    $configfile = fopen("config/config.php", 'w');
    fwrite($configfile, "<?php\n");
    fwrite($configfile, "# This is an auto-generated config file!\n");
    fwrite($configfile, "# Be careful, when manually editing this!\n\n");
    fwrite($configfile, "date_default_timezone_set('UTC');\n");
    fwrite($configfile, createConfigLines());
    fwrite($configfile, "?>\n");
    fclose($configfile);
    echo '<div class="alert alert-success" role="alert">Your config file is written in config/config.php, please remove setup.php for security reasons!</div>';
    echo '<p><a href="index.php">Your dashboard is now available.</a></p>';
} else {
?>

<div class="container text-center" STYLE="BACKGROUND-COLOR: #272727;">
  <h2 style="color: #2277FE;">YSFReflector-Dashboard by DG9VH Setup Process  DL</h2>
  <h4 style="color: #22FE33;"> VEUILLER REMPLIR LES INFORMATIONS NECESSAIRES CI-DESSOUS </h4>
</div>

<form id="config" action="setup.php" method="get" STYLE="BACKGROUND-COLOR: #272727;">
  <input type="hidden" name="cmd" value="writeconfig">

  <div class="container" STYLE="BACKGROUND-COLOR: #274767; border-radius: 20px; padding: 5px;">
    <div class="card" STYLE="BACKGROUND-COLOR: #6787A7; border-radius: 15px; padding: 3px;">
      <div class="card-header"><h2>YSFReflector Configuration</h2></div>
      <div class="card-body">

        <div class="card-text input-group mb-3">
          <span class="input-group-text" style="background-color: #274767; color: #FFE8AA; width: 300px;">Path to YSFReflector-logfile</span>
          <input type="text" value="<?php echo defined('YSFREFLECTORLOGPATH') ? constant('YSFREFLECTORLOGPATH') : ''; ?>" name="YSFREFLECTORLOGPATH" class="form-control" placeholder="/var/www/html/log/YSFReflector/" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="background-color: #274767; color: #FFE8AA; width: 300px;">Logfile-prefix</span>
          <input type="text" value="<?php echo defined('YSFREFLECTORLOGPREFIX') ? constant('YSFREFLECTORLOGPREFIX') : ''; ?>" name="YSFREFLECTORLOGPREFIX" class="form-control" placeholder="YSFReflector" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="background-color: #274767; color: #FFE8AA; width: 300px;">Path to YSFReflector.ini</span>
          <input type="text" value="<?php echo defined('YSFREFLECTORINIPATH') ? constant('YSFREFLECTORINIPATH') : ''; ?>" name="YSFREFLECTORINIPATH" class="form-control" placeholder="/etc/YSFReflector/" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="background-color: #274767; color: #FFE8AA; width: 300px;">YSFReflector.ini-filename</span>
          <input type="text" value="<?php echo defined('YSFREFLECTORINIFILENAME') ? constant('YSFREFLECTORINIFILENAME') : ''; ?>" name="YSFREFLECTORINIFILENAME" class="form-control" placeholder="YSFReflector.ini" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="background-color: #274767; color: #FFE8AA; width: 300px;">Path to YSFReflector-executable</span>
          <input type="text" value="<?php echo defined('YSFREFLECTORPATH') ? constant('YSFREFLECTORPATH') : ''; ?>" name="YSFREFLECTORPATH" class="form-control" placeholder="/usr/local/bin/" required>
        </div>
      </div>
    </div>
  </div>

  <div class="container" STYLE="BACKGROUND-COLOR: #675727; border-radius: 20px; padding: 5px;">
    <div class="card" STYLE="BACKGROUND-COLOR: #B78757; border-radius: 15px; padding: 3px;">
     <div class="card-header"><h2>Global Configuration</h2></div>
      <div class="card-body">



<div class="input-group mb-3">
  <span class="input-group-text" style="width: 300px">Timezone</span>
  <select name="TIMEZONE" class="form-control">
   <?php
    // Option par défaut affichée en premier et sélectionnée
    echo '<option value="America/Montreal" selected="selected">Montreal Q.C.</option>';

    // Fonction pour générer le reste des options sans 'America/Toronto'
    function get_tz_options($selectedzone) {
      $all = timezone_identifiers_list();
      $i = 0;
      $zonen = [];
      foreach($all as $zone) {
        if ($zone == 'America/Toronto') continue;  // Exclure déjà affichée

        $parts = explode('/', $zone);
        $zonen[$i]['continent'] = $parts[0] ?? '';
        $zonen[$i]['city'] = $parts[1] ?? '';
        $zonen[$i]['subcity'] = $parts[2] ?? '';
        $i++;
      }
      // Trier par continent, puis ville (tri alphabétique)
      usort($zonen, function($a, $b) {
        if ($a['continent'] === $b['continent']) {
          return strcmp($a['city'], $b['city']);
        }
        return strcmp($a['continent'], $b['continent']);
      });

      $structure = '';
      $selectcontinent = '';
      foreach($zonen as $zone) {
        extract($zone);
        if ($continent != $selectcontinent) {
          if ($selectcontinent !== '') {
            $structure .= '</optgroup>';
          }
          $structure .= '<optgroup label="'.htmlspecialchars($continent).'">';
          $selectcontinent = $continent;
        }
        if ($city != '') {
          $displayCity = str_replace('_',' ', $city);
          if ($subcity != '') {
            $displayCity .= '/'.str_replace('_', ' ', $subcity);
          }
          $value = $continent . '/' . $city;
          if ($subcity != '') {
            $value .= '/' . $subcity;
          }
          $structure .= "<option value=\"" . htmlspecialchars($value) . "\">" . htmlspecialchars($displayCity) . "</option>";
        } else {
          // Cas rare où il n'y a pas de city, afficher seulement le continent
          $structure .= "<option value=\"" . htmlspecialchars($continent) . "\">" . htmlspecialchars($continent) . "</option>";
        }
      }
      $structure .= '</optgroup>';
      return $structure;
    }

    // Afficher les options restantes sans sélection (car Toronto est déjà sélectionné)
    echo get_tz_options('');
    ?>
  </select>
</div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">URL to Logo Jour</span>
          <input type="text" value="<?php echo defined('LOGO') ? constant('LOGO') : ''; ?>" name="LOGO" class="form-control" placeholder="images/Logo-AntBig0.png">
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">URL to Logo Nuit</span>
          <input type="text" value="<?php echo defined('LOGOn') ? constant('LOGOn') : ''; ?>" name="LOGOn" class="form-control" placeholder="images/Logo-AntBig4.png">
        </div>


        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Refresh page after in seconds</span>
          <input type="text" value="<?php echo defined('REFRESHAFTER') ? constant('REFRESHAFTER') : '60'; ?>" name="REFRESHAFTER" class="form-control" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Show progressbars</span>
          <input type="checkbox" name="SHOWPROGRESSBARS" <?php if (defined('SHOWPROGRESSBARS') && constant('SHOWPROGRESSBARS')) echo 'checked'; ?>>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Show historic heard logs, in days</span>
          <input type="text" value="<?php echo defined('SHOWOLDMHEARD') ? constant('SHOWOLDMHEARD') : '120'; ?>" name="SHOWOLDMHEARD" class="form-control" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Enable CPU-temperature-warning</span>
          <input type="checkbox" name="TEMPERATUREALERT" <?php if (defined('TEMPERATUREALERT') && constant('TEMPERATUREALERT')) echo 'checked'; ?>>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Warning temperature</span>
          <input type="text" value="<?php echo defined('TEMPERATUREHIGHLEVEL') ? constant('TEMPERATUREHIGHLEVEL') : '59'; ?>" name="TEMPERATUREHIGHLEVEL" class="form-control" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Show link to QRZ.com on Callsigns</span>
          <input type="checkbox" name="SHOWQRZ" <?php if (defined('SHOWQRZ') && constant('SHOWQRZ')) echo 'checked'; ?>>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Anonymize Callsigns (no function if QRZ.com enabled)</span>
          <input type="checkbox" name="GDPR" <?php if (defined('GDPR') && constant('GDPR')) echo 'checked'; ?>>
        </div>

        <div class="input-group">
          <button class="btn btn-primary" type="submit" form="config">Save configuration</button>
        </div>
       </div>
      </div>
    </div>
  </div>
</form>

<?php
}
?>

<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
</body>
</html>
