<?php
session_start();
ob_start();
include_once __DIR__ ."/include/CouleurMatch.php";

// Lecture du fichier colors.json (si présent)
if(file_exists($jsonFile)) {
    $savedColors = json_decode(file_get_contents($jsonFile), true);
} else {
    $savedColors = [];
}

// Priorité session > fichier > valeurs par défaut
$selectedBgColor0 = $_SESSION['bgColor0'] ?? ($savedColors['bgColor0'] ?? '#030304');
$selectedBgColor2 = $_SESSION['bgColor2'] ?? ($savedColors['bgColor2'] ?? '#333434');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Récupérer les valeurs du formulaire
    $bg0 = $_POST['bg0'] ?? '#030304';
    $bg2 = $_POST['bg2'] ?? '#333434';

    // Valider que les couleurs sont dans les options autorisées
    if (array_key_exists($bg0, $bgColor0Options) && array_key_exists($bg2, $bgColor2Options)) {
        // Stocker en session pour cet utilisateur uniquement
        $_SESSION['bgColor0'] = $bg0;
        $_SESSION['bgColor2'] = $bg2;

        // Mettre à jour les couleurs sélectionnées pour affichage immédiat  ********************************* Couleur User Only ***********************
        $selectedBgColor0 = $bg0;
        $selectedBgColor2 = $bg2;

        // Rediriger vers index.php pour éviter la resoumission du formulaire
        header("Location: index.php");
        exit();
    } else {
        echo "<p style='color:red;'>Valeurs invalides sélectionnées.</p>";
    }
}

ob_end_flush();
?>


<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />

    <title>Configuration des couleurs</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" crossorigin="anonymous">
</head>
<body class="p-3" style="background-color: #3585B5; font-size: 1.8em;">

    <h1>Personnalisation des couleurs</h1>
    <form method="post" action="" class="w-50">
        <div class="form-group">
            <label for="bg0">Choisissez couleur BG0 :</label>
            <select name="bg0" id="bg0" class="form-control" style="background-color: #CCCCCC; font-size: 1.2em;">
                <?php foreach ($bgColor0Options as $color => $label): ?>
                    <option value="<?= htmlspecialchars($color) ?>" <?= ($selectedBgColor0 === $color) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($label) ?> (<?= htmlspecialchars($color) ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <label for="bg2">Choisissez couleur BG2 :</label>
            <select name="bg2" id="bg2" class="form-control" style="background-color: #CCCCCC; font-size: 1.2em;">
                <?php foreach ($bgColor2Options as $color => $label): ?>
                    <option value="<?= htmlspecialchars($color) ?>" <?= ($selectedBgColor2 === $color) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($label) ?> (<?= htmlspecialchars($color) ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <button type="submit" class="btn btn-primary">Appliquer</button>
    </form>
</body>
</html>
