<?php
// Début de index.php
session_start();

// Supposons que tu charges les couleurs depuis session ou valeurs par défaut
$defaultColors = ['bgColor0' => '#333434', 'bgColor2' => '#532363'];
$selectedBgColor0 = $_SESSION['bgColor0'] ?? $defaultColors['bgColor0'];
$selectedBgColor2 = $_SESSION['bgColor2'] ?? $defaultColors['bgColor2'];

// Traitement du formulaire de couleurs
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bgColor0'], $_POST['bgColor2'])) {
    $bg0 = $_POST['bgColor0'];
    $bg2 = $_POST['bgColor2'];
    if (preg_match('/^#[0-9A-Fa-f]{6}$/', $bg0) && preg_match('/^#[0-9A-Fa-f]{6}$/', $bg2)) {
        $_SESSION['bgColor0'] = $bg0;
        $_SESSION['bgColor2'] = $bg2;
        $selectedBgColor0 = $bg0;
        $selectedBgColor2 = $bg2;
        $message = "Couleurs mises à jour avec succès.";
    } else {
        $message = "Valeurs de couleur invalides.";
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <title>Personnalisation des couleurs - Exemple</title>

    <!-- Inclusion fichiers CSS dynamiques et statiques -->
    <link rel="stylesheet" href="/css/custom.css.php?v=<?=filemtime(__DIR__.'/css/custom.css.php')?>">
    <link rel="stylesheet" href="/css/custom.css">

    <!-- Bootstrap CSS (si tu l utilises) -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
</head>
<body style="background-color: #848484;"> 

<h1 style="color: var(--BGround-color0);"> TEST DE BACKGROUND <h1>
    <div class="container pt-4">
        <?php if (isset($message)): ?>
            <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>

        <!-- Bouton pour afficher le formulaire -->
        <button id="btnShowColorsForm" class="btn btn-primary mb-3" type="button">
            Modifier les couleurs
        </button>

        <!-- Formulaire caché par défaut -->
        <form id="colorsForm" method="post" action="" style="display: none; max-width: 400px;">
            <div class="form-group">
                <label for="bgColor0">Couleur BG0 :</label>
                <input type="color" id="bgColor0" name="bgColor0" class="form-control" value="<?= htmlspecialchars($selectedBgColor0) ?>" required>
            </div>
            <div class="form-group">
                <label for="bgColor2">Couleur BG2 :</label>
                <input type="color" id="bgColor2" name="bgColor2" class="form-control" value="<?= htmlspecialchars($selectedBgColor2) ?>" required>
            </div>
            <button type="submit" class="btn btn-success">Enregistrer</button>
        </form>

        <!-- Le reste de ton contenu de page ici -->






















    </div>

    <!-- Script pour afficher le formulaire -->
    <script>
        document.getElementById('btnShowColorsForm').addEventListener('click', function() {
            var form = document.getElementById('colorsForm');
            if (form.style.display === 'none' || form.style.display === '') {
                form.style.display = 'block';   // Affiche le formulaire
                this.style.display = 'none';     // Cache le bouton après clic
            }
        });
    </script>
</body>
</html>

