window.addEventListener('DOMContentLoaded', function () {
  // Le canvas image Clic  *********************************
// <canvas id="canvas" width="400" height="400"></canvas>
// <img id="image" src="/../images/Logo-AntBig0.png" style="display:none;">


const canvas = document.getElementById('canvas');
const ctx = canvas.getContext('2d');
const image = document.getElementById('image');

// Fonction pour dessiner l'image sur le canvas
function showImage() {
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  ctx.drawImage(image, 0, 0, canvas.width, canvas.height);
}

// Affichage de l'image avec l'événement load
image.onload = showImage;

// Fonction pour faire disparaître l'image
function hideImage() {
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  // Lancer le timer pour la remettre
  setTimeout(showImage, 2000); // 2000 ms = 2 secondes
}

// Écoute des événements tactiles et clics
canvas.addEventListener('touchstart', hideImage, false);
canvas.addEventListener('mousedown', hideImage, false);

// Dessin initial lors du chargement
if (image.complete) showImage();

});