﻿<?php
// Inclure config seulement si le fichier existe
if (file_exists("config/Sconfig.php")) {
    include "config/Sconfig.php";
}
 include "include/tools.php";

// Fonction à définir si elle n’existe pas déjà
if (!function_exists('createConfigLines')) {
    // Exemple basique, adapter selon besoins
    function createConfigLines() {
        $lines = "";
        foreach ($_GET as $key => $value) {
            // Exclure cmd et valeurs non constantes
            if (in_array($key, ['cmd'])) continue;
            if (is_string($value)) {
                $escapedValue = addslashes($value);
                $lines .= "define('$key', '$escapedValue');\n";
            } elseif (is_numeric($value)) {
                $lines .= "define('$key', $value);\n";
            } elseif (is_bool($value)) {
                $lines .= "define('$key', ".($value ? 'true' : 'false').");\n";
            }
        }
        return $lines;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>YSFReflector-Chat VA2VDC </title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark static-top">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">YSF-Chat</a>
  </div>
</nav>

<?php
if (isset($_GET['cmd']) && $_GET['cmd'] == "writeconfig") {
    if (!file_exists('./config')) {
        if (!mkdir('./config', 0777, true)) {
            echo '<div class="alert alert-danger" role="alert">You forgot to give write permissions to your webserver user!</div>';
        }
    }
    $configfile = fopen("config/Sconfig.php", 'w');
    fwrite($configfile, "<?php\n");
    fwrite($configfile, "# This is an auto-generated Sconfig file!\n");
    fwrite($configfile, "# Be careful, when manually editing this!\n\n");
    fwrite($configfile, "# SMessages_readed.txt add to index.php and SChatD.php  when manually editing this!\n\n");
    fwrite($configfile, createConfigLines());
    fwrite($configfile, "# Setup from VA2VDC Daniel  2025-09-09 !\n\n");
    fwrite($configfile, "?>\n");
    fclose($configfile);
    echo '<div class="alert alert-success" role="alert">Your config file is written in config/config.php, please remove setup.php for security reasons!</div>';
    echo '<p><a href="chatme.php">Your Chat is now available.</a></p>';
} else {
?>

<div class="container text-center">
  <h2>YSF-Chat Setup Process  DL</h2>
  <h4>Please fill in the necessary information below</h4>
</div>

<form id="config" action="SChatSetup.php" method="get">
  <input type="hidden" name="cmd" value="writeconfig">

  <div class="container">
    <div class="card">
      <div class="card-header"><h2>YSF Chat Configuration</h2></div>
      <div class="card-body">

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Titre Du Chat</span>
          <input type="text" value="<?php echo defined('TITRE_CHAT') ? constant('TITRE_CHAT') : ''; ?>" name="TITRE_CHAT" class="form-control" placeholder="YSF Chat Radio Amateur" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Rafrechie l ecran tout les  x Secondes </span>
          <input type="text" value="<?php echo defined('REFRESH_AFTER') ? constant('REFRESH_AFTER') : ''; ?>" name="REFRESH_AFTER" class="form-control" placeholder="60" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Fichier Log Historique </span>
          <input type="text" value="<?php echo defined('FICHIER_LOG_SAFETY') ? constant('FICHIER_LOG_SAFETY') : ''; ?>" name="FICHIER_LOG_SAFETY" class="form-control" placeholder="SChatlog.log" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Fichier Base de Donnee Messages </span>
          <input type="text" value="<?php echo defined('FICHIER_MESSAGE_TEXT') ? constant('FICHIER_MESSAGE_TEXT') : ''; ?>" name="FICHIER_MESSAGE_TEXT" class="form-control" placeholder="SMessages.json" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Snas Indicatif ou Sans Nom  </span>
          <input type="text" value="<?php echo defined('ANONYMOUS_JACK_NAME') ? constant('ANONYMOUS_JACK_NAME') : ''; ?>" name="ANONYMOUS_JACK_NAME" class="form-control" placeholder="Anonymous" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Remise a zero sans le log</span>
          <input type="text" value="<?php echo defined('PASSWORD_ALL_CLEAR') ? constant('PASSWORD_ALL_CLEAR') : ''; ?>" name="PASSWORD_ALL_CLEAR" class="form-control" placeholder="Raz1234" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">Remise a zero avec log </span>
          <input type="text" value="<?php echo defined('PASSWORD_ALL_LOG') ? constant('PASSWORD_ALL_LOG') : ''; ?>" name="PASSWORD_ALL_LOG" class="form-control" placeholder="Raz1234log" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">efface le Dernier </span>
          <input type="text" value="<?php echo defined('EFFACE_LAST') ? constant('EFFACE_LAST') : ''; ?>" name="EFFACE_LAST" class="form-control" placeholder="LastEff" required>
        </div>

        <div class="input-group mb-3">
          <span class="input-group-text" style="width: 300px">deja Vu Ok </span>
          <input type="text" value="<?php echo defined('CHECK_OK') ? constant('CHECK_OK') : ''; ?>" name="CHECK_OK" class="form-control" placeholder="VuOk" required>
        </div>

        <div class="input-group">
          <button class="btn btn-primary" type="submit" form="config"> Sauvegarde La configuration Chat de Base </button>
        </div>

      </div>
    </div>
  </div>

</form>

<?php
}
?>

<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
</body>
</html>
