
<!DOCTYPE html>
<html lang="fr">
<head>

  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description" content="Night Chat">
  <meta name="author" content="VA2VDC">

  <meta http-equiv="refresh" content="120">
   <!-- So refresh works every time -->
  <meta http-equiv="expires" content="0">

  <title>Night Chat</title>

  <!-- Bootstrap core CSS -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
  
  <!-- Bootstrap core JavaScript -->
  <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>

  <!-- Inclure le script de la librairie emoji-picker-element -->
   <!-- script type="module" src="https://cdn.jsdelivr.net/npm/emoji-picker-element@^1/index.js"></script --> 
  <script type="module" src="js/index.js"></script> 

   <!-- link rel="stylesheet" href="css/custom.css" --> <!-- Ton fichier -->

  <style>
    /* copie-colle les styles CSS du mini chat dark mode ici */
    body {
      font-family: Arial, sans-serif;
      margin: 0px auto;
      max-width: 100%;
      background-color: #101010;
      color: #f1f1f1;
      padding: 0;
     }

   .container {
     display: flex; /* active la mode flexbox  */
     gap: 3% /* espace entre les div */
     width: 50%;
    }

   .box {
    flex: 1 1 100%; /* prend env. 45% de la largeur, flexible */
    background-color: #272727;
    margin: 3px auto;
      padding: 10px;
      box-sizing: border-box;
      border-radius: 15px;
      color: #FFFFFF;
    max-height: 750px;
      overflow-y: auto;
      box-shadow: inset 0 0 5px rgba(0,0,0,0.7);
   }

 .navbar {
    display: flex;
    margin: 0px auto;
    height: 30px;
    padding: 0 0;
    gap: 0px;
    flex-wrap: wrap;
   }

  .navbar > .col {
   margin: 0px auto;
   flex: 1 1 100%;
   box-sizing: border-box; /*  evite les debordements   */
  }


   .boz {
    flex: 1 1 50%; /* prend env. 45% de la largeur, flexible */
    background-color: #274F6F;
    margin: 0px auto;
    align-items:left;

    padding: 5px;
    box-sizing: border-box;
   }

    #chat-box {
      margin: 0px;
      border-radius: 15px;
      border: 1px solid #333;
      background: #052737;
      text-align: left;
      color: #FFFFFF; 
      height: 240px; /*  500 normal    300 telephone  */
      max-width: 100%;
      overflow-y: auto;
      padding: 10px;
      border-radius: 6px;
      box-shadow: inset 0 0 5px rgba(0,0,0,0.7);
    }
    .msg {
      margin: 4px 8px 4px 0;
      padding: 10px;
      border-radius: 20px;
      background: #171717;
      color: orange;
      text-align:left;
      font-size: 0.8em;
    }

    .msg strong {
      color: #4dd0f1;
      font-size: 1.em;
      display: inline-block;
      text-align: left;
    }

    .time {
      font-size: 0.8em;
      color: #ada;
    }

    form {
      margin-top: 8px;
      display: flex;
      max-width: 100%;
      background: #0a0a0a;
      gap: 5px;
      align-items:center;
    }

    input[type=text] {
      flex: 1;
      padding: 8px;
      border: 1px solid #555;
      border-radius: 4px;
      background: #1c1c1c;
      color: #f1f1f1;
      max-width: 100%;
    }

    input[type=text]::placeholder {
      color: #aaa;
    }

    #name {
      max-width: 22%; /* champ pseudo plus cout */
    }

    #content {
    flex: 1; /* Le champ message prend le rest de la largeur  */
    }


    button {
      padding: 8px 14px;
      border: none;
      border-radius: 4px;
      background: #00B7A7;
      color: #111;
      font-weight: bold;
      cursor: pointer;
      transition: background 0.3s;
    }

    button:hover {
      background: #50DCD6;
    }


    btEnvoie {
      padding: 8px 14px;
      border: none;
      border-radius: 4px;
      background: #00B7A7;
      color: #111;
      font-weight: bold;
      cursor: pointer;
      transition: background 0.3s;
    }

    btEnvoie:hover {
      background: #50DCD6;
    }




    buttonMJ {
      padding: 8px 14px;
      border: none;
      border-radius: 4px;
      background: #0097C7;
      color: #111;
      font-weight: bold;
      cursor: pointer;
      transition: background 0.3s;
    }

    buttonMJ:hover {
      background: #50BCF6;
    }


   emoji-picker {
     display: none;
     position: fixed;
     min-width: 100px;
     max-width: 75vw;
     max-height: 55vh;
     overflow-y: auto;
     background: #242424;
     box-shadow: 0 2px 16px rgba(0,0,0,0.6);
     z-index: 9999;
   }
    h2 {
      text-align: center;
      background-color: #072F4F;           
      color: #00bcd4;
      padding: 15px;
     border-radius: 15px;
    }
  </style>

</head>
<body class="navbar" style="background-color: #131313;">

  <!-- Page Content  -- Col --     -----------------------------    Chat Box  ------------------  -->
  <div class="box"> <!--     -------  Box Chat  -------   -->
   <h2> Night 🌙 Chat Info Bulle </h2>
   <div id="chat-box"></div>
    <form id="chat-form">
     <!--      --------  --------  Formulaire et script JS ----------   ----------    -->
     <input type="text" id="name" placeholder="Votre pseudo" maxlength="32">

     <button type="button" id="emoji-button" style="font-size:0.8em;">Emoji</button>

     <input type="text" id="content" placeholder="Votre message..." maxlength="500" required>

     <button type="submit" id="btEnvoie"> Envoyer</button>


     <!--    --------    Composant emoji-picker caché au départ    absolute   relative  fixed  sticky     ------------       -->
     <emoji-picker style="position:fixed; display:none; z-index:1000;"></emoji-picker>

    <script>
    // Ton code JavaScript pour envoyer/recevoir les messages vers/depuis chat.php

    const chatBox = document.getElementById('chat-box');
    const form = document.getElementById('chat-form');
    const nameInput = document.getElementById('name');
    const contentInput = document.getElementById('content');

    // Fonction pour afficher les messages
    function renderMessages(messages) {
      chatBox.innerHTML = "";
      messages.forEach((msg, idx) => {
        const div = document.createElement('div');
        div.className = "msg";
        const time = new Date(msg.time * 1000).toLocaleString('fr-FR', {
        
	year: 'numeric',  month: '2-digit', day: '2-digit',
	hour: '2-digit', minute: '2-digit', second: '2-digit'
	});
	div.innerHTML = `<strong>#${idx +1} - </strong><span class="time">[${time}]</span><strong> - ${escapeHtml(msg.name)}</strong><br>
	         ${escapeHtml(msg.content)}`;
        chatBox.appendChild(div);
      });
      chatBox.scrollTop = chatBox.scrollHeight;
    }

    // Protection XSS simple
    function escapeHtml(text) {
      const div = document.createElement("div");
      div.innerText = text;
      return div.innerHTML;
    }

    // Charger les messages périodiquement
    async function fetchMessages() {
      try {
        const res = await fetch('InfoD.php?fetch=1&_t=' + Date.now());
        const messages = await res.json();
        renderMessages(messages);
      } catch (e) {
        console.error("Erreur de fetch:", e);
      }
    }

    setInterval(fetchMessages, 10000); //  ------ toutes les ----- 5 secondes  ------------------
    fetchMessages(); // premier chargement immédiat

    // Envoi de message
    form.addEventListener('submit', async (e) => {
      e.preventDefault();
      const formData = new FormData();
      formData.append("name", nameInput.value);
      formData.append("content", contentInput.value);

      try {
        await fetch("InfoD.php", { method: "POST", body: formData });
        contentInput.value = "";
        fetchMessages(); // recharge instantanément
      } catch (err) {
        alert("Erreur d'envoi du message !");
      }
    });
    </script>





       <script>
	  const button = document.getElementById('emoji-button');
	  const picker = document.querySelector('emoji-picker');
	  const input = document.getElementById('content');

	  // Afficher/cacher le sélecteur emoji au clic
	  button.addEventListener('click', () => {
	    if (picker.style.display === 'none') {
	      picker.style.display = 'block';

	  //pour center dans la chat-box
	   const chatBox = document.getElementById('chat-box');
	   const chatRect = chatBox.getBoundingClientRect();



	  // On choisit des dimentions max ( pour eviter le debordement)
	  picker.style.position = "fixed";
	  picker.style.top = (chatRect.top + window.scrollY + (chatRect.height /2.1) - (picker.offsetHeight / 2)) + "px";
	  picker.style.left = (chatRect.top + window.scrollX + (chatRect.width /1.15) - (picker.offsetWidth / 1)) + "px";
	  picker.style.zIndex = "9999";
	    } else {
	      picker.style.display = 'none';
	    }
	  });




          // Positionner le picker au-dessous du bouton
//	      const rect = button.getBoundingClientRect();
//	      picker.style.top = (rect.bottom + window.scrollY) + 'px';
//	      picker.style.left = (rect.left + window.scrollX) + 'px';





	  // Empecher que le picker soit hors ecran
//	     setTimeout(() => {
//	       const pickerRect = picker.getBoundingClientRect();
//	       const winWidth = windows.innerWidth;
//	       const winHeight = window.innerHeight;

//	  // Ajuste la gauche si le picker depasse du cote droit
//	    if (pickerRect.right > winWidth) {
//	      picker.style.left = (winWidth - pickerRect.width -10) + 'px';
//	   }
//	  // Ajuste le haut si le picker depasse en bas
//	    if (pickerRect.bottom > winHeight) {
//	     picker.style.top = (winHeight - pickerRect.height -10) + 'px';
//	   }
//        }, 10);  // Attend que le DOM affiche le picker 

//	    } else {
//	      picker.style.display = 'none';
//	    }
//	  });




	  // Quand un emoji est choisi, l'insérer dans l'input et cacher le picker
	  picker.addEventListener('emoji-click', event => {
	    const emoji = event.detail.unicode;
	    input.value += emoji;
	    input.focus();
	    picker.style.display = 'none';
	  });

	  // Optionnel : clique à l’extérieur pour fermer le picker
	  document.addEventListener('click', e => {
	    if (!picker.contains(e.target) && e.target !== button) {
	      picker.style.display = 'none';
	    }
	  });
    </script>

 </form>
</body>
</html>
