
    // Ton code JavaScript pour envoyer/recevoir les messages vers/depuis chat.php

    const chatBox = document.getElementById('chat-box');
    const form = document.getElementById('chat-form');
    const nameInput = document.getElementById('name');
    const contentInput = document.getElementById('content');

    // Fonction pour afficher les messages
    function renderMessages(messages) {
      chatBox.innerHTML = "";
      messages.forEach((msg, idx) => {
        const div = document.createElement('div');
        div.className = "msg";
        const time = new Date(msg.time * 1000).toLocaleString('fr-FR', {
        
	year: 'numeric',  month: '2-digit', day: '2-digit',
	hour: '2-digit', minute: '2-digit', second: '2-digit'
	});
	div.innerHTML = `<strong>#${idx +1} - </strong><span class="time">[${time}]</span><strong> - ${escapeHtml(msg.name)}</strong><br>
	         ${escapeHtml(msg.content)}`;
        chatBox.appendChild(div);
      });
      chatBox.scrollTop = chatBox.scrollHeight;
    }

    // Protection XSS simple
    function escapeHtml(text) {
      const div = document.createElement("div");
      div.innerText = text;
      return div.innerHTML;
    }

    // Charger les messages périodiquement
    async function fetchMessages() {
      try {
        const res = await fetch('InfoD.php?fetch=1&_t=' + Date.now());
        const messages = await res.json();
        renderMessages(messages);
      } catch (e) {
        console.error("Erreur de fetch:", e);
      }
    }

    setInterval(fetchMessages, 10000); //  ------ toutes les ----- 5 secondes  ------------------
    fetchMessages(); // premier chargement immédiat

    // Envoi de message
    form.addEventListener('submit', async (e) => {
      e.preventDefault();
      const formData = new FormData();
      formData.append("name", nameInput.value);
      formData.append("content", contentInput.value);

      try {
        await fetch("InfoD.php", { method: "POST", body: formData });
        contentInput.value = "";
        fetchMessages(); // recharge instantanément
      } catch (err) {
        alert("Erreur d'envoi du message !");
      }
    });




	  const button = document.getElementById('emoji-button');
	  const picker = document.querySelector('emoji-picker');
	  const input = document.getElementById('content');

	  // Afficher/cacher le sélecteur emoji au clic
	  button.addEventListener('click', () => {
	    if (picker.style.display === 'none') {
	      picker.style.display = 'block';

	  //pour center dans la chat-box
	   const chatBox = document.getElementById('chat-box');
	   const chatRect = chatBox.getBoundingClientRect();



	  // On choisit des dimentions max ( pour eviter le debordement)
	  picker.style.position = "fixed";
	  picker.style.top = (chatRect.top + window.scrollY + (chatRect.height /6) - (picker.offsetHeight / 1.3)) + "px";
	  picker.style.left = (chatRect.top + window.scrollX + (chatRect.width /0.83) - (picker.offsetWidth / 1)) + "px";
	  picker.style.zIndex = "9999";
	    } else {
	      picker.style.display = 'none';
	    }
	  });




          // Positionner le picker au-dessous du bouton
//	      const rect = button.getBoundingClientRect();
//	      picker.style.top = (rect.bottom + window.scrollY) + 'px';
//	      picker.style.left = (rect.left + window.scrollX) + 'px';





	  // Empecher que le picker soit hors ecran
//	     setTimeout(() => {
//	       const pickerRect = picker.getBoundingClientRect();
//	       const winWidth = windows.innerWidth;
//	       const winHeight = window.innerHeight;

//	  // Ajuste la gauche si le picker depasse du cote droit
//	    if (pickerRect.right > winWidth) {
//	      picker.style.left = (winWidth - pickerRect.width -10) + 'px';
//	   }
//	  // Ajuste le haut si le picker depasse en bas
//	    if (pickerRect.bottom > winHeight) {
//	     picker.style.top = (winHeight - pickerRect.height -10) + 'px';
//	   }
//        }, 10);  // Attend que le DOM affiche le picker 

//	    } else {
//	      picker.style.display = 'none';
//	    }
//	  });




	  // Quand un emoji est choisi, l'insérer dans l'input et cacher le picker
	  picker.addEventListener('emoji-click', event => {
	    const emoji = event.detail.unicode;
	    input.value += emoji;
	    input.focus();
	    picker.style.display = 'none';
	  });

	  // Optionnel : clique à l’extérieur pour fermer le picker
	  document.addEventListener('click', e => {
	    if (!picker.contains(e.target) && e.target !== button) {
	      picker.style.display = 'none';
	    }
	  });
