<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Fichiers disponibles</title>
    <style>
        body { font-family: Arial, sans-serif; background: #031333; }
        h1 { background: #07557F; color: #00E8F8; padding: 10px; }
        table { background: #8088AF; border-radius: 8px; width: 100%; margin-top: 20px; border-collapse: collapse; }
        th, td { padding: 10px 15px; text-align: left; border-bottom: 1px solid #eee; }
        tr:hover { background: #AFBFDF; }
        a { color: #A02030; text-decoration: none; font-weight: bold; }
        .icon { margin-right: 8px; }
    </style>
</head>
<body>
    <h1>Fichiers disponibles</h1>
    <table>
        <tr>
            <th>Nom du fichier</th>
            <th>Taille</th>
            <th>Dernière modification</th>
        </tr>
        <?php
        $files = scandir(__DIR__);
        foreach ($files as $file) {
            if ($file == '.' || $file == '..' || $file == basename(__FILE__)) continue;
            if (is_file($file)) {
                echo '<tr>';
                echo '<td><span class="icon">📄</span> <a href="'.htmlspecialchars($file).'">'.htmlspecialchars($file).'</a></td>';
                echo '<td>'.round(filesize($file) / 1024, 2).' Ko</td>';
                echo '<td>'.date("d/m/Y H:i", filemtime($file)).'</td>';
                echo '</tr>';
            }
        }
        ?>
    </table>
</body>
</html>
