<?php
/*
* Simple Chat v2.1.A par Stephan Soller (Modifié Par VA2VDC )
* Source originale : [http://arkanis.de/projects/simple-chat/](http://arkanis.de/projects/simple-chat/)
*/
//  include = "config/config.php";
include __DIR__ . "/config/SChatConfig.php";

function getUserIp() {
    foreach ([
	'HTTP_CLIENT_IP',
	'HTTP_X_FOWARDED_FOR',
	'HTTP_X_FOWARDED',
	'HTTP_X_CLUSTER_CLIENT_IP',
	'HTTP_FORWARDED_FOR',
	'HTTP_FORWARDED',
	'REMOTE_ADDR'
    ] as $keyz) {
	if (!empty($_SERVER[$keyz])) {
	    $ipList = explode(',', $_SERVER[$keyz]);
	    foreach ($ipList as $ipx) {
		$ipx = trim($ipx);
		if (filter_var($ipx, FILTER_VALIDATE_IP)) {
		    return $ipx;
		}
	    }
	}
    }
    return 'IP Non trouvee';
}

// Nom du fichier tampon de messages ** SMessages.json **  ******************************
$messages_buffer_file = FICHIER_MESSAGE_TEXT;

// Nombre maximum de messages conservés
$messages_buffer_size = 1000;

// Activer ou non le fichier journal
$enable_SChatlog = true;

$count_file = __DIR__ . "/log/" . "SMessages_Readed.txt";

// " Messages Non Lu" Au Debut Du script Si Besoin ** VueOk ** SMessages_Readed.txt *************
if (isset($_POST["content"]) && $_POST["content"] === CHECK_OK) {
   file_put_contents($count_file, "0");
   exit();
}
// -------------- OLD --------------  * SMessages.json  * * * * * * *********************
$messages_buffer_file = __DIR__ . "/log/" . FICHIER_MESSAGE_TEXT;
$old_hash = file_exists($messages_buffer_file) ? md5_file($messages_buffer_file) : "";

/*
 * Envoi d’un nouveau message
 */

// Code Special pour la remise a zero --------------* ElyasRaz1234  * * * ***************
if (isset($_POST["content"]) && $_POST["content"] === PASSWORD_ALL_CLEAR) {
   $buffer = fopen($messages_buffer_file, "w");
   flock($buffer, LOCK_EX);
   fwrite($buffer, "[]");  // vide le chat
   flock($buffer, LOCK_UN);
   fclose($buffer);
   file_put_contents($count_file, "0");
   exit();
}

// Code Special pour la remise a zero  Avec Log --- * ElyasRaz1234log * * ***************
if (isset($_POST["content"]) && $_POST["content"] === PASSWORD_ALL_LOG) {
   $buffer = fopen($messages_buffer_file, "w");
   flock($buffer, LOCK_EX);
   fwrite($buffer, "[]");  // vide le chat
   flock($buffer, LOCK_UN);
   fclose($buffer);

//  Optionnel : Vide Aussi le Log  * SChatlog.log * * * * * * ***************LOG/********
 if ($enable_SChatlog && file_exists("/" . FICHIER_LOG_SAFETY)) {
    file_put_contents("/" . FICHIER_LOG_SAFETY, "");
   }
   file_put_contents($count_file, "0");
   exit();
}

// Code spécial pour effacer uniquement la dernière entrée du chat ** LastEff ***********
if (isset($_POST["content"]) && $_POST["content"] === EFFACE_LAST) {
    if (file_exists($messages_buffer_file)) {
        // Lecture et décodage json
        $messages = json_decode(file_get_contents($messages_buffer_file), true);
        // Suppression du dernier message s'il existe
        if (!empty($messages)) {
            array_pop($messages);
            file_put_contents($messages_buffer_file, json_encode($messages, JSON_PRETTY_PRINT));
        }
    }
   file_put_contents($count_file, "0");
    exit();
}

if (isset($_POST["content"]) && isset($_POST["name"])) {
    // Crée le fichier tampon si inexistant
    if (!file_exists($messages_buffer_file)) {
        touch($messages_buffer_file);
    }

    // Ouvrir et verrouiller le fichier JSON en lecture/écriture
    $buffer = fopen($messages_buffer_file, "c+b");
    flock($buffer, LOCK_EX);
    $buffer_data = stream_get_contents($buffer);

    // Charger la mémoire tampon (ou tableau vide si fichier vide)
    $messages = $buffer_data ? json_decode($buffer_data, true) : [];

    // Calculer l’ID du prochain message
    $next_id = (count($messages) > 0) 
        ? $messages[count($messages) - 1]["id"] + 1 : 0;

    // Nettoyer et limiter les entrées utilisateur  ** Anonymous **********************
    $name = trim($_POST["name"]);
    if ($name === "") {
        $name = getUserIp()." -- ".ANONYMOUS_JACK_NAME; //     $name = ANONYMOUS_JACK_NAME; ****************** CHAT ************ echo $_SERVER['SERVER_ADDR']; ----  echo $_SERVER['SERVER_NAME'];
    }
    $name = substr($name, 0, 32);

    $content = $_POST["content"];
    $content = wordwrap($content, 80, "\n", true);
    $content = substr($content, 0, 500);

    // Ajouter le message dans la mémoire tampon
    $messages[] = [
        "id"      => $next_id,
        "time"    => time(),
        "name"    => $name,
        "content" => $content
    ];

    // Supprimer les messages trop anciens
    if (count($messages) > $messages_buffer_size) {
        $messages = array_slice(
            $messages,
            count($messages) - $messages_buffer_size
        );
    }

    // Réécrire le fichier JSON
    ftruncate($buffer, 0);
    rewind($buffer);
    fwrite($buffer, json_encode($messages));
    flock($buffer, LOCK_UN);
    fclose($buffer);

    // Change le Flag ------  ** SMessages_Readed.txt ********************************* 

if (!file_exists($count_file)) {
    file_put_contents($count_file, "0");
}
$Cnt = (int) file_get_contents($count_file);
$Cnt++;
   file_put_contents($count_file, $Cnt); //  $Cnt  compteur ***************************************************   
    chmod($count_file, 0644);

    // Sauvegarde optionnelle dans le fichier log  ** SChatlog.log ********************
    if ($enable_SChatlog) {
        $log_entry = date("Y-m-d -- H:i:s") . "\t"
            . $next_id . "\t"
            . strtr($name, "\t", " ") . "\t"
            . strtr($content, "\t", " ") . "\n";
        file_put_contents("log/" . FICHIER_LOG_SAFETY, $log_entry, FILE_APPEND);
    }

    // Fin après enregistrement

// -------------- NEW --------------  * SMessages.json  * * * * * * *********************
$messages_buffer_file = __DIR__ . "/log/" . FICHIER_MESSAGE_TEXT;
$new_hash = file_exists($messages_buffer_file) ? md5_file($messages_buffer_file) : "";

    exit();
}

/**
 * Récupération des messages (AJAX polling côté client)
 */
if (isset($_GET["fetch"])) {
    if (file_exists($messages_buffer_file)) {
        echo file_get_contents($messages_buffer_file);
    } else {
        echo "[]"; // renvoyer un tableau JSON vide si pas de fichier
    }
    exit();
}

?>