<?php
//  -*-*--*-*-*-*-*-*-*-*-  Démarrage de session  -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
// Liste des couleurs valides (optionnel, à garder pour validation)
$bgColor0Options = ['#030304', '#838484', '#074C88', '#DEDFDF'];
$bgColor2Options = ['#333434', '#043464', '#532363', '#838393', '#430303', '#E7E7E7', '#274D8F', '#EFA74F'];

// Chemin relatif vers colors.json
$jsonFile ='/var/www/html/css/colors.json';

// Lecture du fichier colors.json (si présent)
//  *** if(file_exists($jsonFile)) {
//  ***     $savedColors = json_decode(file_get_contents($jsonFile), true); //  ***** $bgColor0  & $bgColor2  *******
//  *** } else {
//  ***      $savedColors = [];
//  ***  }

// Lecture du JSON
$jsonColors = [];
if(file_exists($jsonFile)) {
    $jsonColors = json_decode(file_get_contents($jsonFile), true); //  ***** $bgColor0  & $bgColor2  *******
}

// Récupérer couleur de la session, sinon du JSON, sinon valeur hardcodée
$bgColor0 = $_SESSION['bgColor0'] ?? ($jsonColors['bgColor0'] ?? $bgColor0Options[0]); // *** $bgColor0Options[0] *** $saveColors[$bgColor0] ***
$bgColor2 = $_SESSION['bgColor2'] ?? ($jsonColors['bgColor2'] ?? $bgColor2Options[0]); // *** $bgColor2Options[0] *** $saveColors[$bgColor2] ***

// Sécuriser la valeur avec validation
if (!in_array($bgColor0, $bgColor0Options)) $bgColor0 = $bgColor0Options[0]; // *****  $bgColor0Options[0]
if (!in_array($bgColor2, $bgColor2Options)) $bgColor2 = $bgColor2Options[0]; // *****  $bgColor2Options[0]

// Lecture et validation des couleurs depuis session ou valeurs par défaut
$selectedBgColor0 = $_SESSION['bgColor0'] ?? $bgColor0Options[2];
if (!in_array($selectedBgColor0, $bgColor0Options)) {
    $selectedBgColor0 = $bgColor0Options[2];
}

$selectedBgColor2 = $_SESSION['bgColor2'] ?? $bgColor2Options[0];
if (!in_array($selectedBgColor2, $bgColor2Options)) {
    $selectedBgColor2 = $bgColor2Options[0];
}
?>