<?php
session_start();
// Mot de Pass Hache a comparer ( idealement stocke dans config ) 

// $hashedSafetyPass = '$2y$10$UdnUAp6hpmH4cZ6CRIhGA.wYOiGRjGse8L5WkxNaHjbmyqtRhV2qi'; // Va2---1**4
$hashedUserPass = '$2y$10$19ObAVkRxLPQBSckpwdVzeJGNYVvl3OxZwiRTz6H2xyvTRafSWtKK'; // M1**4
$hashedSafetyPass = '$2y$10$l2JCZcSTH.KHPWZ0mjQuyersKy9Lp0io2Id.zbMHpPvdqpQycgt0a'; // 1**4-Va2

// Authentification
// Initialisation du compteur et du timestamp
if (!isset($_SESSION['login_attempts'])) {
    $_SESSION['login_attempts'] = 0;
    $_SESSION['first_attempt_time'] = time();
}

// Définir le délai par défaut
$block_time = 120; // 2 Minutes

// Blocage si trop de tentatives récentes
// Si le nombre de tentatives dépasse 3, on applique un délai plus long
if ($_SESSION['login_attempts'] >= 3) {
    // Si c'est la première fois qu'on dépasse ce seuil, on démarre ou double la durée
    if (!isset($_SESSION['block_start_time'])) {
        $_SESSION['block_start_time'] = time();
    }
    // Calcul de la durée écoulée depuis le blocage
    $elapsed = time() - $_SESSION['block_start_time'];
    // Délai de blocage de 5 minutes (300 sec)
    $extended_block_time = 300;
    if ($elapsed < $extended_block_time) {
        die("Trop de tentatives. Réessayez plus tard. ( 5 Minutes )");
    } else {
        // Après délai, on réinitialise tout
        $_SESSION['login_attempts'] = 0;
        unset($_SESSION['first_attempt_time'], $_SESSION['block_start_time']);
    }
} else {
    // Si on est en dessous de 5 tentatives, on vérifie le délai de 3 minutes
    if ((time() - $_SESSION['first_attempt_time']) > $block_time) {
        // Remise à zéro du compteur et du timer
        $_SESSION['login_attempts'] = 0;
        $_SESSION['first_attempt_time'] = time();
    }
}

if (isset($_POST['mdp'])) {
    $inputPassword = $_POST['mdp'];

if (password_verify($inputPassword, $hashedSafetyPass) || password_verify($inputPassword, $hashedUserPass)) {
    // Authentification réussi
       session_regenerate_id(true); // Sécurise Password
       $_SESSION['auth'] = true;
       $_SESSION['login_attempts'] = 0;
       unset($_SESSION['first_attempt_time'], $_SESSION['block_start_time']);
//     echo "Connexion réussie.";  //   Safety Or User  PASS  **************************
       $message = "Connexion réussie.";
    } else {
        $_SESSION['login_attempts']++;
        if (!isset($_SESSION['first_attempt_time'])) {
            $_SESSION['first_attempt_time'] = time();
        }
//      echo "Mot de passe incorrect.";
        $message = "Mot de passe incorrect.";
    }
}

if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}

if (!isset($_SESSION['auth']) || $_SESSION['auth'] !== true) {
    ?>
    <!DOCTYPE html>
    <html>
    <head><title>Connexion</title></head>
    <body>
        <h2>Veuillez vous connecter</h2>
        <?php if (isset($erreur)) echo "<p style='color:red;'>$erreur</p>"; ?>
        <form method="post">
            <input type="password" name="mdp" placeholder="Mot de passe" required />
            <input type="submit" value="Se connecter" />
             <?php if (isset($message)): ?>
              <span style="margin-left: 10px; color: green; font-weight: bold;">
               <?= htmlspecialchars($message) ?>
              </span>
             <?php endif; ?>
        </form>
    </body>
    </html>
    <?php
    exit;
}

// === Liste des dossiers prédéfinis ===
$dossiers_predef = [
    "/var/www/html/",
    "/var/www/html/Xfiles/",
    "/var/www/html/include/",
    "/var/log/YSFReflector/",
    "/var/log/lighttpd/",
    "/var/log/",
    "/usr/local/etc/",
    "/mnt/usb/",
    "/mnt/usb1/",
    "/mnt/usb2/",
    "/mnt/usb3/",
    "/etc/",
    "/etc/YSFReflector/",
    "/etc/lighttpd/",
    "/etc/lighttpd/conf-available/",
    "/etc/php/8.3/",
    "/etc/php/8.3/cgi/",
    "/etc/php/8.3/cli/",
    "/etc/php/8.3/fpm/",
    "/etc/php/8.3/mods-available/",
    "/etc/php/8.3/cgi/conf.d/",
    "/etc/php/8.3/cli/conf.d",
    "/etc/php/8.3/fpm/conf.d",
    "/home/pi/",
    "/tmp/",
    "/opt/",
    "/var/www/",
    "/root/",
    "/srv/",
    "/var/cache/",
];

$dossierBase = '/var/www/html/'; // Défaut
if (!empty($_POST['dossierBaseCustom'])) {
    $dossierBase = $_POST['dossierBaseCustom'];
} elseif (!empty($_POST['dossierBase'])) {
    $dossierBase = $_POST['dossierBase'];
} elseif (!empty($_GET['dossierBase'])) {
    $dossierBase = $_GET['dossierBase'];
}

$fichier = 'index.php'; // Défaut
if (!empty($_POST['fichierCustom'])) {
    $fichier = $_POST['fichierCustom'];
} elseif (!empty($_POST['fichier'])) {
    $fichier = $_POST['fichier'];
} elseif (!empty($_GET['fichier'])) {
    $fichier = $_GET['fichier'];
}

// Liste dynamique des fichiers du dossier sélectionné
$fichiers_dossier = [];
if (is_dir($dossierBase)) {
    foreach (scandir($dossierBase) as $fich) {
        if ($fich === '.' || $fich === '..') continue;
        if (is_file($dossierBase . $fich)) {
            $fichiers_dossier[] = $fich;
        }
    }
}

// Sécurité : On vérifie le chemin
// ... (code de récupération du dossier et nom de fichier inchangé)

// Sécurité : On vérifie le chemin (Amélioration)
$cheminComplet = realpath($dossierBase . $fichier);
if ($cheminComplet === false) {
    $cheminComplet = $dossierBase . $fichier; // On tente de créer un nouveau fichier
    // Vérification de la sécurité : s'assurer que le chemin n'échappe pas du dossier autorisé
    if (strpos(realpath($dossierBase), dirname(realpath($cheminComplet) ?: $dossierBase)) !== 0) {
        $message = "Chemin non autorisé.";
        $cheminComplet = realpath($dossierBase . 'YSFHosts.txt');
    } else {
        $message = '';
    }
} elseif (strpos($cheminComplet, $dossierBase) !== 0) {
    $message = "Fichier non autorisé ou introuvable.";
    $cheminComplet = realpath($dossierBase . 'YSFHosts.txt');
} else {
    $message = '';
}

// Gestion des actions
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'Enregistrer' && isset($_POST['contenu'])) {
        $contenu = $_POST['contenu'];

        // Permettre la création du fichier s'il n'existe pas
        if (!file_exists($cheminComplet)) {
            // Vérifier qu'on peut écrire dans le dossier parent
            if (is_writable(dirname($cheminComplet))) {
                if (file_put_contents($cheminComplet, $contenu) !== false) {
                    $message = 'Fichier créé et enregistré avec succès.';
                } else {
                    $message = 'Erreur lors de la création et sauvegarde du fichier.';
                }
            } else {
                $message = "Le dossier n'est pas modifiable, impossible de créer ce fichier.";
            }
        } elseif (is_writable($cheminComplet)) {
            // Fichier existant, on le met à jour
            if (file_put_contents($cheminComplet, $contenu) !== false) {
                $message = 'Fichier mis à jour avec succès.';
            } else {
                $message = 'Erreur lors de la sauvegarde.';
            }
        } else {
            $message = "Le fichier n'est pas modifiable.";
        }
    } elseif ($_POST['action'] === 'Charger le fichier') {
        $message = "Fichier chargé.";
    }
}

// Charger le contenu du fichier, s'il existe
$contenu_actuel = '';
if (file_exists($cheminComplet)) {
    $contenu_actuel = file_get_contents($cheminComplet);
} else {
    $contenu_actuel = '';
    // On ne signale pas d'erreur ici, car le fichier peut être en cours de création
}

?>
<!DOCTYPE html>
<html>
<head>
    <title>Éditeur de fichier protégé</title>
    <meta charset="utf-8">
    <style>
    body {
        background-color: #152535;
        color: #EAEFC0;
        font-family: Arial, sans-serif;
    }
    .file-editor-form {
        background-color: #22293b;
        padding: 20px;
        border-radius: 8px;
        width: 95%;
        max-width: 1400px;
        margin: auto;
    }
    .file-editor-form select,
    .file-editor-form input[type=text] {
        background-color: #2f3b52;
        color: #EAEFC0;
        border: 1px solid #667;
        padding: 5px;
        margin-top: 5px;
        border-radius: 4px;
    }
    .file-editor-form .file-content {
        width: 100%;
        background-color: #1e1e1e;
        color: #dcdcdc;
        border: 1px solid #555;
        border-radius: 4px;
        font-family: monospace;
        padding: 10px;
    }
    .btn {
        background-color: #3a5f8a;
        border: none;
        padding: 8px 14px;
        margin: 5px;
        border-radius: 5px;
        color: white;
        cursor: pointer;
    }
    .btn:hover {
        background-color: #5084c2;
    }
    .btn-save {
        background-color: #468a3a;
    }
    .btn-save:hover {
        background-color: #5ab54f;
    }
    </style>
</head>
<body>
    <p><a href="?logout=1" style="color:#AEFFC0;">Se déconnecter </a>  <?php if ($message): ?>
        <strong style="color:#FEBF40;">  <?php echo htmlspecialchars($message); ?> </strong><?php endif; ?></p>
    <h2>Édition du fichier :  <?php echo htmlspecialchars(basename($cheminComplet)); ?></h2>



    <form method="post" class="file-editor-form">
        <label>📂 Choisir le dossier :</label><br>
        <select name="dossierBase" onchange="this.form.submit()">
            <?php foreach ($dossiers_predef as $dossier): ?>
                <option value="<?php echo htmlspecialchars($dossier); ?>" <?php if($dossierBase==$dossier) echo "selected"; ?>>
                    <?php echo htmlspecialchars($dossier); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <input type="text" name="dossierBaseCustom" placeholder="Autre chemin..." value="<?php echo htmlspecialchars($dossierBase); ?>" size="70" /><br><br>

        <label>📄 Fichier à éditer :</label><br>
        <select name="fichier">
            <?php foreach ($fichiers_dossier as $fich): ?>
                <option value="<?php echo htmlspecialchars($fich); ?>" <?php if($fichier==$fich) echo "selected"; ?>>
                    <?php echo htmlspecialchars($fich); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <input type="text" name="fichierCustom" placeholder="Autre fichier..." value="<?php echo htmlspecialchars($fichier); ?>" size="70" /><br><br>

        <textarea name="contenu" rows="26" cols="160" class="file-content"><?php echo htmlspecialchars($contenu_actuel); ?></textarea><br>
        <input type="submit" name="action" value="Charger le fichier" class="btn" />
        <input type="submit" name="action" value="Enregistrer" class="btn btn-save" />
    </form>
</body>
</html>
