<?php
$valeursAutorisees = [25,33,50,75,100,200,300,400,600,1000,1200,1500,3000];
// $defaultStep = 2;
// if (isset($_GET['step']) && in_array((float)$_GET['step'], $valeursAutorisees, true)) {
//     $StepQuart = (float)$_GET['step'];
// } else {
//     $StepQuart = $defaultStep;
// }
if (!in_array($StepQuart, $valeursAutorisees, true)) {
    $StepQuart = 200;
    if (isset($_GET['step'])) {
        $StepQuart = floatval($_GET['step']);
    }
}
?>

<!--    table table-condensed    -->
<div class="card" style="background-color:#DADAEA; padding:5px; box-shadow:0 0 10px 3px #000; border-radius:15px;">

<style>
@media (max-width: 720px) {
  .card-header {
    flex-direction: column;
    align-items: flex-start;
    font-size: 1.2em;
  }
  .card-header form {
    margin-top: 8px;
  }
  #toggleViewBtnAllHeard {
    margin-top: 10px;
    align-self: flex-end;
  }
}
</style>


  <div class="card-header" style="
      background-color:#838393;
      color:#DFEFFF;
      font-size:1.6em;
      font-weight:bold;
      text-shadow:1px 1px 4px #000;
      padding:12px 18px;
      border-radius:15px;
      display:flex;
      align-items:center;
      justify-content:space-between;
      flex-wrap:wrap;">

<?php $StepQuart = ($StepQuart / 100 ); ?>

    <div style="display:flex; align-items:center; gap:10px;">
      <span>Liste entendues aujourd’hui</span>
      <form method="GET" style="background-color:#686878; display:flex; align-items:center; padding: 10px; border-radius: 15px; margin:0;">
        <label for="stepSelect" style="color:#8FCFFF; margin-right:2px; font-size:0.8em;">Période :</label>
        <select id="stepSelect" name="step" onchange="this.form.submit()" 
                style="background-color:#606070; color:#90CFFF; border:none; border-radius:5px; padding:2px 6px; font-size:0.8em;">
          <option value="25" <?= ($StepQuart == 0.25 ? 'selected' : '') ?>>4 Heures</option>
          <option value="33" <?= ($StepQuart == 0.33 ? 'selected' : '') ?>>3 Heures</option>
          <option value="50" <?= ($StepQuart == 0.50 ? 'selected' : '') ?>>2 Heures</option>
          <option value="75"   <?= ($StepQuart == 0.75   ? 'selected' : '') ?>>1.5 Heure</option>
          <option value="100"   <?= ($StepQuart == 1   ? 'selected' : '') ?>>1 Heure</option>
          <option value="200"   <?= ($StepQuart == 2   ? 'selected' : '') ?>>30 Minutes</option>
          <option value="300"   <?= ($StepQuart == 3   ? 'selected' : '') ?>>20 Minutes</option>
          <option value="400"   <?= ($StepQuart == 4   ? 'selected' : '') ?>>15 Minutes</option>
          <option value="600"   <?= ($StepQuart == 6   ? 'selected' : '') ?>>10 Minutes</option>
          <option value="1000"  <?= ($StepQuart == 10  ? 'selected' : '') ?>>6 Minutes</option>
          <option value="1200"  <?= ($StepQuart == 12  ? 'selected' : '') ?>>5 Minutes</option>
          <option value="1500"  <?= ($StepQuart == 15  ? 'selected' : '') ?>>4 Minutes</option>
          <option value="3000"  <?= ($StepQuart == 30  ? 'selected' : '') ?>>2 Minutes</option>
        </select>
      </form>
    </div>

    <button id="toggleViewBtnAllHeard" 
            style="border-radius:10px; padding:4px 10px; background-color:#CBDADA; color:#000; font-size:0.8em;">
      Afficher la liste
    </button>
  </div>

<?php
// Récupération du choix de l'utilisateur dans l’URL
if (!in_array($StepQuart, $valeursAutorisees, true)) {
    if (isset($_GET['step'])) {
	$StepQuart = floatval($_GET['step']);
	$StepQuart = ( $StepQuart / 100);
    } else {
	$StepQuart = 0.33;
    }
}

$StepTXT = '';
// $StepQuart = $StepQuart / 100;
if ($StepQuart <= 0.25 ) {
$StepTXT = '4 Heurs ' ;
} else if ($StepQuart == 0.33 ) { 
$StepTXT = '3 Heures ' ; 
} else if ($StepQuart == 0.5 ) { 
$StepTXT = '2 Heures ' ; 
} else if ($StepQuart == 0.75 ) { 
$StepTXT = '1.5 Heures ' ;
} else if ($StepQuart == 1 ) { 
$StepTXT = '1 Heur ' ; 
} else if ($StepQuart == 2 ) { 
$StepTXT = '30 Minutes ' ;
} else if ($StepQuart == 3 ) {
$StepTXT = '20 minutes ' ;
} else if ($StepQuart == 4 ) { 
$StepTXT = '15 Minutes ' ;
} else if ($StepQuart == 6 ) { 
$StepTXT = '10 minutes ' ;
} else if ($StepQuart == 10 ) {
$StepTXT = '6 Minutes ' ;
} else if ($StepQuart == 12 ) {
$StepTXT = '5 Minutes ' ;
} else if ($StepQuart == 15 ) {
$StepTXT = '4 Minutes ' ;
} else if ($StepQuart == 30 ) {
$StepTXT = '2 minutes ' ;
} else { 
$StepTXT = 'Indetermine ! ' ;
}

if ( $StepQuart <= 0.25 ) { 
	$StepTminutes = (240 / 1 ); // 4Hrs
    } else if ( $StepQuart <= 0.33 ) { 
        $StepTminutes = (180 / 1 );  // 3 Hrs
    } else if ( $StepQuart <= 0.50 ) { 
        $StepTminutes = (120 / 1 ); // 2 Hrs 
    } else if ( $StepQuart <= 0.75 ) { 
        $StepTminutes = (90 / 1 );  // 1h30
    } else { 
        $StepTminutes = (60 / $StepQuart ); // 1Hrs et Moin
    }

$StepTimes = (24 * $StepQuart ); //  24*4=96  $StepQuart

$visitesParQuartHeure = array_fill(0, $StepTimes, 0);  //  96  / 48  / 24 / 12      96 tranches de 15 minutes pour 24 h
$NBVisiteurs24Hrs = 0;

foreach ($allHeard as $listElem) {
    $NBVisiteurs24Hrs++;
    $timestamp = strtotime($listElem[0]);                 // ex: 2025-10-26 12:07:58
    $totalMinutes = (int)date('G', $timestamp) * 60 + (int)date('i', $timestamp);
    $index = floor($totalMinutes / $StepTminutes );       // 15 /  30  /  60  / 120    / 240    calcule la tranche (0–95)
    if ($index >= 0 && $index < $StepTimes) {             // 96 /  48  /  24  / 12     / 6      vérifie que l’index reste valide
        $visitesParQuartHeure[$index]++;                  // Quart Demi  1 Hrs /  2 Hrs / 4 Hrs  incrémente la tranche correspondante
    } else {
	echo ' Erreur Index Pas Bon ';
    }
}

$labels = [];  //                      96 - 4 --4 _ 15    //    48 - 2 --2 _ 30    //    24 -  1  --1 _ 60   //    12 -* 2 --1 _ 60   //   6 -* 4 --1 _ 60   
if ( $StepQuart == '0.75' ) {
     $StepTimes = $StepTimes -2;
    } 

for ($i = 0; $i < $StepTimes; $i++) {
   if ( $StepQuart == '0.75' ) { 
	$h = floor((($i) + ($i/ 8 )) / $StepQuart );
    } else {
	$h = floor($i / $StepQuart );
    }  //    $StepQuart

   if ( $StepQuart <= '0.5' ) { 
	$m = ($i % 1 ) * 60 ; 
    } elseif ( $StepQuart <= '0.75' ) { 
	$m = ($i % 2 ) * 30 ; 
    } else { 
	$m = ($i % $StepQuart ) * $StepTminutes; 
    } //  $StepQuart ) * $StepTminutes
    $labels[] = sprintf('%02dh%02d', $h, $m);
}
?>

<!-- Contenu de la carte (basculable) ---------------------  -->
  <div class="card-body" style="padding:10px;">

  <!-- Tableau visible au départ -->
    <div id="tableContainer" class="table-responsive" style="display:none;">
      <table id="allHeard" class="table table-condensed" data-page-length="15">
       <thead>
         <tr>
           <th>Heure (<?php echo TIMEZONE;?>)</th>
           <th>Indicatif</th>
           <th>Cible</th>
           <th>passerelle</th>
           <th>Durée (s)</th>
         </tr>
        </thead>
        <tbody>
          <?php foreach ($allHeard as $listElem): ?>
            <tr style="background-color:#CACADA;">
              <td><?= $listElem[0] ?></td>
    <?php
      if ($listElem[1] !== "??????????" && !is_numeric($listElem[1])) {
        $dayCaller = preg_replace('/[-\/_].*/', '', $listElem[1]);
        echo "<td nowrap><a target=\"_new\" href=\"https://qrz.com/db/$dayCaller\">" 
             . str_replace("0", "&Oslash;", $listElem[1]) . "</a></td>";
      } else {
        echo "<td></td>"; // ou autre gestion
      }
    ?>
              <td><?= $listElem[2] ?></td>
              <td><?= $listElem[3] ?></td>
              <td><?= $listElem[4] ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
  </div>  <!-- Tableau visible au Fin -->

    <div id="graphContainer" style="display:block;text-align:center;">
      <p style="color:#0050A0; font-size: 1.4em;">PTT (Tx) reçus par <?= $StepTXT ?> (Dernières 24 heures) <button id="printChartBtn">Imprimer le graphique</button> </p>
      <canvas id="visitesGraph" width="1120" height="350"></canvas>
      <p style="color:#007080; font-size: 1.4em;">Heure locale Québec : <?= date('Y-m-d H:i') ?></p>
    </div>
        
 </div> <!-- fin card-body -->
</div> <!-- fin card -->

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


<script>
document.getElementById('printChartBtn').addEventListener('click', () => {
  const container = document.getElementById('graphContainer');
  const canvas = document.getElementById('visitesGraph');
  const dataUrl = canvas.toDataURL('image/png');

  // On récupère le titre et l'heure locale HTML
  const titleHTML = container.querySelector('p:first-of-type').outerHTML;
  const heureHTML = container.querySelector('p:last-of-type').outerHTML;

  // On crée une nouvelle fenêtre d'impression
  const printWindow = window.open('', '_blank');
  printWindow.document.write('<html><head><title>Impression Graphique</title></head><body style="text-align:center;">');

  // On insère le titre, l'image et l'heure locale
  printWindow.document.write(titleHTML);
  printWindow.document.write('<img src="' + dataUrl + '" style="max-width: 100%; height: auto;"/>');
  printWindow.document.write(heureHTML);

  printWindow.document.write('</body></html>');
  printWindow.document.close();
  printWindow.focus();

  // Attendre un peu que la fenêtre ait chargé le contenu puis imprimer
  setTimeout(() => {
    printWindow.print();
    printWindow.close();
  }, 500);
});

</script>


<!-- Chart.js -->
<script>
document.addEventListener('DOMContentLoaded', function() {
  const btn = document.getElementById('toggleViewBtnAllHeard');
  const table = document.getElementById('tableContainer');
  const graph = document.getElementById('graphContainer');

  // Le texte du bouton doit correspondre à l'affichage actuel (graphique visible)
  btn.textContent = 'Afficher la liste';

  btn.addEventListener('click', () => {
    if (table.style.display === 'none') {
      table.style.display = 'block';
      graph.style.display = 'none';
      btn.textContent = 'Afficher le graphique';
    } else {
      table.style.display = 'none';
      graph.style.display = 'block';
      btn.textContent = 'Afficher la liste';
    }
  });
});


    const labels = <?= json_encode($labels) ?>;
    const dataVisites = <?= json_encode(array_values($visitesParQuartHeure)) ?>;

    // Exemple : définir des couleurs spécifiques pour certaines heures
const couleursBarres = labels.map((_, index) => {
    // index 0–5 : 00h00–01h15
    if (index < ( <?= $StepTimes ?> / (24 / 1.5) )) return '#244A67';  // Nuit profonde (violet)

    // index 6–24 : 01h30–06h00 environ
    if (index < ( <?= $StepTimes ?> / (24 / 6) )) return '#247A97'; // Fin de Nuit profonde (violet)
 
    // index 25–28 : 06h15–10h00
    if (index < ( <?= $StepTimes ?> / (24 / 7) )) return '#AF4C00'; // orange foncé (matin)

    // index 29–40 : 07h15–10h00
    if (index < ( <?= $StepTimes ?> / (24 / 10) )) return '#C87820'; // orange foncé (matin) 2.3414634146

    // index 41–48 : 10h15–12h00
    if (index < ( <?= $StepTimes ?> / (24 / 12) )) return '#DFAF3A'; // orange clair (midi) 1.9591836735

    // index 49–52 : 12h15–13h00
    if (index < ( <?= $StepTimes ?> / (24 / 13) )) return '#FFDC44'; // vert doux (après-midi) 1.8113207547

    // index 53–60 : 13h00–14h00
    if (index < ( <?= $StepTimes ?> / (24 / 14) )) return '#D0E09F'; // orange foncé (matin)

    // index 53–60 : 14h00–15h00
    if (index < ( <?= $StepTimes ?> / (24 / 15) )) return '#B0D0EF'; // orange foncé (matin)

    // index 53–60 : 15h00–16h00
    if (index < ( <?= $StepTimes ?> / (24 / 16) )) return '#90B0FF'; // orange foncé (matin)

    // index 61–68 : 15h15–17h00
    if (index < ( <?= $StepTimes ?> / (24 / 17) )) return '#7F9FF6'; // orange clair (midi)

    // index 69–72 : 17h15–18h00
    if (index < ( <?= $StepTimes ?> / (24 / 10) )) return '#5F6FBF'; // vert doux (après-midi)

    // index 73–80 : 18h15–20h00
    if (index < ( <?= $StepTimes ?> / (24 / 20) )) return '#4F2F8F'; // bleu ciel (début soirée)

    // index 81–95 : 20h15–23h45
    return '#350555'; // nuit (violet foncé)
});


// Fonction pour éclaircir légèrement la couleur au survol
    function lightenColor(hex, percent) {
        const num = parseInt(hex.replace('#',''), 16);
        const r = Math.min(255, (num >> 16) + 255 * percent);
        const g = Math.min(255, ((num >> 8) & 0x00FF) + 255 * percent);
        const b = Math.min(255, (num & 0x0000FF) + 255 * percent);
        return `rgb(${Math.round(r)}, ${Math.round(g)}, ${Math.round(b)})`;
    }

    const hoverCouleurs = couleursBarres.map(c => lightenColor(c, 0.2));

    const ctx = document.getElementById('visitesGraph').getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Nombre Total de PTT (Tx) <?= '  ' .$NBVisiteurs24Hrs ?>',
                data: dataVisites,
                backgroundColor: couleursBarres, // <= tableau de couleurs ici
                hoverBackgroundColor: hoverCouleurs,  // couleur éclaircie au survol
                borderColor: '#010101',
                borderWidth: 1
            }]
  },
options: {
  responsive: false,
  scales: {
    y: {
      beginAtZero: true
    }
  },
  plugins: {
    legend: {
      onClick: null  // Désactive le clic sur la légende
    }
  }
}
});

// DataTable init
    $(document).ready(function(){
      $('#allHeard').DataTable( {"aaSorting": [[0,'desc']]
      } );
    });
   </script>
