// ---------------------Effet de neige moderne et corrigé  ***** Good ****** VA2VDC *****
document.addEventListener("DOMContentLoaded", () => {

  const NumberSnows = ["1", "1"];
  const snowCount = NumberSnows[Math.floor(Math.random() * NumberSnows.length)];

// --------------------- Liste d’images possibles * *************************************
  const pictures = [
//    "/js/img/Floccon48.png",
//    "/js/img/FlocVDC.png",  // fixe
    "/js/img/CadeauR1.png", // fixe
    "/js/img/FlocCadeau01.png",
    "/js/img/FlocCadeau02.png",
    "/js/img/CadeauR1.png", // fixe
    "/js/img/FlocCadeau03.png",
    "/js/img/FlocCadeau04.png",
//    "/js/img/Floccon48.png",
    "/js/img/Floccon48.png"// ,   // dernier pas de virgule **--**---***
  ];

  const staticImages = [ // Liste d’images Fix a partir de la Liste Possible *************
    "/js/img/FlocVDC.png",  // fixe
    "/js/img/FlocMRC.png",  // fixe
    "/js/img/CadeauR1.png",  // fixe
    "/js/img/Noel2025.png",  // fixe
    "/js/img/BonneAnnee.png",  // fixe
    "/js/img/heart.png",  // fixe
    "/js/img/Logo-Fixe2.png"
  ];

// --- Choix unique d’une image --- ******************************************************
  const chosenImg = pictures[Math.floor(Math.random() * pictures.length)];
  const isStatic = staticImages.includes(chosenImg); // vrai si l'image doit rester fixe *

// Affiche dans la console l'image choisie pour les flocons ******************************
  console.log("Image choisie :", chosenImg);

  const snowDistance = "pageheight"; // **** pageheight  ou windowheight ******************
  const rotationSpeedFactor = 5 + Math.random() * 60; // ***** 2a5  ***** de 0.4 a 60 ***** 10a20  *************
  let snowflakes = [];
  let snowTimer;

  const snowContainer = document.createElement("div");
  Object.assign(snowContainer.style, {
    position: "fixed",
    top: "0",
    left: "0",
    width: "75%",
    height: "100%",
    pointerEvents: "none",
    zIndex: "999"
  });
  document.body.appendChild(snowContainer);

// ------ Debut -----------Création des flocons **********************************
  for (let i = 0; i < snowCount; i++) {
    const flake = document.createElement("img");
    flake.src = chosenImg; // même image pour tous ***************************************
    flake.style.position = "absolute";

    const size = 160 + Math.random() * 160; // Image de 160 a 320 **************************
    flake.style.width = `${size}px`;
    flake.style.height = `${size}px`;
    flake.style.top = `${Math.random() * window.innerHeight}px`;
    flake.style.left = `${Math.random() * window.innerWidth}px`;
    flake.style.userSelect = "none";

// --------------------Couleur et opacité aléatoire  ou flake.style.filter = "hue-rotate(200deg)"; // ********************
    const colors = ["#ffffff", "#b6d6f7", "#90bfef", "#2196f3", "#fff7cc", "#cff0fc"]; // Color Gold , "#f2dd87" *********
    flake.style.filter = `drop-shadow(0 0 5px ${colors[Math.floor(Math.random() * colors.length)]})`; // *****************
    flake.style.opacity = 0.6 + Math.random() * 0.40; // ************* 0.7 et 0.3 **** Transparence  *********************

    snowContainer.appendChild(flake);

    snowflakes.push({
      element: flake,
      x: Math.random() * (window.innerWidth - 350),// ************* - 350 ou 0 ****************  **  **  **
      y: Math.random() * window.innerHeight,
      amplitude: 16 + Math.random() * 33,
      dx: 0,
      stx: 0.000000003 + Math.random() / 180, // ********************* Pour Intel Core i9 ********************************
      sty: 0.145 + Math.random() * 0.5, // *************************
      wind: 0.04 + Math.random() * 0.00000512, // ******************** Pour Intel Core i9 ********************************

      rotateSpeed: isStatic ? 0 : (i % 2 === 0 ? 1 : -1) * (0.05 + Math.random() * 0.25) * rotationSpeedFactor,
      rotation: isStatic ? 0 : Math.random() * 360, isStatic});
  } // ---- Fin -----------Création des flocons ***********************************

  let lastTime = performance.now();

  function animateSnow() {
    const now = performance.now();
    const deltaTime = (now - lastTime) / 9.67; // 9.67 a 16.67 ******* Pour Intel Core i9  *******************************
    lastTime = now;

    const width = snowDistance === "windowheight" ? window.innerWidth : document.documentElement.scrollWidth;
    const height = snowDistance === "windowheight" ? window.innerHeight : Math.max(document.body.scrollHeight, window.innerHeight);

    snowflakes.forEach(flake => {
      flake.y += flake.sty * deltaTime;
      flake.x += flake.wind * deltaTime;
      if (flake.y > height - 10) {
        flake.x = Math.random() * width;
        flake.y = 0;
      }
      if (flake.x > width) flake.x = 0;

      flake.dx += flake.stx;
      flake.rotation += flake.rotateSpeed * (deltaTime / 16);

      const leftPos = flake.x + flake.amplitude * Math.sin(flake.dx);
      const scaleValue = 0.7 + 0.3 * Math.sin(flake.dx); // ********************* Scale ************************************

      flake.element.style.top = `${flake.y}px`;
      flake.element.style.left = `${leftPos}px`;

      if (flake.isStatic) {
        flake.element.style.transform = `scale(${scaleValue})`;
      } else {
        flake.element.style.transform = `translateZ(0) rotate(${flake.rotation}deg) scale(${scaleValue})`;
      }
    });

    snowTimer = requestAnimationFrame(animateSnow);
  }

  lastTime = performance.now();
  animateSnow();

  // Optionnel : fonction pour masquer les flocons au bout d’un délai
  function hideSnow(delaySeconds = 0) {
    if (delaySeconds <= 0) return;
    setTimeout(() => {
      cancelAnimationFrame(snowTimer);
      snowContainer.style.display = "none";
    }, delaySeconds * 1000);
  }

  // Exemple : cacher la neige après 30 secondes
  // hideSnow(30);

});
