<?php
session_start();
// Chronométrage du début
$timez = microtime();
$timez = explode(' ', $timez);
$timez = $timez[1] + $timez[0];
$start = $timez;

// ************ IP LOG ************
function getClientIP() {
    $ipKeys = [
        'HTTP_X_CLUSTER_CLIENT_IP',
        'HTTP_X_FORWARDED_FOR',
        'HTTP_CLIENT_IP',
        'REMOTE_ADDR'
    ];

    foreach ($ipKeys as $key) {
        if (!empty($_SERVER[$key])) {
            $ips = explode(',', $_SERVER[$key]);
            foreach ($ips as $ip) {
                $ip = trim($ip);
                if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {
                    return $ip;
                }
            }
        }
    }

    return $_SERVER['REMOTE_ADDR'] ?? 'IP non trouvée';
}

function isLocalIP($ip) {
    return !filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE);
}

$ip = getClientIP();
$logDir = __DIR__ . '/log/';
$fileCount = $logDir . 'Compteur.NB';
$fileVisits = $logDir . 'VisitesIP.txt';

// Création dossiers/fichiers si inexistants
if (!file_exists($fileCount)) {
    if (!is_dir($logDir)) {
        mkdir($logDir, 0775, true);
    }
    file_put_contents($fileCount, "0");
}
if (!file_exists($fileVisits)) {
    file_put_contents($fileVisits, "");
}

$count = (int)file_get_contents($fileCount);

// Exclure les IP locales
if (!isLocalIP($ip)) {
    $timeNow = time();
    $delay = 60 * 60; // 15 ou 30 Minutes en Seconds  (1Hrs = 60) ou (2hrs = 120) *************************************
    $found = false;
    $lines = file($fileVisits, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $newLines = [];

    foreach ($lines as $line) {
        list($ipLogged, $timestamp) = explode('|', $line);
        if ($ip == $ipLogged) {
            if ($timeNow - $timestamp < $delay) {
                $found = true;
                $newLines[] = $ipLogged . '|' . $timestamp; // Garder la ligne sans modification
            } else {
                // Mise à jour du timestamp car délai dépassé
                $newLines[] = $ip . '|' . $timeNow;
            }
        } else {
            // Conserver les autres IP dans la liste si encore valides
            if ($timeNow - $timestamp < $delay) {
                $newLines[] = $ipLogged . '|' . $timestamp;
            }
        }
    }

    // Si visiteur non trouvé ou délai dépassé, incrémenter
    if (!$found) {
        $count++;
        file_put_contents($fileCount, $count);
        $newLines[] = $ip . '|' . $timeNow;
    }

    file_put_contents($fileVisits, implode("\n", $newLines));

    // Enregistrement du log de visite
    $date = date('Y-m-d H:i:s');
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown agent';
    $fileLog = $logDir . 'Visites.log';
    $logLine = $date . " | " . $ip . " | " . $userAgent . PHP_EOL;
    file_put_contents($fileLog, $logLine, FILE_APPEND);
}

// echo "Nombre de visites : " . $count;

//  *****  echo "Nombre de visites : " . $count;
//  ************ IP  LOG  & Compteurs ************


// Démarrage de session

// Liste des couleurs valides (optionnel, à garder pour validation)
$bgColor0Options = ['#030304', '#838384', '#074C88'];
$bgColor2Options = ['#333434', '#043464', '#532363', '#838393', '#430303', '#E7E7E7', '#274D8F', '#EFA74F'];

// Chemin relatif vers colors.json
$jsonFile = __DIR__ . '/css/colors.json';

// Lecture du fichier colors.json (si présent)
if(file_exists($jsonFile)) {
    $savedColors = json_decode(file_get_contents($jsonFile), true);
} else {
    $savedColors = [];
}

// Récupérer les couleurs en session ou prendre une couleur par défaut qui est valide
$bgColor0 = $_SESSION['bgColor0'] ?? $bgColor0Options[2];
$bgColor2 = $_SESSION['bgColor2'] ?? $bgColor2Options[0];

// Sécuriser la valeur avec validation
if (!in_array($bgColor0, $bgColor0Options)) $bgColor0 = $bgColor0Options[2];
if (!in_array($bgColor2, $bgColor2Options)) $bgColor2 = $bgColor2Options[0];



// Lecture et validation des couleurs depuis session ou valeurs par défaut
$selectedBgColor0 = $_SESSION['bgColor0'] ?? $bgColor0Options[2];
if (!in_array($selectedBgColor0, $bgColor0Options)) {
    $selectedBgColor0 = $bgColor0Options[2];
}

$selectedBgColor2 = $_SESSION['bgColor2'] ?? $bgColor2Options[0];
if (!in_array($selectedBgColor2, $bgColor2Options)) {
    $selectedBgColor2 = $bgColor2Options[0];
}

// Inclusions indispensables, ne pas toucher
if (file_exists("config/config.php")) include "config/config.php";
if (file_exists("config/Bconfig.php")) include "config/Bconfig.php";
include "include/tools.php";
include "include/functions.php";
include "include/init.php";
include "version.php";

// Début du HTML
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
      <title><?php echo getConfigItem("Info", "Name", $configs); ?> - Reflecteur-YSF Tableau-De-Bord VA2VDC</title>

      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <meta name="description" content="YSF-Reflecteur Tableau de Bord Fr Par VA2VDC">
      <meta name="author" content="DG9VH, KC1AWV, VA2VDC">
      <meta http-equiv="refresh" content="<?php echo REFRESHAFTER; ?>">
  <!-- So refresh works every time -->
      <meta http-equiv="expires" content="0">

<style>
  :root {
    --BGround-color2: <?= $bgColor2 ?>;
    --BGround-color0: <?= $bgColor0 ?>;
  }
</style>



  <!-- Bootstrap core CSS -->
      <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
      <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">

  <!-- Bootstrap core JavaScript -->
  <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>

  <!-- Datatables -->
      <link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">

  <!-- Inclure le script de la librairie emoji-picker-element -->
      <!-- script type="module" src="https://cdn.jsdelivr.net/npm/emoji-picker-element@^1/index.js"></script --> 
  <script type="module" src="/js/index.js"></script>

  <script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>

    <!-- Le reste de ta partie head -->
    <link rel="stylesheet" href="/css/custom.css.php?v=<?=filemtime(__DIR__.'/css/custom.css.php')?>">
    <link rel="stylesheet" href="/css/custom.css">
</head>

<body class="navbar" style="background-color: #131414; color: #FF2222;2">
<!-- Ton contenu HTML -->
<?php
if ($bgColor0 == "#030304") {
    $ColorA = "#F0804F";
    $ColorB = "#E8301F";
    $ColorC = "#50505F";
} elseif ($bgColor0 == "#074C88") {
    $ColorA = "#F0F0FF";
    $ColorB = "#30A0FF";
    $ColorC = "#A0A0AF";
} else {
    $ColorA = "#001048";
    $ColorB = "#481000";
    $ColorC = "#50505F";
}
?>

 <!-- Navigation ------------------------------------------------------   -->
<?php checkSetup(); ?>
 <!-- Page Content  ------------------- Haut de Page -------------------------------------------------  -->
<div class="boz">
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor0 ?>; color: #9090DC"> <!-- fixed-top  or static-top   -->
    <div class="container-fluid" style=" color: #9090DF";>
      <span class="float:left">
        <a class="navbar-brand" href="#" style=" color: <?= $ColorA ?>";>-Reflecteur-YSF- <?php echo getConfigItem("Info", "Name", $configs); ?> / <?php echo getConfigItem("Info", "Description", $configs); ?> (#<?php echo getConfigItem("Info", "Id", $configs); ?>)</a>
      </span>
      <span class="navbar-brand float:center" style=" color: <?= $ColorC ?>";>
        <a id="chatLink" target="_new" href="/log/VisitesIP.txt" style=" color: <?= $ColorC ?>";>Version: </a><a id="chatLink" target="_new" href="/log/Visites.log" style=" color: <?= $ColorC ?>";><?php  echo getYSFReflectorVersion(); ?></a>
      </span>
      <span class="navbar-brand float:right" style=" color: <?= $ColorB ?>";>
     <a id="chatLink" target="_new" href="/couleurs.php" style=" color: <?= $ColorB ?>";>  System Fusion IP </a>
     </span>
    </div>
  </nav>

 <!-- Page Content  ------------------- Tx Info / logo  -----------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
    <div class="container-fluid">
     <div class="col-12">

       <div class="ROW couleur1-forcee">
        <div class="flex-container1">

          <div class="boxy">
               <!--   <span class="navbar-brand float:center"> -->
          <?php
             include "include/txinfo.php";
          ?>
              <!--   </span> -->
          </div>

            <!-- Page Content  -- Col ------ Logo ----------  -->
          <div class="col-2.4">
           <div class="boxy">
                   <!--   <span class="navbar-brand float:right">  title="T l charger le PNG OU PDF OU Ect..."   -->
           <?php if (LOGO !== "") { ?>
           <!--   <a href="DlFiles/YSF_VE2RXY_BACKUP.img" download="YSF_VE2RXY_BACKUP.img">  -->
           <a id="chatLink" target="_new" href="/DlFiles/">
           <!--   <a href="DlFiles/" download="DownLoadDir"> -->
           <img src="<?php echo LOGO ?>" width="220px" height="250" style="width:220px; border-radius:15px; box-shadow: 0px 0px 10px 3px #000; padding:2px; background:#404040;" border="3" hspace="5" vspace="5" align="justify-content-left">
           </a>
           <?php } else { ?>
                 <h3 class="text-center">YSF-Reflecteur<br />Tableau-De-Bord</h3>
           <?php } ?>
                <!--   </span> -->
           </div>
         </div>
       </div>
       </div>
    </div>
  </div>
 </nav>

 <!-- Page Content  ------------------- Info / System / Chat --------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
   <div class="container-fluid">
    <div class="col-12">
     <div class="ROW couleur2-forcee">

      <div class="flex-container">
       <div class="box"><?php include "include/sysinfo.php"; ?></div>

            <!-- Page Content  -- Col ------ Chat ---------  -->
       <div class="col">
	 <?php
	     $unread = file_exists(__DIR__ . "/SMessages_Readed.txt") ? file_get_contents(__DIR__ . "/SMessages_Readed.txt") : "0";
	 if ($unread == "1") {
	     $css_class = "clignote1";
	 } else if ($unread == "2") {
	     $css_class = "clignote2";
	 } else if ($unread == "3") {
	     $css_class = "clignote3";
	 } else if ($unread == "4") {
	     $css_class = "clignote4";
	 } else if ($unread >= "5") {
	     $css_class = "clignote5";
	 } else {
	     $css_class = "";
	 }
 	 ?>
          <div class="box" nowrap>
           <button id="btChanger1" class="col-9" style="box-shadow: 0px 0px 10px 3px #000;"> Info / Systeme / <a id="chatLink" target="_new" href="/chatme.php" class="<?php echo $css_class; ?>"> Chat <?php if ($unread =="0") {"";} else {echo $unread;} ?></a> </button>
           <div id="LstBulle" class="col8" style="box-shadow: 0px 0px 10px 3px #000; border-radius: 15px;"></div>
          </div>
        </div>
       </div>

       <script>
          let fichiers1 = [];
          let index1 = 0;
         function chargerLstBulle() {
          if (fichiers1.length === 0) return; // S curit  si fichiers pas charges
             fetch('loaderBulle.php?fichier1=' + fichiers1[index1])
             .then(response1 => response1.text())
             .then(html => {
             document.getElementById('LstBulle').innerHTML = html;
           });
         }
          fetch('LstBulles.php')
          .then(response1 => response1.json())
          .then(data => {
             fichiers1 = data;       // On remplace la liste statique par la liste du serveur
             chargerLstBulle();      // On charge la premi re infobulle
          });
        document.getElementById('btChanger1').addEventListener('click', function() {
          index1 = (index1 + 1) % fichiers1.length;
          chargerLstBulle();
        });
      </script>

    </div>
   </div>
  </div>
 </nav>

 <!-- Page Content  ------------------- Passerelle GW ---------------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
     <div class="container-fluid">
      <div class="col-12"><div class="row" style="size:210;"><div class="col"><?php include "include/gateways.php"; ?></div></div></div>
     </div>
  </nav>

 <!-- Page Content  ------------------- LH ---------------------------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
     <div class="container-fluid">
      <div class="col-12"><div class="row" style="size:210;"><div class="col"><?php include "include/lh.php"; ?></div></div></div>

  </nav>

 <!-- Page Content  ------------------- ALL HEARD --------------------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
    <div class="container-fluid">
     <div class="col-12"><div class="row" style="size:210;"><div class="col"><?php include "include/allheard.php"; ?></div></div></div>

  </nav>

 <!-- Page Content  ------------------- OLD HEARD LstALL -------------------------------------------------  -->
  <nav class="navbar navbar-expand-lg navbar-dark static-top" style="background-color: <?= $bgColor2 ?>;">
    <div class="container-fluid">

     <div class="col-12"><div class="row" style="size:210;"><div class="col">
      <button id="changer3" style="background-color: #437A8A; color: #B9EFFF; font-size: 1.8em; text-shadow: 1px 1px 4px #011; padding: 3px 35px 3px 35px; box-shadow: 0px 0px 10px 3px #000; border-radius:10px;">List de Tous Les Temps</button>
       <div id="LstAll"></div>

        <script>
           let fichiers3 = [];
           let index3 = 0;
         function chargerLstAll() {
          if (fichiers3.length === 0) return; // S curit  si fichiers pas charg s
            fetch('loaderAll.php?fichier3=' + fichiers3[index3])
            .then(response3 => response3.text())
            .then(html => {
               document.getElementById('LstAll').innerHTML = html;
            });
          }
           fetch('LstAlls.php')
           .then(response3 => response3.json())
           .then(data => {
              fichiers3 = data;   // On remplace la liste statique par la liste du serveur
              chargerLstAll();    // On charge la premi re infobulle
           });
           document.getElementById('changer3').addEventListener('click', function() {
              index3 = (index3 + 1) % fichiers3.length;
              chargerLstAll();
           });
       </script>
     </div></div></div>

  </nav>

        <!-- Datatables -------- table.datatable   ----   .datatable     table  class=table datatable    ----------     -->
        <!-- Datatables ------------   .datatable    #montableauId           table  class=table datatable    ----  #dataTables_wrapper    .DataTable  ------     -->

      <script type="text/javascript">
       $('#tables').DataTable({
          language: {
            processing:     "Traitement en cours ...",
            search:         "Rechercher :",
            lengthMenu:     "Afficher _MENU_ elements",
            info:           "Affichage de l element _START_ a _END_ sur _TOTAL_ elements",
            infoEmpty:      "Affichage de l element 0 a 0 sur 0 elements",
            infoFiltred:    "(filtre de _MAX_ element au total)",
            loadingRecords: "Chargement en cours ....",
            zeroRecords:    "Aucun element a afficher",
            emptyTable:     "Aucune donnee disponible dans le tableau",

            paginate: {
              first:      "Premier",
              previous:   "Precedent",
              next:       "Suivant",
              last:       "Dernier"
                      },
          aria: {
            sortAscending:     ": activer pour trier la colonne par ordre croissant",
            sortDescending:    ": activer pour trier la colonne par ordre decroissant"
                }
          }
       });
     </script>

 <!-- Page Content  -------------------- Bas De Page -----------------------------------------------------  -->
     <nav class="flex-container" style="background-color: #484A4A; color: #9090DC">
      <div class="flex-container" style="background-color: #484A4A; color: #FFF8EF;">
       <?php
        $lastReload = new DateTime();
        $lastReload->setTimezone(new DateTimeZone(TIMEZONE));
        echo "YSF-Dashboard Ver.: ".VERSION." | M.a.J. le : ".$lastReload->format('d-m-Y,  H:i:s')." (".TIMEZONE.")";
       ?> | <a href="<?php 
       if (!file_exists('YSF_D_Board-FR.tar.gz')) { 
           echo"http://amiatous.ddns.net:8081/indexC.php";
       } else { 
           echo "YSF_D_Board-FR.tar.gz";
              }
       ?>">Votre Copie Ici:</a> <-Fr-  -En-> <a href="https://github.com/dg9vh/YSFReflector-Dashboard"> DG9VH YSFReflector-Dashboard </a><a id="chatLink" target="_new" href="/couleurs.php"> . </a>
     </div>
    </nav>

   <p><?php
$finish = microtime(true);
$total_time = round(($finish - $start), 4);
echo "<br><p style='text-align: center; font-size: 1.5em; color: #15FDE0;'>Page produite en -> " . $total_time . " <- Secondes.</p>";
echo "<p style='text-align: center; font-size: 1.2em;'>Nombre de visites : " . $count . "</p>";
?></p><br>

  </div><!--  Container last div  -->
 </body>
</html>
