document.addEventListener("DOMContentLoaded", () => {

  const NumberSnows = ["3", "5", "7"];
  const snowCount = NumberSnows[Math.floor(Math.random() * NumberSnows.length)];

  const pictures = [
    "/js/img/Logo-AntBig64.png",  // fixe, pas de rotation
    "/js/img/Floccon49.png"
  ];

  const snowDistance = "pageheight";
  const rotationSpeedFactor = 0.4;
  let snowflakes = [];
  let snowTimer;

  const snowContainer = document.createElement("div");
  Object.assign(snowContainer.style, {
    position: "fixed",
    top: "0",
    left: "0",
    width: "100%",
    height: "100%",
    pointerEvents: "none",
    zIndex: "999"
  });
  document.body.appendChild(snowContainer);

  for (let i = 0; i < snowCount; i++) {
    const flake = document.createElement("img");
    const snowImg = pictures[Math.floor(Math.random() * pictures.length)];
    flake.src = snowImg;
    flake.style.position = "absolute";

    const size = 80 + Math.random() * 180;
    flake.style.width = `${size}px`;
    flake.style.height = `${size}px`;
    flake.style.top = `${Math.random() * window.innerHeight}px`;
    flake.style.left = `${Math.random() * window.innerWidth}px`;
    flake.style.userSelect = "none";

    const colors = ["#ffffff", "#b6d6f7", "#2196f3", "#fff7cc", "#cff0fc"];
    flake.style.filter = `drop-shadow(0 0 5px ${colors[Math.floor(Math.random() * colors.length)]})`;
    flake.style.opacity = 0.5 + Math.random() * 0.5;

    snowContainer.appendChild(flake);

    const isStatic = flake.src.includes("Logo-AntBig64.png"); // détecte le logo

    snowflakes.push({
      element: flake,
      x: Math.random() * window.innerWidth,
      y: Math.random() * window.innerHeight,
      amplitude: 16 + Math.random() * 33,
      dx: 0,
      stx: 0.000000003 + Math.random() / 180,
      sty: 0.345 + Math.random() * 0.6,
      wind: 0.04 + Math.random() * 0.00000512,
      rotateSpeed: isStatic ? 0 : (Math.random() > 0.5 ? 1 : -1) * (0.05 + Math.random() * 0.25) * rotationSpeedFactor,
      rotation: isStatic ? 0 : Math.random() * 360, // angle fixe pour le logo
      isStatic
    });
  }

  let lastTime = performance.now();

  function animateSnow() {
    const now = performance.now();
    const deltaTime = (now - lastTime) / 9.67;
    lastTime = now;

    const width = snowDistance === "windowheight" ? window.innerWidth : document.documentElement.scrollWidth;
    const height = snowDistance === "windowheight" ? window.innerHeight : Math.max(document.body.scrollHeight, window.innerHeight);

    snowflakes.forEach(flake => {
      flake.y += flake.sty * deltaTime;
      flake.x += flake.wind * deltaTime;

      if (flake.y > height - 10) {
        flake.x = Math.random() * width;
        flake.y = 0;
      }
      if (flake.x > width) flake.x = 0;

      flake.dx += flake.stx;
      flake.rotation += flake.rotateSpeed * (deltaTime / 16);

      const leftPos = flake.x + flake.amplitude * Math.sin(flake.dx);
      const scaleValue = 0.7 + 0.3 * Math.sin(flake.dx);

      flake.element.style.top = `${flake.y}px`;
      flake.element.style.left = `${leftPos}px`;

      // --- Logo fixe (pas de rotation) ---
      if (flake.isStatic) {
        flake.element.style.transform = `scale(${scaleValue})`; 
      } else {
        flake.element.style.transform = `translateZ(0) rotate(${flake.rotation}deg) scale(${scaleValue})`;
      }
    });

    snowTimer = requestAnimationFrame(animateSnow);
  }

  lastTime = performance.now();
  animateSnow();
});
